/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.maphero.android.log.Logger;
import org.maphero.android.maps.MapView;
import org.maphero.android.maps.NativeMapView;
import org.maphero.android.tile.TileOperation;

class MapChangeReceiver
implements NativeMapView.StateCallback {
    private static final String TAG = "Mbgl-MapChangeReceiver";
    private final List<MapView.OnCameraWillChangeListener> onCameraWillChangeListenerList = new CopyOnWriteArrayList<MapView.OnCameraWillChangeListener>();
    private final List<MapView.OnCameraIsChangingListener> onCameraIsChangingListenerList = new CopyOnWriteArrayList<MapView.OnCameraIsChangingListener>();
    private final List<MapView.OnCameraDidChangeListener> onCameraDidChangeListenerList = new CopyOnWriteArrayList<MapView.OnCameraDidChangeListener>();
    private final List<MapView.OnWillStartLoadingMapListener> onWillStartLoadingMapListenerList = new CopyOnWriteArrayList<MapView.OnWillStartLoadingMapListener>();
    private final List<MapView.OnDidFinishLoadingMapListener> onDidFinishLoadingMapListenerList = new CopyOnWriteArrayList<MapView.OnDidFinishLoadingMapListener>();
    private final List<MapView.OnDidFailLoadingMapListener> onDidFailLoadingMapListenerList = new CopyOnWriteArrayList<MapView.OnDidFailLoadingMapListener>();
    private final List<MapView.OnWillStartRenderingFrameListener> onWillStartRenderingFrameList = new CopyOnWriteArrayList<MapView.OnWillStartRenderingFrameListener>();
    private final List<MapView.OnDidFinishRenderingFrameListener> onDidFinishRenderingFrameList = new CopyOnWriteArrayList<MapView.OnDidFinishRenderingFrameListener>();
    private final List<MapView.OnWillStartRenderingMapListener> onWillStartRenderingMapListenerList = new CopyOnWriteArrayList<MapView.OnWillStartRenderingMapListener>();
    private final List<MapView.OnDidFinishRenderingMapListener> onDidFinishRenderingMapListenerList = new CopyOnWriteArrayList<MapView.OnDidFinishRenderingMapListener>();
    private final List<MapView.OnDidBecomeIdleListener> onDidBecomeIdleListenerList = new CopyOnWriteArrayList<MapView.OnDidBecomeIdleListener>();
    private final List<MapView.OnDidFinishLoadingStyleListener> onDidFinishLoadingStyleListenerList = new CopyOnWriteArrayList<MapView.OnDidFinishLoadingStyleListener>();
    private final List<MapView.OnSourceChangedListener> onSourceChangedListenerList = new CopyOnWriteArrayList<MapView.OnSourceChangedListener>();
    private final List<MapView.OnStyleImageMissingListener> onStyleImageMissingListenerList = new CopyOnWriteArrayList<MapView.OnStyleImageMissingListener>();
    private final List<MapView.OnCanRemoveUnusedStyleImageListener> onCanRemoveUnusedStyleImageListenerList = new CopyOnWriteArrayList<MapView.OnCanRemoveUnusedStyleImageListener>();
    private final List<MapView.OnPreCompileShaderListener> onPreCompileShaderList = new CopyOnWriteArrayList<MapView.OnPreCompileShaderListener>();
    private final List<MapView.OnPostCompileShaderListener> onPostCompileShaderList = new CopyOnWriteArrayList<MapView.OnPostCompileShaderListener>();
    private final List<MapView.OnShaderCompileFailedListener> onShaderCompileFailedList = new CopyOnWriteArrayList<MapView.OnShaderCompileFailedListener>();
    private final List<MapView.OnGlyphsLoadedListener> onGlyphsLoadedList = new CopyOnWriteArrayList<MapView.OnGlyphsLoadedListener>();
    private final List<MapView.OnGlyphsErrorListener> onGlyphsErrorList = new CopyOnWriteArrayList<MapView.OnGlyphsErrorListener>();
    private final List<MapView.OnGlyphsRequestedListener> onGlyphsRequestedList = new CopyOnWriteArrayList<MapView.OnGlyphsRequestedListener>();
    private final List<MapView.OnTileActionListener> onTileActionList = new CopyOnWriteArrayList<MapView.OnTileActionListener>();
    private final List<MapView.OnSpriteLoadedListener> onSpriteLoadedList = new CopyOnWriteArrayList<MapView.OnSpriteLoadedListener>();
    private final List<MapView.OnSpriteErrorListener> onSpriteErrorList = new CopyOnWriteArrayList<MapView.OnSpriteErrorListener>();
    private final List<MapView.OnSpriteRequestedListener> onSpriteRequestedList = new CopyOnWriteArrayList<MapView.OnSpriteRequestedListener>();

    MapChangeReceiver() {
    }

    @Override
    public void onCameraWillChange(boolean animated) {
        try {
            if (!this.onCameraWillChangeListenerList.isEmpty()) {
                for (MapView.OnCameraWillChangeListener onCameraWillChangeListener : this.onCameraWillChangeListenerList) {
                    onCameraWillChangeListener.onCameraWillChange(animated);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCameraWillChange", err);
            throw err;
        }
    }

    @Override
    public void onCameraIsChanging() {
        try {
            if (!this.onCameraIsChangingListenerList.isEmpty()) {
                for (MapView.OnCameraIsChangingListener onCameraIsChangingListener : this.onCameraIsChangingListenerList) {
                    onCameraIsChangingListener.onCameraIsChanging();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCameraIsChanging", err);
            throw err;
        }
    }

    @Override
    public void onCameraDidChange(boolean animated) {
        try {
            if (!this.onCameraDidChangeListenerList.isEmpty()) {
                for (MapView.OnCameraDidChangeListener onCameraDidChangeListener : this.onCameraDidChangeListenerList) {
                    onCameraDidChangeListener.onCameraDidChange(animated);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCameraDidChange", err);
            throw err;
        }
    }

    @Override
    public void onWillStartLoadingMap() {
        try {
            if (!this.onWillStartLoadingMapListenerList.isEmpty()) {
                for (MapView.OnWillStartLoadingMapListener onWillStartLoadingMapListener : this.onWillStartLoadingMapListenerList) {
                    onWillStartLoadingMapListener.onWillStartLoadingMap();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onWillStartLoadingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishLoadingMap() {
        try {
            if (!this.onDidFinishLoadingMapListenerList.isEmpty()) {
                for (MapView.OnDidFinishLoadingMapListener onDidFinishLoadingMapListener : this.onDidFinishLoadingMapListenerList) {
                    onDidFinishLoadingMapListener.onDidFinishLoadingMap();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishLoadingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidFailLoadingMap(String error) {
        try {
            if (!this.onDidFailLoadingMapListenerList.isEmpty()) {
                for (MapView.OnDidFailLoadingMapListener onDidFailLoadingMapListener : this.onDidFailLoadingMapListenerList) {
                    onDidFailLoadingMapListener.onDidFailLoadingMap(error);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFailLoadingMap", err);
            throw err;
        }
    }

    @Override
    public void onWillStartRenderingFrame() {
        try {
            if (!this.onWillStartRenderingFrameList.isEmpty()) {
                for (MapView.OnWillStartRenderingFrameListener listener : this.onWillStartRenderingFrameList) {
                    listener.onWillStartRenderingFrame();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onWillStartRenderingFrame", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishRenderingFrame(boolean fully, double frameEncodingTime, double frameRenderingTime) {
        try {
            if (!this.onDidFinishRenderingFrameList.isEmpty()) {
                for (MapView.OnDidFinishRenderingFrameListener listener : this.onDidFinishRenderingFrameList) {
                    listener.onDidFinishRenderingFrame(fully, frameEncodingTime, frameRenderingTime);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishRenderingFrame", err);
            throw err;
        }
    }

    @Override
    public void onWillStartRenderingMap() {
        try {
            if (!this.onWillStartRenderingMapListenerList.isEmpty()) {
                for (MapView.OnWillStartRenderingMapListener listener : this.onWillStartRenderingMapListenerList) {
                    listener.onWillStartRenderingMap();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onWillStartRenderingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishRenderingMap(boolean fully) {
        try {
            if (!this.onDidFinishRenderingMapListenerList.isEmpty()) {
                for (MapView.OnDidFinishRenderingMapListener listener : this.onDidFinishRenderingMapListenerList) {
                    listener.onDidFinishRenderingMap(fully);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishRenderingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidBecomeIdle() {
        try {
            if (!this.onDidBecomeIdleListenerList.isEmpty()) {
                for (MapView.OnDidBecomeIdleListener listener : this.onDidBecomeIdleListenerList) {
                    listener.onDidBecomeIdle();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidBecomeIdle", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishLoadingStyle() {
        try {
            if (!this.onDidFinishLoadingStyleListenerList.isEmpty()) {
                for (MapView.OnDidFinishLoadingStyleListener listener : this.onDidFinishLoadingStyleListenerList) {
                    listener.onDidFinishLoadingStyle();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishLoadingStyle", err);
            throw err;
        }
    }

    @Override
    public void onSourceChanged(String sourceId) {
        try {
            if (!this.onSourceChangedListenerList.isEmpty()) {
                for (MapView.OnSourceChangedListener onSourceChangedListener : this.onSourceChangedListenerList) {
                    onSourceChangedListener.onSourceChangedListener(sourceId);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onSourceChanged", err);
            throw err;
        }
    }

    @Override
    public void onStyleImageMissing(String imageId) {
        try {
            if (!this.onStyleImageMissingListenerList.isEmpty()) {
                for (MapView.OnStyleImageMissingListener listener : this.onStyleImageMissingListenerList) {
                    listener.onStyleImageMissing(imageId);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onStyleImageMissing", err);
            throw err;
        }
    }

    @Override
    public boolean onCanRemoveUnusedStyleImage(String imageId) {
        if (this.onCanRemoveUnusedStyleImageListenerList.isEmpty()) {
            return true;
        }
        try {
            if (!this.onCanRemoveUnusedStyleImageListenerList.isEmpty()) {
                boolean canRemove = true;
                for (MapView.OnCanRemoveUnusedStyleImageListener listener : this.onCanRemoveUnusedStyleImageListenerList) {
                    canRemove &= listener.onCanRemoveUnusedStyleImage(imageId);
                }
                return canRemove;
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCanRemoveUnusedStyleImage", err);
            throw err;
        }
        return true;
    }

    @Override
    public void onPreCompileShader(int id2, int type, String additionalDefines) {
        try {
            if (!this.onPreCompileShaderList.isEmpty()) {
                for (MapView.OnPreCompileShaderListener listener : this.onPreCompileShaderList) {
                    listener.onPreCompileShader(id2, type, additionalDefines);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onPreCompileShader", err);
            throw err;
        }
    }

    @Override
    public void onPostCompileShader(int id2, int type, String additionalDefines) {
        try {
            if (!this.onPostCompileShaderList.isEmpty()) {
                for (MapView.OnPostCompileShaderListener listener : this.onPostCompileShaderList) {
                    listener.onPostCompileShader(id2, type, additionalDefines);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onPostCompileShader", err);
            throw err;
        }
    }

    @Override
    public void onShaderCompileFailed(int id2, int type, String additionalDefines) {
        try {
            if (!this.onShaderCompileFailedList.isEmpty()) {
                for (MapView.OnShaderCompileFailedListener listener : this.onShaderCompileFailedList) {
                    listener.onShaderCompileFailed(id2, type, additionalDefines);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onShaderCompileFailed", err);
            throw err;
        }
    }

    @Override
    public void onGlyphsLoaded(String[] stack, int rangeStart, int rangeEnd) {
        try {
            if (!this.onGlyphsLoadedList.isEmpty()) {
                for (MapView.OnGlyphsLoadedListener listener : this.onGlyphsLoadedList) {
                    listener.onGlyphsLoaded(stack, rangeStart, rangeEnd);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onGlyphsLoaded", err);
            throw err;
        }
    }

    @Override
    public void onGlyphsError(String[] stack, int rangeStart, int rangeEnd) {
        try {
            if (!this.onGlyphsErrorList.isEmpty()) {
                for (MapView.OnGlyphsErrorListener listener : this.onGlyphsErrorList) {
                    listener.onGlyphsError(stack, rangeStart, rangeEnd);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onGlyphsError", err);
            throw err;
        }
    }

    @Override
    public void onGlyphsRequested(String[] stack, int rangeStart, int rangeEnd) {
        try {
            if (!this.onGlyphsRequestedList.isEmpty()) {
                for (MapView.OnGlyphsRequestedListener listener : this.onGlyphsRequestedList) {
                    listener.onGlyphsRequested(stack, rangeStart, rangeEnd);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onGlyphsRequested", err);
            throw err;
        }
    }

    @Override
    public void onTileAction(TileOperation op, int x, int y, int z, int wrap, int overscaledZ, String sourceID) {
        try {
            if (!this.onTileActionList.isEmpty()) {
                for (MapView.OnTileActionListener listener : this.onTileActionList) {
                    listener.onTileAction(op, x, y, z, wrap, overscaledZ, sourceID);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onTileAction", err);
            throw err;
        }
    }

    @Override
    public void onSpriteLoaded(String id2, String url) {
        try {
            if (!this.onSpriteLoadedList.isEmpty()) {
                for (MapView.OnSpriteLoadedListener listener : this.onSpriteLoadedList) {
                    listener.onSpriteLoaded(id2, url);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onSpriteLoaded", err);
            throw err;
        }
    }

    @Override
    public void onSpriteError(String id2, String url) {
        try {
            if (!this.onSpriteErrorList.isEmpty()) {
                for (MapView.OnSpriteErrorListener listener : this.onSpriteErrorList) {
                    listener.onSpriteError(id2, url);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onSpriteError", err);
            throw err;
        }
    }

    @Override
    public void onSpriteRequested(String id2, String url) {
        try {
            if (!this.onSpriteRequestedList.isEmpty()) {
                for (MapView.OnSpriteRequestedListener listener : this.onSpriteRequestedList) {
                    listener.onSpriteRequested(id2, url);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onSpriteRequested", err);
            throw err;
        }
    }

    void addOnCameraWillChangeListener(MapView.OnCameraWillChangeListener listener) {
        this.onCameraWillChangeListenerList.add(listener);
    }

    void removeOnCameraWillChangeListener(MapView.OnCameraWillChangeListener listener) {
        this.onCameraWillChangeListenerList.remove(listener);
    }

    void addOnCameraIsChangingListener(MapView.OnCameraIsChangingListener listener) {
        this.onCameraIsChangingListenerList.add(listener);
    }

    void removeOnCameraIsChangingListener(MapView.OnCameraIsChangingListener listener) {
        this.onCameraIsChangingListenerList.remove(listener);
    }

    void addOnCameraDidChangeListener(MapView.OnCameraDidChangeListener listener) {
        this.onCameraDidChangeListenerList.add(listener);
    }

    void removeOnCameraDidChangeListener(MapView.OnCameraDidChangeListener listener) {
        this.onCameraDidChangeListenerList.remove(listener);
    }

    void addOnWillStartLoadingMapListener(MapView.OnWillStartLoadingMapListener listener) {
        this.onWillStartLoadingMapListenerList.add(listener);
    }

    void removeOnWillStartLoadingMapListener(MapView.OnWillStartLoadingMapListener listener) {
        this.onWillStartLoadingMapListenerList.remove(listener);
    }

    void addOnDidFinishLoadingMapListener(MapView.OnDidFinishLoadingMapListener listener) {
        this.onDidFinishLoadingMapListenerList.add(listener);
    }

    void removeOnDidFinishLoadingMapListener(MapView.OnDidFinishLoadingMapListener listener) {
        this.onDidFinishLoadingMapListenerList.remove(listener);
    }

    void addOnDidFailLoadingMapListener(MapView.OnDidFailLoadingMapListener listener) {
        this.onDidFailLoadingMapListenerList.add(listener);
    }

    void removeOnDidFailLoadingMapListener(MapView.OnDidFailLoadingMapListener listener) {
        this.onDidFailLoadingMapListenerList.remove(listener);
    }

    void addOnWillStartRenderingFrameListener(MapView.OnWillStartRenderingFrameListener listener) {
        this.onWillStartRenderingFrameList.add(listener);
    }

    void removeOnWillStartRenderingFrameListener(MapView.OnWillStartRenderingFrameListener listener) {
        this.onWillStartRenderingFrameList.remove(listener);
    }

    void addOnDidFinishRenderingFrameListener(MapView.OnDidFinishRenderingFrameListener listener) {
        this.onDidFinishRenderingFrameList.add(listener);
    }

    void removeOnDidFinishRenderingFrameListener(MapView.OnDidFinishRenderingFrameListener listener) {
        this.onDidFinishRenderingFrameList.remove(listener);
    }

    void addOnWillStartRenderingMapListener(MapView.OnWillStartRenderingMapListener listener) {
        this.onWillStartRenderingMapListenerList.add(listener);
    }

    void removeOnWillStartRenderingMapListener(MapView.OnWillStartRenderingMapListener listener) {
        this.onWillStartRenderingMapListenerList.remove(listener);
    }

    void addOnDidFinishRenderingMapListener(MapView.OnDidFinishRenderingMapListener listener) {
        this.onDidFinishRenderingMapListenerList.add(listener);
    }

    void removeOnDidFinishRenderingMapListener(MapView.OnDidFinishRenderingMapListener listener) {
        this.onDidFinishRenderingMapListenerList.remove(listener);
    }

    void addOnDidBecomeIdleListener(MapView.OnDidBecomeIdleListener listener) {
        this.onDidBecomeIdleListenerList.add(listener);
    }

    void removeOnDidBecomeIdleListener(MapView.OnDidBecomeIdleListener listener) {
        this.onDidBecomeIdleListenerList.remove(listener);
    }

    void addOnDidFinishLoadingStyleListener(MapView.OnDidFinishLoadingStyleListener listener) {
        this.onDidFinishLoadingStyleListenerList.add(listener);
    }

    void removeOnDidFinishLoadingStyleListener(MapView.OnDidFinishLoadingStyleListener listener) {
        this.onDidFinishLoadingStyleListenerList.remove(listener);
    }

    void addOnSourceChangedListener(MapView.OnSourceChangedListener listener) {
        this.onSourceChangedListenerList.add(listener);
    }

    void removeOnSourceChangedListener(MapView.OnSourceChangedListener listener) {
        this.onSourceChangedListenerList.remove(listener);
    }

    void addOnStyleImageMissingListener(MapView.OnStyleImageMissingListener listener) {
        this.onStyleImageMissingListenerList.add(listener);
    }

    void removeOnStyleImageMissingListener(MapView.OnStyleImageMissingListener listener) {
        this.onStyleImageMissingListenerList.remove(listener);
    }

    void addOnCanRemoveUnusedStyleImageListener(MapView.OnCanRemoveUnusedStyleImageListener listener) {
        this.onCanRemoveUnusedStyleImageListenerList.add(listener);
    }

    void removeOnCanRemoveUnusedStyleImageListener(MapView.OnCanRemoveUnusedStyleImageListener listener) {
        this.onCanRemoveUnusedStyleImageListenerList.remove(listener);
    }

    public void addOnPreCompileShaderListener(MapView.OnPreCompileShaderListener callback) {
        this.onPreCompileShaderList.add(callback);
    }

    public void addOnPostCompileShaderListener(MapView.OnPostCompileShaderListener callback) {
        this.onPostCompileShaderList.add(callback);
    }

    public void addOnShaderCompileFailedListener(MapView.OnShaderCompileFailedListener callback) {
        this.onShaderCompileFailedList.add(callback);
    }

    public void addOnGlyphsLoadedListener(MapView.OnGlyphsLoadedListener callback) {
        this.onGlyphsLoadedList.add(callback);
    }

    public void addOnGlyphsErrorListener(MapView.OnGlyphsErrorListener callback) {
        this.onGlyphsErrorList.add(callback);
    }

    public void addOnGlyphsRequestedListener(MapView.OnGlyphsRequestedListener callback) {
        this.onGlyphsRequestedList.add(callback);
    }

    public void addOnTileActionListener(MapView.OnTileActionListener callback) {
        this.onTileActionList.add(callback);
    }

    public void addOnSpriteLoadedListener(MapView.OnSpriteLoadedListener callback) {
        this.onSpriteLoadedList.add(callback);
    }

    public void addOnSpriteErrorListener(MapView.OnSpriteErrorListener callback) {
        this.onSpriteErrorList.add(callback);
    }

    public void addOnSpriteRequestedListener(MapView.OnSpriteRequestedListener callback) {
        this.onSpriteRequestedList.add(callback);
    }

    public void removeOnPreCompileShaderListener(MapView.OnPreCompileShaderListener callback) {
        this.onPreCompileShaderList.remove(callback);
    }

    public void removeOnPostCompileShaderListener(MapView.OnPostCompileShaderListener callback) {
        this.onPostCompileShaderList.remove(callback);
    }

    public void removeOnShaderCompileFailedListener(MapView.OnShaderCompileFailedListener callback) {
        this.onShaderCompileFailedList.remove(callback);
    }

    public void removeOnGlyphsLoadedListener(MapView.OnGlyphsLoadedListener callback) {
        this.onGlyphsLoadedList.remove(callback);
    }

    public void removeOnGlyphsErrorListener(MapView.OnGlyphsErrorListener callback) {
        this.onGlyphsErrorList.remove(callback);
    }

    public void removeOnGlyphsRequestedListener(MapView.OnGlyphsRequestedListener callback) {
        this.onGlyphsRequestedList.remove(callback);
    }

    public void removeOnTileActionListener(MapView.OnTileActionListener callback) {
        this.onTileActionList.remove(callback);
    }

    public void removeOnSpriteLoadedListener(MapView.OnSpriteLoadedListener callback) {
        this.onSpriteLoadedList.remove(callback);
    }

    public void removeOnSpriteErrorListener(MapView.OnSpriteErrorListener callback) {
        this.onSpriteErrorList.remove(callback);
    }

    public void removeOnSpriteRequestedListener(MapView.OnSpriteRequestedListener callback) {
        this.onSpriteRequestedList.remove(callback);
    }

    void clear() {
        this.onCameraWillChangeListenerList.clear();
        this.onCameraIsChangingListenerList.clear();
        this.onCameraDidChangeListenerList.clear();
        this.onWillStartLoadingMapListenerList.clear();
        this.onDidFinishLoadingMapListenerList.clear();
        this.onDidFailLoadingMapListenerList.clear();
        this.onWillStartRenderingFrameList.clear();
        this.onDidFinishRenderingFrameList.clear();
        this.onWillStartRenderingMapListenerList.clear();
        this.onDidFinishRenderingMapListenerList.clear();
        this.onDidBecomeIdleListenerList.clear();
        this.onDidFinishLoadingStyleListenerList.clear();
        this.onSourceChangedListenerList.clear();
        this.onStyleImageMissingListenerList.clear();
        this.onCanRemoveUnusedStyleImageListenerList.clear();
        this.onPreCompileShaderList.clear();
        this.onPostCompileShaderList.clear();
        this.onShaderCompileFailedList.clear();
        this.onGlyphsLoadedList.clear();
        this.onGlyphsErrorList.clear();
        this.onGlyphsRequestedList.clear();
        this.onTileActionList.clear();
        this.onSpriteLoadedList.clear();
        this.onSpriteErrorList.clear();
        this.onSpriteRequestedList.clear();
    }
}

