/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.maphero.android.MapHero;
import org.maphero.android.MapStrictMode;
import org.maphero.android.R;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.exceptions.MapHeroConfigurationException;
import org.maphero.android.location.LocationComponent;
import org.maphero.android.maps.AnnotationContainer;
import org.maphero.android.maps.AnnotationManager;
import org.maphero.android.maps.AttributionDialogManager;
import org.maphero.android.maps.CameraChangeDispatcher;
import org.maphero.android.maps.FocalPointChangeListener;
import org.maphero.android.maps.IconManager;
import org.maphero.android.maps.MapChangeReceiver;
import org.maphero.android.maps.MapGestureDetector;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.MapHeroMapOptions;
import org.maphero.android.maps.MapKeyListener;
import org.maphero.android.maps.MarkerContainer;
import org.maphero.android.maps.NativeMap;
import org.maphero.android.maps.NativeMapView;
import org.maphero.android.maps.OnMapReadyCallback;
import org.maphero.android.maps.PolygonContainer;
import org.maphero.android.maps.PolylineContainer;
import org.maphero.android.maps.Projection;
import org.maphero.android.maps.ShapeAnnotationContainer;
import org.maphero.android.maps.Transform;
import org.maphero.android.maps.UiSettings;
import org.maphero.android.maps.renderer.MapRenderer;
import org.maphero.android.maps.widgets.CompassView;
import org.maphero.android.net.ConnectivityReceiver;
import org.maphero.android.storage.FileSource;
import org.maphero.android.tile.TileOperation;
import org.maphero.android.utils.BitmapUtils;
import org.maplibre.android.gestures.AndroidGesturesManager;
import timber.log.Timber;

public class MapView
extends FrameLayout
implements NativeMapView.ViewCallback {
    private final MapChangeReceiver mapChangeReceiver = new MapChangeReceiver();
    private final MapCallback mapCallback = new MapCallback();
    private final InitialRenderCallback initialRenderCallback = new InitialRenderCallback();
    @Nullable
    private NativeMap nativeMapView;
    @Nullable
    private MapHeroMap mapHeroMap;
    private View renderView;
    private AttributionClickListener attributionClickListener;
    MapHeroMapOptions mapHeroMapOptions;
    private MapRenderer mapRenderer;
    private boolean destroyed;
    @Nullable
    private CompassView compassView;
    private PointF focalPoint;
    private final FocalPointInvalidator focalInvalidator = new FocalPointInvalidator();
    private final GesturesManagerInteractionListener registerTouchListener = new GesturesManagerInteractionListener();
    private final CameraChangeDispatcher cameraDispatcher = new CameraChangeDispatcher();
    @Nullable
    private MapGestureDetector mapGestureDetector;
    @Nullable
    private MapKeyListener mapKeyListener;
    @Nullable
    private Bundle savedInstanceState;
    private boolean isStarted;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        Timber.d((String)"MapView constructed with context", (Object[])new Object[0]);
        this.initialize(context, MapHeroMapOptions.createFromAttributes(context));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        Timber.d((String)"MapView constructed with context and attribute set", (Object[])new Object[0]);
        this.initialize(context, MapHeroMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Timber.d((String)"MapView constructed with context, attributeSet and defStyleAttr", (Object[])new Object[0]);
        this.initialize(context, MapHeroMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapHeroMapOptions options) {
        super(context);
        Timber.d((String)"MapView constructed with context and MapHeroMapOptions", (Object[])new Object[0]);
        this.initialize(context, options == null ? MapHeroMapOptions.createFromAttributes(context) : options);
    }

    @CallSuper
    @UiThread
    protected void initialize(@NonNull Context context, @NonNull MapHeroMapOptions options) {
        if (this.isInEditMode()) {
            return;
        }
        if (!MapHero.hasInstance()) {
            throw new MapHeroConfigurationException();
        }
        this.setForeground((Drawable)new ColorDrawable(options.getForegroundLoadColor()));
        this.mapHeroMapOptions = options;
        this.setContentDescription(context.getString(R.string.maphero_mapActionDescription));
        this.setWillNotDraw(false);
        this.initialiseDrawingSurface(options);
    }

    private void initialiseMap() {
        Context context = this.getContext();
        this.focalInvalidator.addListener(this.createFocalPointChangeListener());
        Projection proj = new Projection(this.nativeMapView, this);
        UiSettings uiSettings = new UiSettings(proj, this.focalInvalidator, this.getPixelRatio(), this);
        LongSparseArray annotationsArray = new LongSparseArray();
        IconManager iconManager = new IconManager(this.nativeMapView);
        AnnotationContainer annotations = new AnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        MarkerContainer markers = new MarkerContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray, iconManager);
        PolygonContainer polygons = new PolygonContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        PolylineContainer polylines = new PolylineContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        ShapeAnnotationContainer shapeAnnotations = new ShapeAnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        AnnotationManager annotationManager = new AnnotationManager(this, (LongSparseArray<Annotation>)annotationsArray, iconManager, annotations, markers, polygons, polylines, shapeAnnotations);
        Transform transform = new Transform(this, this.nativeMapView, this.cameraDispatcher);
        ArrayList<MapHeroMap.OnDeveloperAnimationListener> developerAnimationListeners = new ArrayList<MapHeroMap.OnDeveloperAnimationListener>();
        this.mapHeroMap = new MapHeroMap(this.nativeMapView, transform, uiSettings, proj, this.registerTouchListener, this.cameraDispatcher, developerAnimationListeners);
        this.mapHeroMap.injectAnnotationManager(annotationManager);
        this.mapGestureDetector = new MapGestureDetector(context, transform, proj, uiSettings, annotationManager, this.cameraDispatcher);
        this.mapKeyListener = new MapKeyListener(transform, uiSettings, this.mapGestureDetector);
        this.mapHeroMap.injectLocationComponent(new LocationComponent(this.mapHeroMap, transform, developerAnimationListeners));
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestDisallowInterceptTouchEvent(true);
        this.nativeMapView.setReachability(MapHero.isConnected());
        if (this.savedInstanceState == null) {
            this.mapHeroMap.initialise(context, this.mapHeroMapOptions);
        } else {
            this.mapHeroMap.onRestoreInstanceState(this.savedInstanceState);
        }
        this.mapCallback.initialised();
    }

    protected CompassView initialiseCompassView() {
        this.compassView = new CompassView(this.getContext());
        this.addView((View)this.compassView);
        this.compassView.setTag("compassView");
        this.compassView.getLayoutParams().width = -2;
        this.compassView.getLayoutParams().height = -2;
        this.compassView.setContentDescription(this.getResources().getString(R.string.maphero_compassContentDescription));
        this.compassView.injectCompassAnimationListener(this.createCompassAnimationListener(this.cameraDispatcher));
        this.compassView.setOnClickListener(this.createCompassClickListener(this.cameraDispatcher));
        return this.compassView;
    }

    protected ImageView initialiseAttributionView() {
        ImageView attrView = new ImageView(this.getContext());
        this.addView((View)attrView);
        attrView.setTag((Object)"attrView");
        attrView.getLayoutParams().width = -2;
        attrView.getLayoutParams().height = -2;
        attrView.setAdjustViewBounds(true);
        attrView.setClickable(true);
        attrView.setFocusable(true);
        attrView.setContentDescription((CharSequence)this.getResources().getString(R.string.maphero_attributionsIconContentDescription));
        attrView.setImageDrawable(BitmapUtils.getDrawableFromRes(this.getContext(), R.drawable.maphero_info_bg_selector));
        this.attributionClickListener = new AttributionClickListener(this.getContext(), this.mapHeroMap);
        attrView.setOnClickListener((View.OnClickListener)this.attributionClickListener);
        return attrView;
    }

    protected ImageView initialiseLogoView() {
        ImageView logoView = new ImageView(this.getContext());
        this.addView((View)logoView);
        logoView.setTag((Object)"logoView");
        logoView.getLayoutParams().width = -2;
        logoView.getLayoutParams().height = -2;
        logoView.setImageDrawable(BitmapUtils.getDrawableFromRes(this.getContext(), R.drawable.maphero_logo_icon));
        return logoView;
    }

    private FocalPointChangeListener createFocalPointChangeListener() {
        return new FocalPointChangeListener(){

            @Override
            public void onFocalPointChanged(PointF pointF) {
                MapView.this.focalPoint = pointF;
            }
        };
    }

    private MapHeroMap.OnCompassAnimationListener createCompassAnimationListener(final @NonNull CameraChangeDispatcher cameraChangeDispatcher) {
        return new MapHeroMap.OnCompassAnimationListener(){

            @Override
            public void onCompassAnimation() {
                cameraChangeDispatcher.onCameraMove();
            }

            @Override
            public void onCompassAnimationFinished() {
                if (MapView.this.compassView != null) {
                    MapView.this.compassView.isAnimating(false);
                }
                cameraChangeDispatcher.onCameraIdle();
            }
        };
    }

    private View.OnClickListener createCompassClickListener(final @NonNull CameraChangeDispatcher cameraChangeDispatcher) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (MapView.this.mapHeroMap != null && MapView.this.compassView != null) {
                    if (MapView.this.focalPoint != null) {
                        MapView.this.mapHeroMap.setFocalBearing(0.0, MapView.this.focalPoint.x, MapView.this.focalPoint.y, 150L);
                    } else {
                        MapView.this.mapHeroMap.setFocalBearing(0.0, MapView.this.mapHeroMap.getWidth() / 2.0f, MapView.this.mapHeroMap.getHeight() / 2.0f, 150L);
                    }
                    cameraChangeDispatcher.onCameraMoveStarted(3);
                    MapView.this.compassView.isAnimating(true);
                    MapView.this.compassView.postDelayed(MapView.this.compassView, 650L);
                }
            }
        };
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.getBoolean("maphero_savedState")) {
            this.savedInstanceState = savedInstanceState;
        }
    }

    private void initialiseDrawingSurface(MapHeroMapOptions options) {
        this.mapRenderer = MapRenderer.create(options, this.getContext(), () -> this.onSurfaceCreated());
        this.renderView = this.mapRenderer.getView();
        this.addView(this.renderView, 0);
        boolean crossSourceCollisions = options.getCrossSourceCollisions();
        this.nativeMapView = new NativeMapView(this.getContext(), this.getPixelRatio(), crossSourceCollisions, this, this.mapChangeReceiver, this.mapRenderer);
    }

    private void onSurfaceCreated() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!MapView.this.destroyed && MapView.this.mapHeroMap == null) {
                    MapView.this.initialiseMap();
                    MapView.this.mapHeroMap.onStart();
                }
            }
        });
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mapHeroMap != null) {
            outState.putBoolean("maphero_savedState", true);
            this.mapHeroMap.onSaveInstanceState(outState);
        }
    }

    @UiThread
    public void onStart() {
        if (!this.isStarted) {
            ConnectivityReceiver.instance(this.getContext()).activate();
            FileSource.getInstance(this.getContext()).activate();
            this.isStarted = true;
        }
        if (this.mapHeroMap != null) {
            this.mapHeroMap.onStart();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStart();
        }
    }

    @UiThread
    public void onResume() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onResume();
        }
    }

    @UiThread
    public void onPause() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onPause();
        }
    }

    @UiThread
    public void onStop() {
        if (this.attributionClickListener != null) {
            this.attributionClickListener.onStop();
        }
        if (this.mapHeroMap != null) {
            this.mapGestureDetector.cancelAnimators();
            this.mapHeroMap.onStop();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStop();
        }
        if (this.isStarted) {
            ConnectivityReceiver.instance(this.getContext()).deactivate();
            FileSource.getInstance(this.getContext()).deactivate();
            this.isStarted = false;
        }
    }

    @UiThread
    public void onDestroy() {
        this.destroyed = true;
        this.mapChangeReceiver.clear();
        this.mapCallback.onDestroy();
        this.initialRenderCallback.onDestroy();
        if (this.compassView != null) {
            this.compassView.resetAnimation();
        }
        if (this.mapHeroMap != null) {
            this.mapHeroMap.onDestroy();
        }
        if (this.nativeMapView != null) {
            this.nativeMapView.destroy();
            this.nativeMapView = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onDestroy();
        }
    }

    public void queueEvent(@NonNull Runnable runnable) {
        if (this.mapRenderer == null) {
            throw new IllegalStateException("Calling MapView#queueEvent before mapRenderer is created.");
        }
        this.mapRenderer.queueEvent(runnable);
    }

    public void setMaximumFps(int maximumFps) {
        if (this.mapRenderer == null) {
            throw new IllegalStateException("Calling MapView#setMaximumFps before mapRenderer is created.");
        }
        this.mapRenderer.setMaximumFps(maximumFps);
    }

    @UiThread
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @NonNull
    @UiThread
    public View getRenderView() {
        return this.renderView;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isGestureDetectorInitialized()) {
            return super.onTouchEvent(event);
        }
        return this.mapGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onKeyDown(keyCode, event);
        }
        return this.mapKeyListener.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onKeyLongPress(keyCode, event);
        }
        return this.mapKeyListener.onKeyLongPress(keyCode, event) || super.onKeyLongPress(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onKeyUp(keyCode, event);
        }
        return this.mapKeyListener.onKeyUp(keyCode, event) || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(@NonNull MotionEvent event) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onTrackballEvent(event);
        }
        return this.mapKeyListener.onTrackballEvent(event) || super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        if (!this.isGestureDetectorInitialized()) {
            return super.onGenericMotionEvent(event);
        }
        return this.mapGestureDetector.onGenericMotionEvent(event) || super.onGenericMotionEvent(event);
    }

    @UiThread
    public void onLowMemory() {
        if (this.nativeMapView != null && this.mapHeroMap != null && !this.destroyed) {
            this.nativeMapView.onLowMemory();
        }
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (!this.isInEditMode() && this.nativeMapView != null) {
            this.nativeMapView.resizeView(width, height);
        }
    }

    public float getPixelRatio() {
        float pixelRatio = this.mapHeroMapOptions.getPixelRatio();
        if (pixelRatio == 0.0f) {
            pixelRatio = this.getResources().getDisplayMetrics().density;
        }
        return pixelRatio;
    }

    @Override
    @Nullable
    public Bitmap getViewContent() {
        return BitmapUtils.createBitmapFromView((View)this);
    }

    public void addOnCameraWillChangeListener(@NonNull OnCameraWillChangeListener listener) {
        this.mapChangeReceiver.addOnCameraWillChangeListener(listener);
    }

    public void removeOnCameraWillChangeListener(@NonNull OnCameraWillChangeListener listener) {
        this.mapChangeReceiver.removeOnCameraWillChangeListener(listener);
    }

    public void addOnCameraIsChangingListener(@NonNull OnCameraIsChangingListener listener) {
        this.mapChangeReceiver.addOnCameraIsChangingListener(listener);
    }

    public void removeOnCameraIsChangingListener(@NonNull OnCameraIsChangingListener listener) {
        this.mapChangeReceiver.removeOnCameraIsChangingListener(listener);
    }

    public void addOnCameraDidChangeListener(@NonNull OnCameraDidChangeListener listener) {
        this.mapChangeReceiver.addOnCameraDidChangeListener(listener);
    }

    public void removeOnCameraDidChangeListener(@NonNull OnCameraDidChangeListener listener) {
        this.mapChangeReceiver.removeOnCameraDidChangeListener(listener);
    }

    public void addOnWillStartLoadingMapListener(@NonNull OnWillStartLoadingMapListener listener) {
        this.mapChangeReceiver.addOnWillStartLoadingMapListener(listener);
    }

    public void removeOnWillStartLoadingMapListener(@NonNull OnWillStartLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnWillStartLoadingMapListener(listener);
    }

    public void addOnDidFinishLoadingMapListener(@NonNull OnDidFinishLoadingMapListener listener) {
        this.mapChangeReceiver.addOnDidFinishLoadingMapListener(listener);
    }

    public void removeOnDidFinishLoadingMapListener(@NonNull OnDidFinishLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingMapListener(listener);
    }

    public void addOnDidFailLoadingMapListener(@NonNull OnDidFailLoadingMapListener listener) {
        this.mapChangeReceiver.addOnDidFailLoadingMapListener(listener);
    }

    public void removeOnDidFailLoadingMapListener(@NonNull OnDidFailLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFailLoadingMapListener(listener);
    }

    public void addOnWillStartRenderingFrameListener(@NonNull OnWillStartRenderingFrameListener listener) {
        this.mapChangeReceiver.addOnWillStartRenderingFrameListener(listener);
    }

    public void removeOnWillStartRenderingFrameListener(@NonNull OnWillStartRenderingFrameListener listener) {
        this.mapChangeReceiver.removeOnWillStartRenderingFrameListener(listener);
    }

    public void addOnDidFinishRenderingFrameListener(@NonNull OnDidFinishRenderingFrameListener listener) {
        this.mapChangeReceiver.addOnDidFinishRenderingFrameListener(listener);
    }

    public void removeOnDidFinishRenderingFrameListener(@NonNull OnDidFinishRenderingFrameListener listener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingFrameListener(listener);
    }

    public void addOnWillStartRenderingMapListener(@NonNull OnWillStartRenderingMapListener listener) {
        this.mapChangeReceiver.addOnWillStartRenderingMapListener(listener);
    }

    public void removeOnWillStartRenderingMapListener(@NonNull OnWillStartRenderingMapListener listener) {
        this.mapChangeReceiver.removeOnWillStartRenderingMapListener(listener);
    }

    public void addOnDidFinishRenderingMapListener(@NonNull OnDidFinishRenderingMapListener listener) {
        this.mapChangeReceiver.addOnDidFinishRenderingMapListener(listener);
    }

    public void removeOnDidFinishRenderingMapListener(OnDidFinishRenderingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingMapListener(listener);
    }

    public void addOnDidBecomeIdleListener(@NonNull OnDidBecomeIdleListener listener) {
        this.mapChangeReceiver.addOnDidBecomeIdleListener(listener);
    }

    public void removeOnDidBecomeIdleListener(@NonNull OnDidBecomeIdleListener listener) {
        this.mapChangeReceiver.removeOnDidBecomeIdleListener(listener);
    }

    public void addOnDidFinishLoadingStyleListener(@NonNull OnDidFinishLoadingStyleListener listener) {
        this.mapChangeReceiver.addOnDidFinishLoadingStyleListener(listener);
    }

    public void removeOnDidFinishLoadingStyleListener(@NonNull OnDidFinishLoadingStyleListener listener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingStyleListener(listener);
    }

    public void addOnSourceChangedListener(@NonNull OnSourceChangedListener listener) {
        this.mapChangeReceiver.addOnSourceChangedListener(listener);
    }

    public void removeOnSourceChangedListener(@NonNull OnSourceChangedListener listener) {
        this.mapChangeReceiver.removeOnSourceChangedListener(listener);
    }

    public void addOnStyleImageMissingListener(@NonNull OnStyleImageMissingListener listener) {
        this.mapChangeReceiver.addOnStyleImageMissingListener(listener);
    }

    public void removeOnStyleImageMissingListener(@NonNull OnStyleImageMissingListener listener) {
        this.mapChangeReceiver.removeOnStyleImageMissingListener(listener);
    }

    public void addOnCanRemoveUnusedStyleImageListener(@NonNull OnCanRemoveUnusedStyleImageListener listener) {
        this.mapChangeReceiver.addOnCanRemoveUnusedStyleImageListener(listener);
    }

    public void removeOnCanRemoveUnusedStyleImageListener(@NonNull OnCanRemoveUnusedStyleImageListener listener) {
        this.mapChangeReceiver.removeOnCanRemoveUnusedStyleImageListener(listener);
    }

    public void addOnPreCompileShaderListener(OnPreCompileShaderListener callback) {
        this.mapChangeReceiver.addOnPreCompileShaderListener(callback);
    }

    public void removeOnPreCompileShaderListener(OnPreCompileShaderListener callback) {
        this.mapChangeReceiver.removeOnPreCompileShaderListener(callback);
    }

    public void addOnPostCompileShaderListener(OnPostCompileShaderListener callback) {
        this.mapChangeReceiver.addOnPostCompileShaderListener(callback);
    }

    public void removeOnPostCompileShaderListener(OnPostCompileShaderListener callback) {
        this.mapChangeReceiver.removeOnPostCompileShaderListener(callback);
    }

    public void addOnShaderCompileFailedListener(OnShaderCompileFailedListener callback) {
        this.mapChangeReceiver.addOnShaderCompileFailedListener(callback);
    }

    public void removeOnShaderCompileFailedListener(OnShaderCompileFailedListener callback) {
        this.mapChangeReceiver.removeOnShaderCompileFailedListener(callback);
    }

    public void addOnGlyphsLoadedListener(OnGlyphsLoadedListener callback) {
        this.mapChangeReceiver.addOnGlyphsLoadedListener(callback);
    }

    public void removeOnGlyphsLoadedListener(OnGlyphsLoadedListener callback) {
        this.mapChangeReceiver.removeOnGlyphsLoadedListener(callback);
    }

    public void addOnGlyphsErrorListener(OnGlyphsErrorListener callback) {
        this.mapChangeReceiver.addOnGlyphsErrorListener(callback);
    }

    public void removeOnGlyphsErrorListener(OnGlyphsErrorListener callback) {
        this.mapChangeReceiver.removeOnGlyphsErrorListener(callback);
    }

    public void addOnGlyphsRequestedListener(OnGlyphsRequestedListener callback) {
        this.mapChangeReceiver.addOnGlyphsRequestedListener(callback);
    }

    public void removeOnGlyphsRequestedListener(OnGlyphsRequestedListener callback) {
        this.mapChangeReceiver.removeOnGlyphsRequestedListener(callback);
    }

    public void addOnTileActionListener(OnTileActionListener callback) {
        this.mapChangeReceiver.addOnTileActionListener(callback);
    }

    public void removeOnTileActionListener(OnTileActionListener callback) {
        this.mapChangeReceiver.removeOnTileActionListener(callback);
    }

    public void addOnSpriteLoadedListener(OnSpriteLoadedListener callback) {
        this.mapChangeReceiver.addOnSpriteLoadedListener(callback);
    }

    public void removeOnSpriteLoadedListener(OnSpriteLoadedListener callback) {
        this.mapChangeReceiver.removeOnSpriteLoadedListener(callback);
    }

    public void addOnSpriteErrorListener(OnSpriteErrorListener callback) {
        this.mapChangeReceiver.addOnSpriteErrorListener(callback);
    }

    public void removeOnSpriteErrorListener(OnSpriteErrorListener callback) {
        this.mapChangeReceiver.removeOnSpriteErrorListener(callback);
    }

    public void addOnSpriteRequestedListener(OnSpriteRequestedListener callback) {
        this.mapChangeReceiver.addOnSpriteRequestedListener(callback);
    }

    public void removeOnSpriteRequestedListener(OnSpriteRequestedListener callback) {
        this.mapChangeReceiver.removeOnSpriteRequestedListener(callback);
    }

    @UiThread
    public void getMapAsync(@NonNull OnMapReadyCallback callback) {
        if (this.mapHeroMap == null) {
            this.mapCallback.addOnMapReadyCallback(callback);
        } else {
            callback.onMapReady(this.mapHeroMap);
        }
    }

    private boolean isGestureDetectorInitialized() {
        return this.mapGestureDetector != null;
    }

    private boolean isKeyDetectorInitialized() {
        return this.mapKeyListener != null;
    }

    @Nullable
    MapHeroMap getMapHeroMap() {
        return this.mapHeroMap;
    }

    void setMapHeroMap(MapHeroMap mapHeroMap) {
        this.mapHeroMap = mapHeroMap;
    }

    public static void setMapStrictModeEnabled(boolean strictModeEnabled) {
        MapStrictMode.setStrictModeEnabled(strictModeEnabled);
    }

    private class MapCallback
    implements OnDidFinishLoadingStyleListener,
    OnDidFinishRenderingFrameListener,
    OnDidFinishLoadingMapListener,
    OnCameraIsChangingListener,
    OnCameraDidChangeListener,
    OnDidFailLoadingMapListener {
        private final List<OnMapReadyCallback> onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();

        MapCallback() {
            MapView.this.addOnDidFinishLoadingStyleListener(this);
            MapView.this.addOnDidFinishRenderingFrameListener(this);
            MapView.this.addOnDidFinishLoadingMapListener(this);
            MapView.this.addOnCameraIsChangingListener(this);
            MapView.this.addOnCameraDidChangeListener(this);
            MapView.this.addOnDidFailLoadingMapListener(this);
        }

        void initialised() {
            MapView.this.mapHeroMap.onPreMapReady();
            this.onMapReady();
            MapView.this.mapHeroMap.onPostMapReady();
        }

        private void onMapReady() {
            if (this.onMapReadyCallbackList.size() > 0) {
                Iterator<OnMapReadyCallback> iterator = this.onMapReadyCallbackList.iterator();
                while (iterator.hasNext()) {
                    OnMapReadyCallback callback = iterator.next();
                    if (callback != null) {
                        callback.onMapReady(MapView.this.mapHeroMap);
                    }
                    iterator.remove();
                }
            }
        }

        void addOnMapReadyCallback(OnMapReadyCallback callback) {
            this.onMapReadyCallbackList.add(callback);
        }

        void onDestroy() {
            this.onMapReadyCallbackList.clear();
            MapView.this.removeOnDidFinishLoadingStyleListener(this);
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
            MapView.this.removeOnDidFinishLoadingMapListener(this);
            MapView.this.removeOnCameraIsChangingListener(this);
            MapView.this.removeOnCameraDidChangeListener(this);
            MapView.this.removeOnDidFailLoadingMapListener(this);
        }

        @Override
        public void onDidFinishLoadingStyle() {
            if (MapView.this.mapHeroMap != null) {
                MapView.this.mapHeroMap.onFinishLoadingStyle();
            }
        }

        @Override
        public void onDidFailLoadingMap(String errorMessage) {
            if (MapView.this.mapHeroMap != null) {
                MapView.this.mapHeroMap.onFailLoadingStyle();
            }
        }

        @Override
        public void onDidFinishRenderingFrame(boolean fully, double frameEncodingTime, double frameRenderingTime) {
            if (MapView.this.mapHeroMap != null) {
                MapView.this.mapHeroMap.onUpdateFullyRendered();
            }
        }

        @Override
        public void onDidFinishLoadingMap() {
            if (MapView.this.mapHeroMap != null) {
                MapView.this.mapHeroMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraIsChanging() {
            if (MapView.this.mapHeroMap != null) {
                MapView.this.mapHeroMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraDidChange(boolean animated) {
            if (MapView.this.mapHeroMap != null) {
                MapView.this.mapHeroMap.onUpdateRegionChange();
            }
        }
    }

    private class InitialRenderCallback
    implements OnDidFinishRenderingFrameListener {
        private int renderCount;

        InitialRenderCallback() {
            MapView.this.addOnDidFinishRenderingFrameListener(this);
        }

        @Override
        public void onDidFinishRenderingFrame(boolean fully, double frameEncodingTime, double frameRenderingTime) {
            if (MapView.this.mapHeroMap != null && MapView.this.mapHeroMap.getStyle() != null && MapView.this.mapHeroMap.getStyle().isFullyLoaded()) {
                ++this.renderCount;
                if (this.renderCount == 3) {
                    MapView.this.setForeground(null);
                    MapView.this.removeOnDidFinishRenderingFrameListener(this);
                }
            }
        }

        private void onDestroy() {
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
        }
    }

    private class FocalPointInvalidator
    implements FocalPointChangeListener {
        private final List<FocalPointChangeListener> focalPointChangeListeners = new ArrayList<FocalPointChangeListener>();

        private FocalPointInvalidator() {
        }

        void addListener(FocalPointChangeListener focalPointChangeListener) {
            this.focalPointChangeListeners.add(focalPointChangeListener);
        }

        @Override
        public void onFocalPointChanged(PointF pointF) {
            MapView.this.mapGestureDetector.setFocalPoint(pointF);
            for (FocalPointChangeListener focalPointChangeListener : this.focalPointChangeListeners) {
                focalPointChangeListener.onFocalPointChanged(pointF);
            }
        }
    }

    private class GesturesManagerInteractionListener
    implements MapHeroMap.OnGesturesManagerInteractionListener {
        private GesturesManagerInteractionListener() {
        }

        @Override
        public void onAddMapClickListener(MapHeroMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapClickListener(listener);
        }

        @Override
        public void onRemoveMapClickListener(MapHeroMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapClickListener(listener);
        }

        @Override
        public void onAddMapLongClickListener(MapHeroMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapLongClickListener(listener);
        }

        @Override
        public void onRemoveMapLongClickListener(MapHeroMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapLongClickListener(listener);
        }

        @Override
        public void onAddFlingListener(MapHeroMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.addOnFlingListener(listener);
        }

        @Override
        public void onRemoveFlingListener(MapHeroMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.removeOnFlingListener(listener);
        }

        @Override
        public void onAddMoveListener(MapHeroMap.OnMoveListener listener) {
            MapView.this.mapGestureDetector.addOnMoveListener(listener);
        }

        @Override
        public void onRemoveMoveListener(MapHeroMap.OnMoveListener listener) {
            MapView.this.mapGestureDetector.removeOnMoveListener(listener);
        }

        @Override
        public void onAddRotateListener(MapHeroMap.OnRotateListener listener) {
            MapView.this.mapGestureDetector.addOnRotateListener(listener);
        }

        @Override
        public void onRemoveRotateListener(MapHeroMap.OnRotateListener listener) {
            MapView.this.mapGestureDetector.removeOnRotateListener(listener);
        }

        @Override
        public void onAddScaleListener(MapHeroMap.OnScaleListener listener) {
            MapView.this.mapGestureDetector.addOnScaleListener(listener);
        }

        @Override
        public void onRemoveScaleListener(MapHeroMap.OnScaleListener listener) {
            MapView.this.mapGestureDetector.removeOnScaleListener(listener);
        }

        @Override
        public void onAddShoveListener(MapHeroMap.OnShoveListener listener) {
            MapView.this.mapGestureDetector.addShoveListener(listener);
        }

        @Override
        public void onRemoveShoveListener(MapHeroMap.OnShoveListener listener) {
            MapView.this.mapGestureDetector.removeShoveListener(listener);
        }

        @Override
        public AndroidGesturesManager getGesturesManager() {
            return MapView.this.mapGestureDetector.getGesturesManager();
        }

        @Override
        public void setGesturesManager(AndroidGesturesManager gesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
            MapView.this.mapGestureDetector.setGesturesManager(MapView.this.getContext(), gesturesManager, attachDefaultListeners, setDefaultMutuallyExclusives);
        }

        @Override
        public void cancelAllVelocityAnimations() {
            MapView.this.mapGestureDetector.cancelAnimators();
        }
    }

    private static class AttributionClickListener
    implements View.OnClickListener {
        @NonNull
        private final AttributionDialogManager defaultDialogManager;
        private UiSettings uiSettings;

        private AttributionClickListener(@NonNull Context context, @NonNull MapHeroMap mapHeroMap) {
            this.defaultDialogManager = new AttributionDialogManager(context, mapHeroMap);
            this.uiSettings = mapHeroMap.getUiSettings();
        }

        public void onClick(View v) {
            this.getDialogManager().onClick(v);
        }

        public void onStop() {
            this.getDialogManager().onStop();
        }

        private AttributionDialogManager getDialogManager() {
            AttributionDialogManager customDialogManager = this.uiSettings.getAttributionDialogManager();
            if (customDialogManager != null) {
                return this.uiSettings.getAttributionDialogManager();
            }
            return this.defaultDialogManager;
        }
    }

    public static interface OnCameraWillChangeListener {
        public void onCameraWillChange(boolean var1);
    }

    public static interface OnCameraIsChangingListener {
        public void onCameraIsChanging();
    }

    public static interface OnCameraDidChangeListener {
        public void onCameraDidChange(boolean var1);
    }

    public static interface OnWillStartLoadingMapListener {
        public void onWillStartLoadingMap();
    }

    public static interface OnDidFinishLoadingMapListener {
        public void onDidFinishLoadingMap();
    }

    public static interface OnDidFailLoadingMapListener {
        public void onDidFailLoadingMap(String var1);
    }

    public static interface OnWillStartRenderingFrameListener {
        public void onWillStartRenderingFrame();
    }

    public static interface OnDidFinishRenderingFrameListener {
        public void onDidFinishRenderingFrame(boolean var1, double var2, double var4);
    }

    public static interface OnWillStartRenderingMapListener {
        public void onWillStartRenderingMap();
    }

    public static interface OnDidFinishRenderingMapListener {
        public void onDidFinishRenderingMap(boolean var1);
    }

    public static interface OnDidBecomeIdleListener {
        public void onDidBecomeIdle();
    }

    public static interface OnDidFinishLoadingStyleListener {
        public void onDidFinishLoadingStyle();
    }

    public static interface OnSourceChangedListener {
        public void onSourceChangedListener(String var1);
    }

    public static interface OnStyleImageMissingListener {
        public void onStyleImageMissing(@NonNull String var1);
    }

    public static interface OnCanRemoveUnusedStyleImageListener {
        public boolean onCanRemoveUnusedStyleImage(@NonNull String var1);
    }

    public static interface OnPreCompileShaderListener {
        public void onPreCompileShader(int var1, int var2, String var3);
    }

    public static interface OnPostCompileShaderListener {
        public void onPostCompileShader(int var1, int var2, String var3);
    }

    public static interface OnShaderCompileFailedListener {
        public void onShaderCompileFailed(int var1, int var2, String var3);
    }

    public static interface OnGlyphsLoadedListener {
        public void onGlyphsLoaded(@NonNull String[] var1, int var2, int var3);
    }

    public static interface OnGlyphsErrorListener {
        public void onGlyphsError(@NonNull String[] var1, int var2, int var3);
    }

    public static interface OnGlyphsRequestedListener {
        public void onGlyphsRequested(@NonNull String[] var1, int var2, int var3);
    }

    public static interface OnTileActionListener {
        public void onTileAction(TileOperation var1, int var2, int var3, int var4, int var5, int var6, String var7);
    }

    public static interface OnSpriteLoadedListener {
        public void onSpriteLoaded(@NonNull String var1, @NonNull String var2);
    }

    public static interface OnSpriteErrorListener {
        public void onSpriteError(@NonNull String var1, @NonNull String var2);
    }

    public static interface OnSpriteRequestedListener {
        public void onSpriteRequested(@NonNull String var1, @NonNull String var2);
    }
}

