/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import org.maphero.android.R;
import org.maphero.android.camera.CameraPosition;
import org.maphero.android.maps.AttributionDialogManager;
import org.maphero.android.maps.FocalPointChangeListener;
import org.maphero.android.maps.MapHeroMapOptions;
import org.maphero.android.maps.MapView;
import org.maphero.android.maps.Projection;
import org.maphero.android.maps.widgets.CompassView;
import org.maphero.android.utils.BitmapUtils;
import org.maphero.android.utils.ColorUtils;

public final class UiSettings {
    @NonNull
    private final FocalPointChangeListener focalPointChangeListener;
    @NonNull
    private final MapView mapView;
    @NonNull
    private final Projection projection;
    @VisibleForTesting
    @Nullable
    CompassView compassView;
    private final int[] compassMargins = new int[4];
    @VisibleForTesting
    @Nullable
    ImageView attributionsView;
    private final int[] attributionsMargins = new int[4];
    private AttributionDialogManager attributionDialogManager;
    @VisibleForTesting
    @Nullable
    ImageView logoView;
    private final int[] logoMargins = new int[4];
    private final float pixelRatio;
    private boolean rotateGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean horizontalScrollGesturesEnabled = true;
    private boolean doubleTapGesturesEnabled = true;
    private boolean quickZoomGesturesEnabled = true;
    private boolean scaleVelocityAnimationEnabled = true;
    private boolean rotateVelocityAnimationEnabled = true;
    private boolean flingVelocityAnimationEnabled = true;
    private boolean increaseRotateThresholdWhenScaling = true;
    private boolean disableRotateWhenScaling = true;
    private boolean increaseScaleThresholdWhenRotating = true;
    private float zoomRate = 1.0f;
    private boolean deselectMarkersOnTap = true;
    private long flingAnimationBaseTime = 150L;
    private long flingThreshold = 1000L;
    @Nullable
    private PointF userProvidedFocalPoint;
    @VisibleForTesting
    boolean isCompassInitialized = false;
    @VisibleForTesting
    boolean isAttributionInitialized = false;
    @VisibleForTesting
    boolean isLogoInitialized = false;
    private double clockwiseBearing;

    UiSettings(@NonNull Projection projection, @NonNull FocalPointChangeListener listener, float pixelRatio, MapView mapView) {
        this.projection = projection;
        this.focalPointChangeListener = listener;
        this.pixelRatio = pixelRatio;
        this.mapView = mapView;
    }

    void initialise(@NonNull Context context, @NonNull MapHeroMapOptions options) {
        Resources resources = context.getResources();
        this.initialiseGestures(options);
        if (options.getCompassEnabled()) {
            this.initialiseCompass(options, resources);
        }
        if (options.getLogoEnabled()) {
            this.initialiseLogo(options, resources);
        }
        if (options.getAttributionEnabled()) {
            this.initialiseAttribution(context, options);
        }
    }

    void onSaveInstanceState(@NonNull Bundle outState) {
        this.saveGestures(outState);
        this.saveCompass(outState);
        this.saveLogo(outState);
        this.saveAttribution(outState);
        this.saveDeselectMarkersOnTap(outState);
        this.saveFocalPoint(outState);
    }

    void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.restoreGestures(savedInstanceState);
        this.restoreCompass(savedInstanceState);
        this.restoreLogo(savedInstanceState);
        this.restoreAttribution(savedInstanceState);
        this.restoreDeselectMarkersOnTap(savedInstanceState);
        this.restoreFocalPoint(savedInstanceState);
    }

    private void initialiseGestures(MapHeroMapOptions options) {
        this.setZoomGesturesEnabled(options.getZoomGesturesEnabled());
        this.setScrollGesturesEnabled(options.getScrollGesturesEnabled());
        this.setHorizontalScrollGesturesEnabled(options.getHorizontalScrollGesturesEnabled());
        this.setRotateGesturesEnabled(options.getRotateGesturesEnabled());
        this.setTiltGesturesEnabled(options.getTiltGesturesEnabled());
        this.setDoubleTapGesturesEnabled(options.getDoubleTapGesturesEnabled());
        this.setQuickZoomGesturesEnabled(options.getQuickZoomGesturesEnabled());
    }

    private void saveGestures(Bundle outState) {
        outState.putBoolean("maphero_horizontalScrollEnabled", this.isHorizontalScrollGesturesEnabled());
        outState.putBoolean("maphero_zoomEnabled", this.isZoomGesturesEnabled());
        outState.putBoolean("maphero_scrollEnabled", this.isScrollGesturesEnabled());
        outState.putBoolean("maphero_rotateEnabled", this.isRotateGesturesEnabled());
        outState.putBoolean("maphero_tiltEnabled", this.isTiltGesturesEnabled());
        outState.putBoolean("maphero_doubleTapEnabled", this.isDoubleTapGesturesEnabled());
        outState.putBoolean("maphero_scaleAnimationEnabled", this.isScaleVelocityAnimationEnabled());
        outState.putBoolean("maphero_rotateAnimationEnabled", this.isRotateVelocityAnimationEnabled());
        outState.putBoolean("maphero_flingAnimationEnabled", this.isFlingVelocityAnimationEnabled());
        outState.putBoolean("maphero_increaseRotateThreshold", this.isIncreaseRotateThresholdWhenScaling());
        outState.putBoolean("maphero_disableRotateWhenScaling", this.isDisableRotateWhenScaling());
        outState.putBoolean("maphero_increaseScaleThreshold", this.isIncreaseScaleThresholdWhenRotating());
        outState.putBoolean("maphero_quickZoom", this.isQuickZoomGesturesEnabled());
        outState.putFloat("maphero_zoomRate", this.getZoomRate());
    }

    private void restoreGestures(Bundle savedInstanceState) {
        this.setHorizontalScrollGesturesEnabled(savedInstanceState.getBoolean("maphero_horizontalScrollEnabled"));
        this.setZoomGesturesEnabled(savedInstanceState.getBoolean("maphero_zoomEnabled"));
        this.setScrollGesturesEnabled(savedInstanceState.getBoolean("maphero_scrollEnabled"));
        this.setRotateGesturesEnabled(savedInstanceState.getBoolean("maphero_rotateEnabled"));
        this.setTiltGesturesEnabled(savedInstanceState.getBoolean("maphero_tiltEnabled"));
        this.setDoubleTapGesturesEnabled(savedInstanceState.getBoolean("maphero_doubleTapEnabled"));
        this.setScaleVelocityAnimationEnabled(savedInstanceState.getBoolean("maphero_scaleAnimationEnabled"));
        this.setRotateVelocityAnimationEnabled(savedInstanceState.getBoolean("maphero_rotateAnimationEnabled"));
        this.setFlingVelocityAnimationEnabled(savedInstanceState.getBoolean("maphero_flingAnimationEnabled"));
        this.setIncreaseRotateThresholdWhenScaling(savedInstanceState.getBoolean("maphero_increaseRotateThreshold"));
        this.setDisableRotateWhenScaling(savedInstanceState.getBoolean("maphero_disableRotateWhenScaling"));
        this.setIncreaseScaleThresholdWhenRotating(savedInstanceState.getBoolean("maphero_increaseScaleThreshold"));
        this.setQuickZoomGesturesEnabled(savedInstanceState.getBoolean("maphero_quickZoom"));
        this.setZoomRate(savedInstanceState.getFloat("maphero_zoomRate", 1.0f));
    }

    private void initialiseCompass(MapHeroMapOptions options, @NonNull Resources resources) {
        this.isCompassInitialized = true;
        this.compassView = this.mapView.initialiseCompassView();
        this.setCompassEnabled(options.getCompassEnabled());
        this.setCompassGravity(options.getCompassGravity());
        int[] compassMargins = options.getCompassMargins();
        if (compassMargins != null) {
            this.setCompassMargins(compassMargins[0], compassMargins[1], compassMargins[2], compassMargins[3]);
        } else {
            int tenDp = (int)resources.getDimension(R.dimen.maphero_four_dp);
            this.setCompassMargins(tenDp, tenDp, tenDp, tenDp);
        }
        this.setCompassFadeFacingNorth(options.getCompassFadeFacingNorth());
        if (options.getCompassImage() == null) {
            options.compassImage(ResourcesCompat.getDrawable((Resources)resources, (int)R.drawable.maphero_compass_icon, null));
        }
        this.setCompassImage(options.getCompassImage());
    }

    private void saveCompass(Bundle outState) {
        outState.putBoolean("maphero_compassEnabled", this.isCompassEnabled());
        outState.putInt("maphero_compassGravity", this.getCompassGravity());
        outState.putInt("maphero_compassMarginLeft", this.getCompassMarginLeft());
        outState.putInt("maphero_compassMarginTop", this.getCompassMarginTop());
        outState.putInt("maphero_compassMarginBottom", this.getCompassMarginBottom());
        outState.putInt("maphero_compassMarginRight", this.getCompassMarginRight());
        outState.putBoolean("maphero_compassFade", this.isCompassFadeWhenFacingNorth());
        outState.putByteArray("maphero_compassImage", BitmapUtils.getByteArrayFromDrawable(this.getCompassImage()));
    }

    private void restoreCompass(Bundle savedInstanceState) {
        boolean compassEnabled = savedInstanceState.getBoolean("maphero_compassEnabled");
        if (compassEnabled && !this.isCompassInitialized) {
            this.compassView = this.mapView.initialiseCompassView();
            this.isCompassInitialized = true;
        }
        this.setCompassEnabled(savedInstanceState.getBoolean("maphero_compassEnabled"));
        this.setCompassGravity(savedInstanceState.getInt("maphero_compassGravity"));
        this.setCompassMargins(savedInstanceState.getInt("maphero_compassMarginLeft"), savedInstanceState.getInt("maphero_compassMarginTop"), savedInstanceState.getInt("maphero_compassMarginRight"), savedInstanceState.getInt("maphero_compassMarginBottom"));
        this.setCompassFadeFacingNorth(savedInstanceState.getBoolean("maphero_compassFade"));
        this.setCompassImage(BitmapUtils.getDrawableFromByteArray(this.mapView.getContext(), savedInstanceState.getByteArray("maphero_compassImage")));
    }

    private void initialiseLogo(MapHeroMapOptions options, @NonNull Resources resources) {
        this.isLogoInitialized = true;
        this.logoView = this.mapView.initialiseLogoView();
        this.setLogoEnabled(options.getLogoEnabled());
        this.setLogoGravity(options.getLogoGravity());
        this.setLogoMargins(resources, options.getLogoMargins());
    }

    private void setLogoMargins(@NonNull Resources resources, @Nullable int[] logoMargins) {
        if (logoMargins != null) {
            this.setLogoMargins(logoMargins[0], logoMargins[1], logoMargins[2], logoMargins[3]);
        } else {
            int fourDp = (int)resources.getDimension(R.dimen.maphero_four_dp);
            this.setLogoMargins(fourDp, fourDp, fourDp, fourDp);
        }
    }

    private void saveLogo(Bundle outState) {
        outState.putInt("maphero_logoGravity", this.getLogoGravity());
        outState.putInt("maphero_logoMarginLeft", this.getLogoMarginLeft());
        outState.putInt("maphero_logoMarginTop", this.getLogoMarginTop());
        outState.putInt("maphero_logoMarginRight", this.getLogoMarginRight());
        outState.putInt("maphero_logoMarginBottom", this.getLogoMarginBottom());
        outState.putBoolean("maphero_logoEnabled", this.isLogoEnabled());
    }

    private void restoreLogo(Bundle savedInstanceState) {
        boolean logoEnabled = savedInstanceState.getBoolean("maphero_logoEnabled");
        if (logoEnabled && !this.isLogoInitialized) {
            this.logoView = this.mapView.initialiseLogoView();
            this.isLogoInitialized = true;
        }
        this.setLogoEnabled(savedInstanceState.getBoolean("maphero_logoEnabled"));
        this.setLogoGravity(savedInstanceState.getInt("maphero_logoGravity"));
        this.setLogoMargins(savedInstanceState.getInt("maphero_logoMarginLeft"), savedInstanceState.getInt("maphero_logoMarginTop"), savedInstanceState.getInt("maphero_logoMarginRight"), savedInstanceState.getInt("maphero_logoMarginBottom"));
    }

    private void initialiseAttribution(@NonNull Context context, MapHeroMapOptions options) {
        this.isAttributionInitialized = true;
        this.attributionsView = this.mapView.initialiseAttributionView();
        this.setAttributionEnabled(options.getAttributionEnabled());
        this.setAttributionGravity(options.getAttributionGravity());
        this.setAttributionMargins(context, options.getAttributionMargins());
        int attributionTintColor = options.getAttributionTintColor();
        this.setAttributionTintColor(attributionTintColor != -1 ? attributionTintColor : ColorUtils.getPrimaryColor(context));
    }

    private void setAttributionMargins(@NonNull Context context, @Nullable int[] attributionMargins) {
        if (attributionMargins != null) {
            this.setAttributionMargins(attributionMargins[0], attributionMargins[1], attributionMargins[2], attributionMargins[3]);
        } else {
            Resources resources = context.getResources();
            int margin = (int)resources.getDimension(R.dimen.maphero_four_dp);
            int leftMargin = (int)resources.getDimension(R.dimen.maphero_ninety_two_dp);
            this.setAttributionMargins(leftMargin, margin, margin, margin);
        }
    }

    private void saveAttribution(Bundle outState) {
        outState.putInt("maphero_attrGravity", this.getAttributionGravity());
        outState.putInt("maphero_attrMarginLeft", this.getAttributionMarginLeft());
        outState.putInt("maphero_attrMarginTop", this.getAttributionMarginTop());
        outState.putInt("maphero_attrMarginRight", this.getAttributionMarginRight());
        outState.putInt("maphero_atrrMarginBottom", this.getAttributionMarginBottom());
        outState.putBoolean("maphero_atrrEnabled", this.isAttributionEnabled());
    }

    private void restoreAttribution(Bundle savedInstanceState) {
        boolean attributionEnabled = savedInstanceState.getBoolean("maphero_atrrEnabled");
        if (attributionEnabled && !this.isAttributionInitialized) {
            this.attributionsView = this.mapView.initialiseAttributionView();
            this.isAttributionInitialized = true;
        }
        this.setAttributionEnabled(savedInstanceState.getBoolean("maphero_atrrEnabled"));
        this.setAttributionGravity(savedInstanceState.getInt("maphero_attrGravity"));
        this.setAttributionMargins(savedInstanceState.getInt("maphero_attrMarginLeft"), savedInstanceState.getInt("maphero_attrMarginTop"), savedInstanceState.getInt("maphero_attrMarginRight"), savedInstanceState.getInt("maphero_atrrMarginBottom"));
    }

    public long getFlingAnimationBaseTime() {
        return this.flingAnimationBaseTime;
    }

    public long getFlingThreshold() {
        return this.flingThreshold;
    }

    public void setFlingAnimationBaseTime(long t) {
        this.flingAnimationBaseTime = t;
    }

    public void setFlingThreshold(long t) {
        this.flingThreshold = t;
    }

    public void setCompassEnabled(boolean compassEnabled) {
        if (compassEnabled && !this.isCompassInitialized) {
            this.initialiseCompass(this.mapView.mapHeroMapOptions, this.mapView.getContext().getResources());
        }
        if (this.compassView != null) {
            this.compassView.setEnabled(compassEnabled);
            this.compassView.update(this.clockwiseBearing);
        }
    }

    public boolean isCompassEnabled() {
        if (this.compassView != null) {
            return this.compassView.isEnabled();
        }
        return false;
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        if (this.compassView != null) {
            this.setWidgetGravity((View)this.compassView, gravity);
        }
    }

    public void setCompassFadeFacingNorth(boolean compassFadeFacingNorth) {
        if (this.compassView != null) {
            this.compassView.fadeCompassViewFacingNorth(compassFadeFacingNorth);
        }
    }

    public void setCompassImage(@NonNull Drawable compass) {
        if (this.compassView != null) {
            this.compassView.setCompassImage(compass);
        }
    }

    public boolean isCompassFadeWhenFacingNorth() {
        if (this.compassView != null) {
            return this.compassView.isFadeCompassViewFacingNorth();
        }
        return false;
    }

    public int getCompassGravity() {
        if (this.compassView != null) {
            return ((FrameLayout.LayoutParams)this.compassView.getLayoutParams()).gravity;
        }
        return -1;
    }

    @UiThread
    public void setCompassMargins(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        if (this.compassView != null) {
            this.setWidgetMargins((View)this.compassView, this.compassMargins, left, top, right, bottom);
        }
    }

    @Px
    public int getCompassMarginLeft() {
        return this.compassMargins[0];
    }

    @Px
    public int getCompassMarginTop() {
        return this.compassMargins[1];
    }

    @Px
    public int getCompassMarginRight() {
        return this.compassMargins[2];
    }

    @Px
    public int getCompassMarginBottom() {
        return this.compassMargins[3];
    }

    @Nullable
    public Drawable getCompassImage() {
        if (this.compassView != null) {
            return this.compassView.getCompassImage();
        }
        return null;
    }

    void update(@NonNull CameraPosition cameraPosition) {
        this.clockwiseBearing = -cameraPosition.bearing;
        if (this.compassView != null) {
            this.compassView.update(this.clockwiseBearing);
        }
    }

    public void setLogoEnabled(boolean enabled) {
        if (enabled && !this.isLogoInitialized) {
            this.initialiseLogo(this.mapView.mapHeroMapOptions, this.mapView.getContext().getResources());
        }
        if (this.logoView != null) {
            this.logoView.setVisibility(enabled ? 0 : 8);
        }
    }

    public boolean isLogoEnabled() {
        if (this.logoView != null) {
            return this.logoView.getVisibility() == 0;
        }
        return false;
    }

    public void setLogoGravity(int gravity) {
        if (this.logoView != null) {
            this.setWidgetGravity((View)this.logoView, gravity);
        }
    }

    public int getLogoGravity() {
        if (this.logoView != null) {
            return ((FrameLayout.LayoutParams)this.logoView.getLayoutParams()).gravity;
        }
        return -1;
    }

    public void setLogoMargins(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        if (this.logoView != null) {
            this.setWidgetMargins((View)this.logoView, this.logoMargins, left, top, right, bottom);
        }
    }

    @Px
    public int getLogoMarginLeft() {
        return this.logoMargins[0];
    }

    @Px
    public int getLogoMarginTop() {
        return this.logoMargins[1];
    }

    @Px
    public int getLogoMarginRight() {
        return this.logoMargins[2];
    }

    @Px
    public int getLogoMarginBottom() {
        return this.logoMargins[3];
    }

    public void setAttributionEnabled(boolean enabled) {
        if (enabled && !this.isAttributionInitialized) {
            this.initialiseAttribution(this.mapView.getContext(), this.mapView.mapHeroMapOptions);
        }
        if (this.attributionsView != null) {
            this.attributionsView.setVisibility(enabled ? 0 : 8);
        }
    }

    public boolean isAttributionEnabled() {
        if (this.attributionsView != null) {
            return this.attributionsView.getVisibility() == 0;
        }
        return false;
    }

    public void setAttributionDialogManager(@NonNull AttributionDialogManager attributionDialogManager) {
        this.attributionDialogManager = attributionDialogManager;
    }

    @Nullable
    public AttributionDialogManager getAttributionDialogManager() {
        return this.attributionDialogManager;
    }

    public void setAttributionGravity(int gravity) {
        if (this.attributionsView != null) {
            this.setWidgetGravity((View)this.attributionsView, gravity);
        }
    }

    public int getAttributionGravity() {
        if (this.attributionsView != null) {
            return ((FrameLayout.LayoutParams)this.attributionsView.getLayoutParams()).gravity;
        }
        return -1;
    }

    public void setAttributionMargins(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        if (this.attributionsView != null) {
            this.setWidgetMargins((View)this.attributionsView, this.attributionsMargins, left, top, right, bottom);
        }
    }

    public void setAttributionTintColor(@ColorInt int tintColor) {
        if (this.attributionsView == null) {
            return;
        }
        if (Color.alpha((int)tintColor) == 0) {
            ColorUtils.setTintList(this.attributionsView, ContextCompat.getColor((Context)this.attributionsView.getContext(), (int)R.color.maphero_blue));
        } else {
            ColorUtils.setTintList(this.attributionsView, tintColor);
        }
    }

    @Px
    public int getAttributionMarginLeft() {
        return this.attributionsMargins[0];
    }

    @Px
    public int getAttributionMarginTop() {
        return this.attributionsMargins[1];
    }

    @Px
    public int getAttributionMarginRight() {
        return this.attributionsMargins[2];
    }

    @Px
    public int getAttributionMarginBottom() {
        return this.attributionsMargins[3];
    }

    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        this.rotateGesturesEnabled = rotateGesturesEnabled;
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        this.tiltGesturesEnabled = tiltGesturesEnabled;
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        this.zoomGesturesEnabled = zoomGesturesEnabled;
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public void setDoubleTapGesturesEnabled(boolean doubleTapGesturesEnabled) {
        this.doubleTapGesturesEnabled = doubleTapGesturesEnabled;
    }

    public boolean isDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public boolean isQuickZoomGesturesEnabled() {
        return this.quickZoomGesturesEnabled;
    }

    public void setQuickZoomGesturesEnabled(boolean quickZoomGesturesEnabled) {
        this.quickZoomGesturesEnabled = quickZoomGesturesEnabled;
    }

    public float getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(@FloatRange(from=0.0) float zoomRate) {
        this.zoomRate = zoomRate;
    }

    private void restoreDeselectMarkersOnTap(Bundle savedInstanceState) {
        this.setDeselectMarkersOnTap(savedInstanceState.getBoolean("maphero_deselectMarkerOnTap"));
    }

    private void saveDeselectMarkersOnTap(Bundle outState) {
        outState.putBoolean("maphero_deselectMarkerOnTap", this.isDeselectMarkersOnTap());
    }

    public boolean isDeselectMarkersOnTap() {
        return this.deselectMarkersOnTap;
    }

    public void setDeselectMarkersOnTap(boolean deselectMarkersOnTap) {
        this.deselectMarkersOnTap = deselectMarkersOnTap;
    }

    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        this.scrollGesturesEnabled = scrollGesturesEnabled;
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public void setHorizontalScrollGesturesEnabled(boolean horizontalScrollGesturesEnabled) {
        this.horizontalScrollGesturesEnabled = horizontalScrollGesturesEnabled;
    }

    public boolean isHorizontalScrollGesturesEnabled() {
        return this.horizontalScrollGesturesEnabled;
    }

    public boolean isScaleVelocityAnimationEnabled() {
        return this.scaleVelocityAnimationEnabled;
    }

    public void setScaleVelocityAnimationEnabled(boolean scaleVelocityAnimationEnabled) {
        this.scaleVelocityAnimationEnabled = scaleVelocityAnimationEnabled;
    }

    public boolean isRotateVelocityAnimationEnabled() {
        return this.rotateVelocityAnimationEnabled;
    }

    public void setRotateVelocityAnimationEnabled(boolean rotateVelocityAnimationEnabled) {
        this.rotateVelocityAnimationEnabled = rotateVelocityAnimationEnabled;
    }

    public boolean isFlingVelocityAnimationEnabled() {
        return this.flingVelocityAnimationEnabled;
    }

    public void setFlingVelocityAnimationEnabled(boolean flingVelocityAnimationEnabled) {
        this.flingVelocityAnimationEnabled = flingVelocityAnimationEnabled;
    }

    public void setAllVelocityAnimationsEnabled(boolean allVelocityAnimationsEnabled) {
        this.setScaleVelocityAnimationEnabled(allVelocityAnimationsEnabled);
        this.setRotateVelocityAnimationEnabled(allVelocityAnimationsEnabled);
        this.setFlingVelocityAnimationEnabled(allVelocityAnimationsEnabled);
    }

    @Deprecated
    public boolean isIncreaseRotateThresholdWhenScaling() {
        return this.increaseRotateThresholdWhenScaling;
    }

    @Deprecated
    public void setIncreaseRotateThresholdWhenScaling(boolean increaseRotateThresholdWhenScaling) {
        this.increaseRotateThresholdWhenScaling = increaseRotateThresholdWhenScaling;
    }

    public boolean isDisableRotateWhenScaling() {
        return this.disableRotateWhenScaling;
    }

    public void setDisableRotateWhenScaling(boolean disableRotateWhenScaling) {
        this.disableRotateWhenScaling = disableRotateWhenScaling;
    }

    public boolean isIncreaseScaleThresholdWhenRotating() {
        return this.increaseScaleThresholdWhenRotating;
    }

    public void setIncreaseScaleThresholdWhenRotating(boolean increaseScaleThresholdWhenRotating) {
        this.increaseScaleThresholdWhenRotating = increaseScaleThresholdWhenRotating;
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setScrollGesturesEnabled(enabled);
        this.setRotateGesturesEnabled(enabled);
        this.setTiltGesturesEnabled(enabled);
        this.setZoomGesturesEnabled(enabled);
        this.setDoubleTapGesturesEnabled(enabled);
        this.setQuickZoomGesturesEnabled(enabled);
    }

    public boolean areAllGesturesEnabled() {
        return this.rotateGesturesEnabled && this.tiltGesturesEnabled && this.zoomGesturesEnabled && this.scrollGesturesEnabled && this.doubleTapGesturesEnabled && this.quickZoomGesturesEnabled;
    }

    private void saveFocalPoint(Bundle outState) {
        outState.putParcelable("maphero_userFocalPoint", (Parcelable)this.getFocalPoint());
    }

    private void restoreFocalPoint(Bundle savedInstanceState) {
        PointF pointF = (PointF)savedInstanceState.getParcelable("maphero_userFocalPoint");
        if (pointF != null) {
            this.setFocalPoint(pointF);
        }
    }

    public void setFocalPoint(@Nullable PointF focalPoint) {
        this.userProvidedFocalPoint = focalPoint;
        this.focalPointChangeListener.onFocalPointChanged(focalPoint);
    }

    @Nullable
    public PointF getFocalPoint() {
        return this.userProvidedFocalPoint;
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    float getPixelRatio() {
        return this.pixelRatio;
    }

    public void invalidate() {
        this.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.setCompassEnabled(this.isCompassEnabled());
        this.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
        this.setAttributionMargins(this.getAttributionMarginLeft(), this.getAttributionMarginTop(), this.getAttributionMarginRight(), this.getAttributionMarginBottom());
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int[] initMargins, int left, int top, int right, int bottom) {
        initMargins[0] = left;
        initMargins[1] = top;
        initMargins[2] = right;
        initMargins[3] = bottom;
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(left);
            layoutParams.setMarginEnd(right);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

