/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps.renderer;

import android.content.Context;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import org.maphero.android.LibraryLoader;
import org.maphero.android.log.Logger;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.MapHeroMapOptions;
import org.maphero.android.maps.renderer.MapRendererFactory;
import org.maphero.android.maps.renderer.MapRendererRunnable;
import org.maphero.android.maps.renderer.MapRendererScheduler;

@Keep
public abstract class MapRenderer
implements MapRendererScheduler {
    private static final String TAG = "Mbgl-MapRenderer";
    private long nativePtr = 0L;
    private double expectedRenderTime = 0.0;
    private MapHeroMap.OnFpsChangedListener onFpsChangedListener;
    private long timeElapsed;

    public static MapRenderer create(MapHeroMapOptions options, @NonNull Context context, Runnable initCallback) {
        MapRenderer renderer = null;
        String localFontFamily = options.getLocalIdeographFontFamily();
        if (options.getTextureMode()) {
            TextureView textureView = new TextureView(context);
            boolean translucentSurface = options.getTranslucentTextureSurface();
            renderer = MapRendererFactory.newTextureViewMapRenderer(context, textureView, localFontFamily, translucentSurface, initCallback);
        } else {
            boolean renderSurfaceOnTop = options.getRenderSurfaceOnTop();
            renderer = MapRendererFactory.newSurfaceViewMapRenderer(context, localFontFamily, renderSurfaceOnTop, initCallback);
        }
        return renderer;
    }

    public MapRenderer(@NonNull Context context, String localIdeographFontFamily) {
        float pixelRatio = context.getResources().getDisplayMetrics().density;
        this.nativeInitialize(this, pixelRatio, localIdeographFontFamily);
    }

    public abstract View getView();

    public void onStart() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }

    public void setOnFpsChangedListener(MapHeroMap.OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
    }

    @CallSuper
    protected void onSurfaceCreated(Surface surface) {
        this.nativeOnSurfaceCreated(surface);
    }

    @CallSuper
    protected void onSurfaceChanged(int width, int height) {
        this.nativeOnSurfaceChanged(width, height);
    }

    @CallSuper
    protected void onSurfaceDestroyed() {
        this.nativeOnSurfaceDestroyed();
    }

    @CallSuper
    protected void onDrawFrame() {
        long startTime = System.nanoTime();
        try {
            this.nativeRender();
        }
        catch (Error error) {
            Logger.e(TAG, error.getMessage());
        }
        long renderTime = System.nanoTime() - startTime;
        if ((double)renderTime < this.expectedRenderTime) {
            try {
                Thread.sleep((long)((this.expectedRenderTime - (double)renderTime) / 1000000.0));
            }
            catch (InterruptedException ex) {
                Logger.e(TAG, ex.getMessage());
            }
        }
        if (this.onFpsChangedListener != null) {
            this.updateFps();
        }
    }

    public void setSwapBehaviorFlush(boolean flush) {
        this.nativeSetSwapBehaviorFlush(flush);
    }

    @CallSuper
    void queueEvent(MapRendererRunnable runnable) {
        this.queueEvent((Runnable)runnable);
    }

    private native void nativeInitialize(MapRenderer var1, float var2, String var3);

    @CallSuper
    protected native void finalize() throws Throwable;

    private native void nativeOnSurfaceCreated(Surface var1);

    private native void nativeOnSurfaceChanged(int var1, int var2);

    private native void nativeOnSurfaceDestroyed();

    protected native void nativeReset();

    private native void nativeRender();

    private native void nativeSetSwapBehaviorFlush(boolean var1);

    private void updateFps() {
        long currentTime = System.nanoTime();
        if (this.timeElapsed > 0L) {
            double fps = 1.0E9 / (double)(currentTime - this.timeElapsed);
            this.onFpsChangedListener.onFpsChanged(fps);
        }
        this.timeElapsed = currentTime;
    }

    public void setMaximumFps(int maximumFps) {
        if (maximumFps <= 0) {
            return;
        }
        this.expectedRenderTime = 1.0E9 / (double)maximumFps;
    }

    static {
        LibraryLoader.load();
    }
}

