/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps.renderer.egl;

import android.opengl.GLSurfaceView;
import android.os.Build;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import org.maphero.android.constants.MapHeroConstants;
import org.maphero.android.log.Logger;
import org.maphero.android.utils.Compare;

public class EGLConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final String TAG = "Mbgl-EGLConfigChooser";
    private static final int EGL_OPENGL_ES3_BIT = 64;
    private boolean translucentSurface;

    public EGLConfigChooser() {
        this(false);
    }

    public EGLConfigChooser(boolean translucentSurface) {
        this.translucentSurface = translucentSurface;
    }

    public EGLConfig chooseConfig(@NonNull EGL10 egl, EGLDisplay display) {
        EGLConfig[] possibleConfigurations;
        EGLConfig config;
        int[] configAttribs = this.getConfigAttributes();
        int[] numConfigs = this.getNumberOfConfigurations(egl, display, configAttribs);
        if (numConfigs[0] < 1) {
            Logger.e(TAG, "eglChooseConfig() returned no configs.");
        }
        if ((config = this.chooseBestMatchConfig(egl, display, possibleConfigurations = this.getPossibleConfigurations(egl, display, configAttribs, numConfigs))) == null) {
            Logger.e(TAG, "No config chosen");
        }
        return config;
    }

    @NonNull
    private int[] getNumberOfConfigurations(EGL10 egl, EGLDisplay display, int[] configAttributes) {
        int[] numConfigs = new int[1];
        if (!egl.eglChooseConfig(display, configAttributes, null, 0, numConfigs)) {
            Logger.e(TAG, String.format(MapHeroConstants.MAPHERO_LOCALE, "eglChooseConfig(NULL) returned error %d", egl.eglGetError()));
        }
        return numConfigs;
    }

    @NonNull
    private EGLConfig[] getPossibleConfigurations(EGL10 egl, EGLDisplay display, int[] configAttributes, int[] numConfigs) {
        EGLConfig[] configs = new EGLConfig[numConfigs[0]];
        if (!egl.eglChooseConfig(display, configAttributes, configs, numConfigs[0], numConfigs)) {
            Logger.e(TAG, String.format(MapHeroConstants.MAPHERO_LOCALE, "eglChooseConfig() returned error %d", egl.eglGetError()));
        }
        return configs;
    }

    private EGLConfig chooseBestMatchConfig(@NonNull EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
        class Config
        implements Comparable<Config> {
            private final BufferFormat bufferFormat;
            private final DepthStencilFormat depthStencilFormat;
            private final boolean isCaveat;
            private final int index;
            private final EGLConfig config;

            public Config(BufferFormat bufferFormat, DepthStencilFormat depthStencilFormat, boolean isCaveat, int index, EGLConfig config) {
                this.bufferFormat = bufferFormat;
                this.depthStencilFormat = depthStencilFormat;
                this.isCaveat = isCaveat;
                this.index = index;
                this.config = config;
            }

            @Override
            public int compareTo(@NonNull Config other) {
                int i = Compare.compare(this.bufferFormat.value, other.bufferFormat.value);
                if (i != 0) {
                    return i;
                }
                i = Compare.compare(this.depthStencilFormat.value, other.depthStencilFormat.value);
                if (i != 0) {
                    return i;
                }
                i = Compare.compare(this.isCaveat, other.isCaveat);
                if (i != 0) {
                    return i;
                }
                i = Compare.compare(this.index, other.index);
                if (i != 0) {
                    return i;
                }
                return 0;
            }
        }
        ArrayList<Config> matches = new ArrayList<Config>();
        int i = 0;
        for (EGLConfig config : configs) {
            boolean isCaveat;
            if (config == null) continue;
            ++i;
            int caveat = this.getConfigAttr(egl, display, config, 12327);
            int bits = this.getConfigAttr(egl, display, config, 12320);
            int red = this.getConfigAttr(egl, display, config, 12324);
            int green = this.getConfigAttr(egl, display, config, 12323);
            int blue = this.getConfigAttr(egl, display, config, 12322);
            int alpha = this.getConfigAttr(egl, display, config, 12321);
            int alphaMask = this.getConfigAttr(egl, display, config, 12350);
            int depth = this.getConfigAttr(egl, display, config, 12325);
            int stencil = this.getConfigAttr(egl, display, config, 12326);
            int sampleBuffers = this.getConfigAttr(egl, display, config, 12338);
            int samples = this.getConfigAttr(egl, display, config, 12337);
            boolean configOk = depth == 24 || depth == 16;
            configOk &= stencil == 8;
            configOk &= sampleBuffers == 0;
            if (!(configOk &= samples == 0)) continue;
            BufferFormat bufferFormat = bits == 16 && red == 5 && green == 6 && blue == 5 && alpha == 0 ? BufferFormat.Format16Bit : (bits == 32 && red == 8 && green == 8 && blue == 8 && alpha == 0 ? BufferFormat.Format32BitNoAlpha : (bits == 32 && red == 8 && green == 8 && blue == 8 && alpha == 8 ? BufferFormat.Format32BitAlpha : (bits == 24 && red == 8 && green == 8 && blue == 8 && alpha == 0 ? BufferFormat.Format24Bit : BufferFormat.Unknown)));
            DepthStencilFormat depthStencilFormat = depth == 16 && stencil == 8 ? DepthStencilFormat.Format16Depth8Stencil : DepthStencilFormat.Format24Depth8Stencil;
            boolean bl = isCaveat = caveat != 12344;
            if (bufferFormat == BufferFormat.Unknown) continue;
            matches.add(new Config(bufferFormat, depthStencilFormat, isCaveat, i, config));
        }
        Collections.sort(matches);
        if (matches.size() == 0) {
            Logger.e(TAG, "No matching configurations after filtering");
            return null;
        }
        Config bestMatch = (Config)matches.get(0);
        if (bestMatch.isCaveat) {
            Logger.w(TAG, "Chosen config has a caveat.");
        }
        return bestMatch.config;
    }

    private int getConfigAttr(EGL10 egl, EGLDisplay display, EGLConfig config, int attributeName) {
        int[] attributevalue = new int[1];
        if (!egl.eglGetConfigAttrib(display, config, attributeName, attributevalue)) {
            Logger.e(TAG, String.format(MapHeroConstants.MAPHERO_LOCALE, "eglGetConfigAttrib(%d) returned error %d", attributeName, egl.eglGetError()));
        }
        return attributevalue[0];
    }

    private int[] getConfigAttributes() {
        boolean emulator = this.inEmulator() || this.inGenymotion();
        Logger.i(TAG, String.format("In emulator: %s", emulator));
        return new int[]{12327, 12344, 12339, 4, 12320, 16, 12324, 5, 12323, 6, 12322, 5, 12321, this.translucentSurface ? 8 : 0, 12325, 16, 12326, 8, emulator ? 12344 : 12351, 12430, 12352, 64, 12344};
    }

    private boolean inEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT) || System.getProperty("ro.kernel.qemu") != null;
    }

    private boolean inGenymotion() {
        return Build.MANUFACTURER.contains("Genymotion");
    }

    static enum BufferFormat {
        Format16Bit(3),
        Format32BitNoAlpha(1),
        Format32BitAlpha(2),
        Format24Bit(0),
        Unknown(4);

        int value;

        private BufferFormat(int value) {
            this.value = value;
        }
    }

    static enum DepthStencilFormat {
        Format16Depth8Stencil(1),
        Format24Depth8Stencil(0);

        int value;

        private DepthStencilFormat(int value) {
            this.value = value;
        }
    }
}

