/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps.renderer.textureview;

import android.content.Context;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import org.maphero.android.maps.renderer.MapRenderer;
import org.maphero.android.maps.renderer.textureview.TextureViewRenderThread;

public class TextureViewMapRenderer
extends MapRenderer {
    private TextureViewRenderThread renderThread;
    private boolean translucentSurface;
    private TextureView textureView;

    public TextureViewMapRenderer(@NonNull Context context, @NonNull TextureView textureView, String localIdeographFontFamily, boolean translucentSurface) {
        super(context, localIdeographFontFamily);
        this.textureView = textureView;
        this.translucentSurface = translucentSurface;
    }

    public void setRenderThread(TextureViewRenderThread thread) {
        this.renderThread = thread;
        this.renderThread.setName("TextureViewRenderer");
        this.renderThread.start();
    }

    @Override
    public View getView() {
        return this.textureView;
    }

    @Override
    protected void onSurfaceCreated(Surface surface) {
        super.onSurfaceCreated(surface);
    }

    @Override
    protected void onSurfaceChanged(int width, int height) {
        super.onSurfaceChanged(width, height);
    }

    @Override
    protected void onSurfaceDestroyed() {
        super.onSurfaceDestroyed();
    }

    @Override
    protected void onDrawFrame() {
        super.onDrawFrame();
    }

    @Override
    public void requestRender() {
        this.renderThread.requestRender();
    }

    @Override
    public void queueEvent(Runnable runnable) {
        this.renderThread.queueEvent(runnable);
    }

    @Override
    public void waitForEmpty() {
        this.renderThread.waitForEmpty();
    }

    @Override
    public void onStop() {
        this.renderThread.onPause();
    }

    @Override
    public void onStart() {
        this.renderThread.onResume();
    }

    @Override
    public void onDestroy() {
        this.renderThread.onDestroy();
    }

    public boolean isTranslucentSurface() {
        return this.translucentSurface;
    }
}

