/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps.renderer.textureview;

import android.graphics.SurfaceTexture;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import java.util.ArrayList;
import org.maphero.android.maps.renderer.textureview.TextureViewMapRenderer;

abstract class TextureViewRenderThread
extends Thread
implements TextureView.SurfaceTextureListener {
    protected static final String TAG = "Mbgl-TextureViewRenderThread";
    @NonNull
    protected final TextureViewMapRenderer mapRenderer;
    protected final Object lock = new Object();
    protected final ArrayList<Runnable> eventQueue = new ArrayList();
    @Nullable
    protected SurfaceTexture surfaceTexture;
    protected boolean hasNativeSurface;
    protected int width;
    protected int height;
    protected boolean requestRender;
    protected boolean sizeChanged;
    protected boolean paused;
    protected boolean destroySurface;
    protected boolean shouldExit;
    protected boolean exited;

    @UiThread
    TextureViewRenderThread(@NonNull TextureView textureView, @NonNull TextureViewMapRenderer mapRenderer) {
        textureView.setOpaque(!mapRenderer.isTranslucentSurface());
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.mapRenderer = mapRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            this.surfaceTexture = surfaceTexture;
            this.width = width;
            this.height = height;
            this.requestRender = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            this.width = width;
            this.height = height;
            this.sizeChanged = true;
            this.requestRender = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        Object object = this.lock;
        synchronized (object) {
            this.surfaceTexture = null;
            this.destroySurface = true;
            this.requestRender = false;
            this.lock.notifyAll();
        }
        return true;
    }

    @UiThread
    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRender() {
        Object object = this.lock;
        synchronized (object) {
            this.requestRender = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEvent(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            this.eventQueue.add(runnable);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void waitForEmpty() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.eventQueue.isEmpty()) {
                try {
                    this.lock.wait(0L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onPause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onResume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onDestroy() {
        Object object = this.lock;
        synchronized (object) {
            this.shouldExit = true;
            this.lock.notifyAll();
            while (!this.exited) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

