/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.net;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.maphero.android.log.Logger;
import org.maphero.android.net.ConnectivityListener;
import org.maphero.android.net.NativeConnectivityListener;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static final String TAG = "Mbgl-ConnectivityReceiver";
    private static final String LOG_CONNECTED = "connected - true";
    private static final String LOG_NOT_CONNECTED = "connected - false";
    @SuppressLint(value={"StaticFieldLeak"})
    private static ConnectivityReceiver INSTANCE;
    @NonNull
    private List<ConnectivityListener> listeners = new CopyOnWriteArrayList<ConnectivityListener>();
    private Context context;
    private int activationCounter;
    @Nullable
    private Boolean connected;

    public static synchronized ConnectivityReceiver instance(@NonNull Context context) {
        if (INSTANCE == null) {
            INSTANCE = new ConnectivityReceiver(context.getApplicationContext());
            INSTANCE.addListener(new NativeConnectivityListener());
        }
        return INSTANCE;
    }

    private ConnectivityReceiver(@NonNull Context context) {
        this.context = context;
    }

    @UiThread
    public void activate() {
        if (this.activationCounter == 0) {
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        ++this.activationCounter;
    }

    @UiThread
    public void deactivate() {
        --this.activationCounter;
        if (this.activationCounter == 0) {
            this.context.unregisterReceiver((BroadcastReceiver)INSTANCE);
        }
    }

    public void onReceive(@NonNull Context context, Intent intent) {
        if (this.connected != null) {
            return;
        }
        this.notifyListeners(this.isNetworkActive());
    }

    public void setConnected(Boolean connected) {
        this.connected = connected;
        boolean state = connected != null ? connected.booleanValue() : this.isNetworkActive();
        this.notifyListeners(state);
    }

    private void notifyListeners(boolean isConnected) {
        Logger.v(TAG, isConnected ? LOG_CONNECTED : LOG_NOT_CONNECTED);
        for (ConnectivityListener listener : this.listeners) {
            listener.onNetworkStateChanged(isConnected);
        }
    }

    public void addListener(@NonNull ConnectivityListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull ConnectivityListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isConnected() {
        return this.connected != null ? this.connected.booleanValue() : this.isNetworkActive();
    }

    private boolean isNetworkActive() {
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }
}

