/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.offline;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.geometry.LatLngBounds;
import org.maphero.android.offline.OfflineRegionDefinition;
import org.maplibre.geojson.Feature;
import org.maplibre.geojson.Geometry;
import org.maplibre.turf.TurfMeasurement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B5\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB=\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000b\u0010\u0012J\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020&H\u0016R$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00038\u0016@RX\u0097\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00058\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078\u0016@RX\u0097\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078\u0016@RX\u0097\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R \u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8\u0016@RX\u0097\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e8\u0016@RX\u0097\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/maphero/android/offline/OfflineGeometryRegionDefinition;", "Lorg/maphero/android/offline/OfflineRegionDefinition;", "styleURL", "", "geometry", "Lorg/maplibre/geojson/Geometry;", "minZoom", "", "maxZoom", "pixelRatio", "", "<init>", "(Ljava/lang/String;Lorg/maplibre/geojson/Geometry;DDF)V", "includeIdeographs", "", "(Ljava/lang/String;Lorg/maplibre/geojson/Geometry;DDFZ)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "value", "getStyleURL", "()Ljava/lang/String;", "getGeometry", "()Lorg/maplibre/geojson/Geometry;", "getMinZoom", "()D", "getMaxZoom", "getPixelRatio", "()F", "getIncludeIdeographs", "()Z", "bounds", "Lorg/maphero/android/geometry/LatLngBounds;", "getBounds", "()Lorg/maphero/android/geometry/LatLngBounds;", "type", "getType", "describeContents", "", "writeToParcel", "", "dest", "flags", "Companion", "MapHeroAndroid_legacyRelease"})
public final class OfflineGeometryRegionDefinition
implements OfflineRegionDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Keep
    @Nullable
    private String styleURL;
    @Keep
    @Nullable
    private Geometry geometry;
    @Keep
    private double minZoom;
    @Keep
    private double maxZoom;
    @Keep
    private float pixelRatio;
    @Keep
    private boolean includeIdeographs;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<?> CREATOR = (Parcelable.Creator)new Parcelable.Creator<Object>(){

        public OfflineGeometryRegionDefinition createFromParcel(Parcel in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            return new OfflineGeometryRegionDefinition(in);
        }

        public OfflineGeometryRegionDefinition[] newArray(int size) {
            return new OfflineGeometryRegionDefinition[size];
        }
    };

    @Override
    @Nullable
    public String getStyleURL() {
        return this.styleURL;
    }

    @Nullable
    public final Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public double getMinZoom() {
        return this.minZoom;
    }

    @Override
    public double getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public boolean getIncludeIdeographs() {
        return this.includeIdeographs;
    }

    @Keep
    public OfflineGeometryRegionDefinition(@Nullable String styleURL, @Nullable Geometry geometry, double minZoom, double maxZoom, float pixelRatio) {
        this(styleURL, geometry, minZoom, maxZoom, pixelRatio, false);
    }

    @Keep
    public OfflineGeometryRegionDefinition(@Nullable String styleURL, @Nullable Geometry geometry, double minZoom, double maxZoom, float pixelRatio, boolean includeIdeographs) {
        this.styleURL = styleURL;
        this.geometry = geometry;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.pixelRatio = pixelRatio;
        this.includeIdeographs = includeIdeographs;
    }

    public OfflineGeometryRegionDefinition(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        this.styleURL = parcel.readString();
        String string = parcel.readString();
        Intrinsics.checkNotNull((Object)string);
        this.geometry = Feature.fromJson((String)string).geometry();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
        this.includeIdeographs = parcel.readByte() != 0;
    }

    @Override
    @Nullable
    public LatLngBounds getBounds() {
        if (this.geometry == null) {
            return null;
        }
        double[] bbox = TurfMeasurement.bbox((Geometry)this.geometry);
        return LatLngBounds.Companion.from(bbox[3], bbox[2], bbox[1], bbox[0]);
    }

    @Override
    @NotNull
    public String getType() {
        return "shaperegion";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.getStyleURL());
        dest.writeString(Feature.fromGeometry((Geometry)this.geometry).toJson());
        dest.writeDouble(this.getMinZoom());
        dest.writeDouble(this.getMaxZoom());
        dest.writeFloat(this.getPixelRatio());
        dest.writeByte((byte)(this.getIncludeIdeographs() ? 1 : 0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/maphero/android/offline/OfflineGeometryRegionDefinition$Companion;", "", "<init>", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

