/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.style.sources;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.maphero.android.style.sources.GeoJsonSource;
import org.maphero.android.style.sources.LiveGeoJsonOptions;

public class LiveGeoJsonSource
extends GeoJsonSource {
    private LiveGeoJsonOptions options;

    public LiveGeoJsonSource(@Nullable String id2, @NonNull LiveGeoJsonOptions options) {
        super(id2);
        this.options = options;
        this.periodicUpdate();
    }

    private void periodicUpdate() {
        final String fetchUrl = this.options.fetchUrl;
        if (fetchUrl == null) {
            return;
        }
        final long fetchPeriod = this.options.fetchInterval;
        final String method = this.options.fetchMethod;
        final Map<String, String> headers = this.options.fetchHeaders;
        Thread thread = new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    String geoJson = LiveGeoJsonSource.callGeoJsonApi(fetchUrl, method, headers);
                    LiveGeoJsonSource.this.setGeoJson(geoJson);
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.postDelayed(() -> LiveGeoJsonSource.this.periodicUpdate(), fetchPeriod);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public static String callGeoJsonApi(String urlString, String method, Map<String, String> headers) throws Exception {
        String line;
        int responseCode;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setConnectTimeout(60000);
        conn.setReadTimeout(60000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((responseCode = conn.getResponseCode()) >= 400 ? conn.getErrorStream() : conn.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        conn.disconnect();
        return response.toString();
    }
}

