/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.utils;

import android.os.AsyncTask;
import androidx.annotation.NonNull;
import java.io.File;
import org.maphero.android.log.Logger;

public class FileUtils {
    private static final String TAG = "Mbgl-FileUtils";

    public static void deleteFile(final @NonNull String path) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(path);
                    if (file.exists()) {
                        if (file.delete()) {
                            Logger.d(FileUtils.TAG, "File deleted to save space: " + path);
                        } else {
                            Logger.e(FileUtils.TAG, "Failed to delete file: " + path);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.e(FileUtils.TAG, "Failed to delete file: ", exception);
                }
            }
        }).start();
    }

    public static interface OnCheckFileWritePermissionListener {
        public void onWritePermissionGranted();

        public void onError();
    }

    public static class CheckFileWritePermissionTask
    extends AsyncTask<File, Void, Boolean> {
        @NonNull
        private final OnCheckFileWritePermissionListener listener;

        public CheckFileWritePermissionTask(@NonNull OnCheckFileWritePermissionListener listener) {
            this.listener = listener;
        }

        protected Boolean doInBackground(File ... files) {
            try {
                return files[0].canWrite();
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onCancelled() {
            this.listener.onError();
        }

        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                this.listener.onWritePermissionGranted();
            } else {
                this.listener.onError();
            }
        }
    }

    public static interface OnCheckFileReadPermissionListener {
        public void onReadPermissionGranted();

        public void onError();
    }

    public static class CheckFileReadPermissionTask
    extends AsyncTask<File, Void, Boolean> {
        @NonNull
        private final OnCheckFileReadPermissionListener listener;

        public CheckFileReadPermissionTask(@NonNull OnCheckFileReadPermissionListener listener) {
            this.listener = listener;
        }

        protected Boolean doInBackground(File ... files) {
            try {
                return files[0].canRead();
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onCancelled() {
            this.listener.onError();
        }

        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                this.listener.onReadPermissionGranted();
            } else {
                this.listener.onError();
            }
        }
    }
}

