/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.AppendOnlyLogWithLocation;
import io.mashona.logwriting.PersistenceHandle;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32C;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class AppendOnlyLogImpl
implements AppendOnlyLogWithLocation {
    private static final XLogger logger = XLoggerFactory.getXLogger(AppendOnlyLogImpl.class);
    private static final byte[] MAGIC_HEADER = new String("TRBAOL01").getBytes(StandardCharsets.UTF_8);
    private static final int INT_SIZE = 4;
    private static final int BLOCK_SIZE = 256;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int MAGIC_OFFSET = 0;
    private static final int PADDING_SIZE_OFFSET = 0 + MAGIC_HEADER.length;
    private static final int CHECKPOINT_OFFSET = PADDING_SIZE_OFFSET + 4;
    private static final int LINEAR_ORDERING_OFFSET = CHECKPOINT_OFFSET + 4;
    private static final int FIRST_RECORD_OFFSET;
    private static final int LOG_HEADER_BYTES;
    private static final int ENTRY_HEADER_SIZE = 8;
    private static final int PER_ENTRY_OVERHEAD = 8;
    private final Lock lock = new ReentrantLock();
    private final PersistenceHandle persistenceHandle;
    private final ByteBuffer buffer;
    private int effectivePaddingSize;
    private final int requestedPaddingSize;
    private boolean effectiveLinearOrdering;
    private final boolean requestedLinearOrdering;
    private int epoch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppendOnlyLogImpl(MappedByteBuffer byteBuffer, int offset, int length, boolean blockPadding, boolean linearOrdering) {
        logger.entry(new Object[]{byteBuffer, offset, length, blockPadding});
        this.lock.lock();
        try {
            this.requestedPaddingSize = blockPadding ? 256 : 4;
            this.requestedLinearOrdering = linearOrdering;
            this.persistenceHandle = new PersistenceHandle(byteBuffer, offset, length);
            ByteBuffer tmp = byteBuffer.slice();
            tmp.position(offset);
            tmp.limit(length);
            this.buffer = tmp.slice();
            byte[] header = new byte[MAGIC_HEADER.length];
            this.buffer.get(header);
            if (Arrays.equals(header, MAGIC_HEADER)) {
                this.effectivePaddingSize = this.buffer.getInt(PADDING_SIZE_OFFSET);
                this.effectiveLinearOrdering = this.buffer.getInt(LINEAR_ORDERING_OFFSET) == 1;
                this.recoverRecords();
            } else {
                this.effectivePaddingSize = this.requestedPaddingSize;
                this.effectiveLinearOrdering = this.requestedLinearOrdering;
                this.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    @Override
    public boolean isEffectivelyPadded() {
        return this.effectivePaddingSize == 256;
    }

    @Override
    public boolean isPaddingRequested() {
        return this.requestedPaddingSize == 256;
    }

    @Override
    public boolean isEffectiveLinearOrdering() {
        return this.effectiveLinearOrdering;
    }

    @Override
    public boolean isRequestedLinearOrdering() {
        return this.requestedLinearOrdering;
    }

    @Override
    public void checkpoint() {
        logger.entry(new Object[0]);
        this.lock.lock();
        try {
            this.buffer.putInt(CHECKPOINT_OFFSET, this.buffer.position());
            this.persistenceHandle.persist(0, LOG_HEADER_BYTES);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    @Override
    public void put(byte[] src) {
        this.put(ByteBuffer.wrap(src));
    }

    @Override
    public int putWithLocation(byte[] src) {
        return this.putWithLocation(ByteBuffer.wrap(src));
    }

    @Override
    public boolean tryPut(byte[] src) {
        return this.tryPut(ByteBuffer.wrap(src));
    }

    @Override
    public int tryPutWithLocation(byte[] src) {
        return this.tryPutWithLocation(ByteBuffer.wrap(src));
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        this.put(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public int putWithLocation(byte[] src, int offset, int length) {
        return this.putWithLocation(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public boolean tryPut(byte[] src, int offset, int length) {
        return this.tryPut(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public int tryPutWithLocation(byte[] src, int offset, int length) {
        return this.tryPutWithLocation(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public void put(ByteBuffer src) {
        this.putWithLocation(src);
    }

    @Override
    public int putWithLocation(ByteBuffer src) {
        logger.entry(new Object[]{src});
        int location = this.tryPutWithLocation(src);
        if (location == -1) {
            BufferOverflowException e = new BufferOverflowException();
            logger.throwing((Throwable)e);
            throw e;
        }
        logger.exit((Object)location);
        return location;
    }

    @Override
    public boolean tryPut(ByteBuffer src) {
        return this.tryPutWithLocation(src) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tryPutWithLocation(ByteBuffer src) {
        int deferredRecordBytesLength;
        int recordBytesFittingInFirstCacheLine;
        logger.entry(new Object[]{src});
        ByteBuffer srcSlice = src.slice();
        int payloadLength = srcSlice.remaining();
        if (payloadLength == 0) {
            logger.exit((Object)-1);
            return -1;
        }
        CRC32C crc32c = new CRC32C();
        crc32c.update(srcSlice);
        int checksum = (int)crc32c.getValue();
        srcSlice.rewind();
        int recordStartPosition = 0;
        int recordLength = 0;
        ByteBuffer payloadBuffer = null;
        ByteBuffer deferredSlice = null;
        this.lock.lock();
        try {
            if (!this.canAcceptInternal(payloadLength)) {
                logger.exit((Object)-1);
                int n = -1;
                return n;
            }
            recordStartPosition = this.buffer.position();
            this.buffer.putInt(payloadLength);
            this.buffer.putInt(checksum);
            int payloadStartPosition = this.buffer.position();
            payloadBuffer = this.buffer.slice();
            payloadBuffer.limit(payloadLength);
            payloadBuffer = payloadBuffer.slice();
            this.buffer.position(this.buffer.position() + payloadLength);
            this.padRecord();
            recordLength = this.buffer.position() - recordStartPosition;
            int nonPayloadBytesInFirstCacheLine = payloadStartPosition % 64;
            int payloadCapacityInFistCacheLine = nonPayloadBytesInFirstCacheLine == 0 ? 0 : 64 - nonPayloadBytesInFirstCacheLine;
            recordBytesFittingInFirstCacheLine = 8 + payloadCapacityInFistCacheLine;
            deferredRecordBytesLength = recordLength - recordBytesFittingInFirstCacheLine;
            if (!this.effectiveLinearOrdering && payloadCapacityInFistCacheLine != 0 && payloadCapacityInFistCacheLine < payloadLength) {
                ByteBuffer immediateSlice = srcSlice.duplicate().position(0).limit(payloadCapacityInFistCacheLine).duplicate();
                deferredSlice = srcSlice.duplicate().position(payloadCapacityInFistCacheLine).limit(payloadLength).slice();
                payloadBuffer.put(immediateSlice);
                this.persistenceHandle.persist(recordStartPosition, 8 + payloadCapacityInFistCacheLine);
            } else {
                payloadBuffer.put(srcSlice);
                this.persistenceHandle.persist(recordStartPosition, recordLength);
            }
            src.position(src.position() + payloadLength);
        }
        finally {
            this.lock.unlock();
        }
        if (deferredSlice != null) {
            payloadBuffer.put(deferredSlice);
            this.persistenceHandle.persist(recordStartPosition + recordBytesFittingInFirstCacheLine, deferredRecordBytesLength);
        }
        logger.exit((Object)recordStartPosition);
        return recordStartPosition;
    }

    @Override
    public void clear() {
        logger.entry(new Object[0]);
        this.lock.lock();
        try {
            this.buffer.clear();
            this.buffer.position(0);
            this.buffer.put(MAGIC_HEADER);
            this.buffer.position(PADDING_SIZE_OFFSET);
            this.buffer.putInt(this.effectivePaddingSize);
            this.buffer.position(LINEAR_ORDERING_OFFSET);
            this.buffer.putInt(this.effectiveLinearOrdering ? 1 : 0);
            this.persistenceHandle.persist(0, LOG_HEADER_BYTES);
            this.buffer.clear();
            byte[] zeros = new byte[0x100000];
            while (this.buffer.remaining() > 0) {
                this.buffer.put(zeros, 0, this.buffer.remaining() > zeros.length ? zeros.length : this.buffer.remaining());
            }
            this.persistenceHandle.persist(0, this.buffer.capacity());
            this.effectivePaddingSize = this.requestedPaddingSize;
            this.effectiveLinearOrdering = this.requestedLinearOrdering;
            this.buffer.clear();
            this.buffer.position(0);
            this.buffer.put(MAGIC_HEADER);
            this.buffer.position(PADDING_SIZE_OFFSET);
            this.buffer.putInt(this.effectivePaddingSize);
            this.buffer.position(LINEAR_ORDERING_OFFSET);
            this.buffer.putInt(this.effectiveLinearOrdering ? 1 : 0);
            this.persistenceHandle.persist(0, LOG_HEADER_BYTES);
            this.buffer.position(FIRST_RECORD_OFFSET);
            ++this.epoch;
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    @Override
    public int remaining() {
        int result;
        logger.entry(new Object[0]);
        this.lock.lock();
        try {
            result = this.buffer.remaining();
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    @Override
    public boolean canAccept(int length) {
        boolean result;
        logger.entry(new Object[]{length});
        this.lock.lock();
        try {
            result = this.canAcceptInternal(length);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    private boolean canAcceptInternal(int length) {
        int recordLength = length + 8;
        int realignment = length % this.effectivePaddingSize;
        if (realignment != 0) {
            recordLength += this.effectivePaddingSize - realignment;
        }
        boolean result = this.buffer.remaining() - recordLength >= 0;
        return result;
    }

    private void padRecord() {
        int x = this.buffer.position() % this.effectivePaddingSize;
        if (x != 0) {
            this.buffer.position(this.buffer.position() + (this.effectivePaddingSize - x));
        }
    }

    private void recoverRecords() {
        logger.entry(new Object[0]);
        int checkpoint = this.buffer.getInt(CHECKPOINT_OFFSET);
        Itr iter = new Itr(checkpoint != 0 ? checkpoint : FIRST_RECORD_OFFSET, false);
        while (iter.hasNext()) {
            iter.next();
        }
        this.buffer.position(iter.iterBuffer.position());
        logger.exit();
    }

    @Override
    public ByteBuffer readRecordAt(int location) {
        CRC32C crc32c = new CRC32C();
        ByteBuffer recordBuffer = this.buffer.duplicate();
        recordBuffer.position(location);
        if (recordBuffer.remaining() < 4) {
            logger.exit();
            throw new IllegalArgumentException("invalid record location " + location);
        }
        int length = recordBuffer.getInt();
        int expectedChecksum = recordBuffer.getInt();
        ByteBuffer dataBuffer = recordBuffer.slice();
        dataBuffer.limit(length);
        recordBuffer.position(recordBuffer.position() + length);
        crc32c.reset();
        crc32c.update(dataBuffer);
        int actualChecksum = (int)crc32c.getValue();
        dataBuffer.rewind();
        if (actualChecksum != expectedChecksum) {
            throw new IllegalStateException("invalid checksum");
        }
        return dataBuffer;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        logger.entry(new Object[0]);
        Itr result = new Itr(FIRST_RECORD_OFFSET, false);
        logger.exit((Object)result);
        return result;
    }

    @Override
    public Iterator<ByteBuffer> copyingIterator() {
        logger.entry(new Object[0]);
        Itr result = new Itr(FIRST_RECORD_OFFSET, true);
        logger.exit((Object)result);
        return result;
    }

    static {
        LOG_HEADER_BYTES = FIRST_RECORD_OFFSET = LINEAR_ORDERING_OFFSET + 4;
    }

    private class Itr
    implements Iterator<ByteBuffer> {
        private final ByteBuffer iterBuffer;
        private final int expectedEpoch;
        private final CRC32C crc32c = new CRC32C();
        private ByteBuffer lookahead;
        private int lookaheadPos = 0;
        private final boolean returnCopies;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Itr(int offset, boolean returnCopies) {
            logger.entry(new Object[0]);
            AppendOnlyLogImpl.this.lock.lock();
            try {
                this.iterBuffer = AppendOnlyLogImpl.this.buffer.duplicate();
                this.iterBuffer.position(offset);
                this.expectedEpoch = AppendOnlyLogImpl.this.epoch;
                this.returnCopies = returnCopies;
            }
            finally {
                AppendOnlyLogImpl.this.lock.unlock();
            }
            logger.exit();
        }

        @Override
        public boolean hasNext() {
            logger.entry(new Object[0]);
            boolean result = false;
            AppendOnlyLogImpl.this.lock.lock();
            try {
                this.checkForReset();
                if (this.lookahead == null) {
                    this.lookahead();
                }
                result = this.lookahead != null;
            }
            finally {
                AppendOnlyLogImpl.this.lock.unlock();
            }
            logger.exit((Object)result);
            return result;
        }

        @Override
        public ByteBuffer next() {
            logger.entry(new Object[0]);
            ByteBuffer result = null;
            AppendOnlyLogImpl.this.lock.lock();
            try {
                this.checkForReset();
                if (!this.hasNext()) {
                    NoSuchElementException e = new NoSuchElementException();
                    logger.throwing((Throwable)e);
                    throw e;
                }
                result = this.lookahead;
                this.iterBuffer.position(this.lookaheadPos);
                this.lookahead = null;
                this.lookaheadPos = 0;
                if (this.returnCopies) {
                    ByteBuffer view = result;
                    result = ByteBuffer.allocate(view.remaining());
                    result.put(view);
                    result.rewind();
                }
            }
            finally {
                AppendOnlyLogImpl.this.lock.unlock();
            }
            logger.exit((Object)result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookahead() {
            logger.entry(new Object[0]);
            int originalPosition = this.iterBuffer.position();
            ByteBuffer byteBuffer = null;
            try {
                do {
                    if (this.iterBuffer.remaining() < 4) {
                        logger.exit();
                        return;
                    }
                    int length = this.iterBuffer.getInt();
                    if (length == 0) {
                        logger.exit();
                        return;
                    }
                    int expectedChecksum = this.iterBuffer.getInt();
                    byteBuffer = this.iterBuffer.slice();
                    byteBuffer.limit(length);
                    this.iterBuffer.position(this.iterBuffer.position() + length);
                    this.crc32c.reset();
                    this.crc32c.update(byteBuffer);
                    int actualChecksum = (int)this.crc32c.getValue();
                    byteBuffer.rewind();
                    int realignment = this.iterBuffer.position() % AppendOnlyLogImpl.this.effectivePaddingSize;
                    if (realignment != 0) {
                        this.iterBuffer.position(this.iterBuffer.position() + (AppendOnlyLogImpl.this.effectivePaddingSize - realignment));
                    }
                    if (actualChecksum == expectedChecksum) break;
                    if (!AppendOnlyLogImpl.this.isEffectiveLinearOrdering()) continue;
                    return;
                } while (this.iterBuffer.hasRemaining());
                this.lookahead = byteBuffer.asReadOnlyBuffer();
                this.lookaheadPos = this.iterBuffer.position();
            }
            finally {
                this.iterBuffer.position(originalPosition);
            }
            logger.exit();
        }

        private void checkForReset() {
            if (AppendOnlyLogImpl.this.epoch != this.expectedEpoch) {
                ConcurrentModificationException e = new ConcurrentModificationException();
                logger.throwing((Throwable)e);
                throw e;
            }
        }
    }
}

