/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.MappedFileChannelMetadata;
import io.mashona.logwriting.PersistenceHandle;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdk.nio.mapmode.ExtendedMapMode;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import sun.misc.Unsafe;

public class MappedFileChannel
extends FileChannel {
    private static final XLogger logger = XLoggerFactory.getXLogger(MappedFileChannel.class);
    private static Unsafe unsafe;
    private final PersistenceHandle persistenceHandle;
    private final Lock lock = new ReentrantLock();
    private final File file;
    private final FileChannel fileChannel;
    private final ByteBuffer rawBuffer;
    private final ByteBuffer dataBuffer;
    private final MappedFileChannelMetadata metadata;

    public static File getMetadataFile(File file) throws IOException {
        return new File(file.getCanonicalPath() + ".pmem");
    }

    public MappedFileChannel(File file, int length, boolean readSharedMetadata) throws IOException {
        logger.entry(new Object[]{this, file, length, readSharedMetadata});
        this.file = file;
        if (!file.exists() && MappedFileChannel.getMetadataFile(file).exists()) {
            logger.trace("deleting orphan metadata for " + file.getAbsolutePath());
            MappedFileChannel.getMetadataFile(file).delete();
        }
        this.fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE), new FileAttribute[0]);
        MappedByteBuffer tmpRawBuffer = this.fileChannel.map(ExtendedMapMode.READ_WRITE_SYNC, 0L, length);
        this.rawBuffer = tmpRawBuffer;
        this.persistenceHandle = new PersistenceHandle(tmpRawBuffer, 0, length);
        ByteBuffer tmp = tmpRawBuffer.slice();
        tmp.position(0);
        tmp.limit(length);
        this.dataBuffer = tmp.slice();
        this.metadata = new MappedFileChannelMetadata(MappedFileChannel.getMetadataFile(file), readSharedMetadata);
        this.dataBuffer.position(0);
        logger.exit((Object)this);
    }

    public MappedFileChannel(File file, int length) throws IOException {
        this(file, length, false);
    }

    public void deleteMetadata() throws IOException {
        logger.entry(new Object[]{this});
        if (this.fileChannel.isOpen()) {
            IOException ioException = new IOException("Unable to delete metadata for an open channel");
            logger.throwing((Throwable)ioException);
            throw ioException;
        }
        File metadata = MappedFileChannel.getMetadataFile(this.file);
        if (metadata.exists()) {
            metadata.delete();
        }
        logger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        logger.entry(new Object[]{this, dst});
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            int position = this.dataBuffer.position();
            int readLength = this.read(dst, position);
            if (readLength > 0) {
                this.dataBuffer.position(position + readLength);
            }
            result = readLength;
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        logger.entry(new Object[]{this, dst, position});
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            this.validatePosition(position);
            int length = this.metadata.getPersistenceIndex() - (int)position;
            if (length <= 0) {
                length = -1;
            }
            if ((length = Math.min(length, dst.remaining())) > 0) {
                ByteBuffer srcSlice = this.dataBuffer.duplicate().position((int)position).limit((int)position + length).duplicate();
                int begin = srcSlice.position();
                dst.put(srcSlice);
                result = srcSlice.position() - begin;
            } else {
                result = length;
            }
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        logger.entry(new Object[]{this, src});
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            result = this.writeInternal(src, this.dataBuffer.position());
            this.dataBuffer.position(this.dataBuffer.position() + result);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        logger.entry(new Object[]{this, src, position});
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            this.validatePosition(position);
            result = this.writeInternal(src, (int)position);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    private int writeInternal(ByteBuffer src, int position) throws ClosedChannelException {
        if (this.metadata.isReadShared()) {
            throw new IllegalStateException();
        }
        if (position < this.metadata.getPersistenceIndex()) {
            throw new IllegalArgumentException();
        }
        int length = Math.min(this.dataBuffer.remaining(), src.remaining());
        ByteBuffer srcSlice = src.duplicate().position(src.position()).limit(src.position() + length).duplicate();
        ByteBuffer dst = this.dataBuffer.duplicate().position(position).limit(position + length).duplicate();
        dst.put(srcSlice);
        src.position(src.position() + length);
        this.persist(position, length);
        return length;
    }

    private void persist(int startIndex, int length) throws ClosedChannelException {
        this.persistenceHandle.persist(startIndex, length);
        this.metadata.persist(startIndex, length);
    }

    @Override
    public long position() throws IOException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            result = this.dataBuffer.position();
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    @Override
    public FileChannel position(long newPosition) throws ClosedChannelException, IOException {
        logger.entry(new Object[]{this, newPosition});
        this.lock.lock();
        try {
            this.validateIsOpen();
            this.validatePosition(newPosition);
            this.dataBuffer.position((int)newPosition);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)this);
        return this;
    }

    @Override
    public long size() throws IOException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        long result = 0L;
        try {
            this.validateIsOpen();
            result = this.dataBuffer.limit();
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    public long getFileSize() {
        logger.entry(new Object[]{this});
        long result = this.file.length();
        logger.exit((Object)result);
        return result;
    }

    public long getPersistedSize() throws ClosedChannelException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        long result = 0L;
        try {
            this.validateIsOpen();
            result = this.metadata.getPersistenceIndex();
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    public void clear() throws ClosedChannelException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        try {
            this.metadata.clear();
            this.clearDataFromOffset(0);
            this.dataBuffer.position(0);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    private void clearDataFromOffset(int offset) {
        this.dataBuffer.clear();
        this.dataBuffer.position(offset);
        byte[] zeros = new byte[0x100000];
        while (this.dataBuffer.remaining() > 0) {
            this.dataBuffer.put(zeros, 0, this.dataBuffer.remaining() > zeros.length ? zeros.length : this.dataBuffer.remaining());
        }
        this.persistenceHandle.persist(0, this.dataBuffer.capacity() - offset);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        try {
            unsafe.invokeCleaner(this.rawBuffer);
            if (!this.metadata.isReadShared()) {
                int persistenceIndex = this.metadata.getPersistenceIndex();
                logger.trace("truncating {} to {}", (Object)this.file.getAbsolutePath(), (Object)persistenceIndex);
                this.fileChannel.truncate(persistenceIndex);
            }
            this.fileChannel.close();
            this.metadata.close();
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    private void validateIsOpen() throws ClosedChannelException {
        if (!this.fileChannel.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            logger.throwing((Throwable)closedChannelException);
            throw closedChannelException;
        }
    }

    private void validatePosition(long position) throws IndexOutOfBoundsException {
        if (position > (long)this.dataBuffer.limit()) {
            IndexOutOfBoundsException e = new IndexOutOfBoundsException("Position " + position + " exceeds limit " + this.dataBuffer.limit());
            logger.throwing((Throwable)e);
            throw e;
        }
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public long write(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long position, long size) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new IOException("method not implemented");
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new IOException("method not implemented");
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

