/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.PersistenceHandle;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdk.nio.mapmode.ExtendedMapMode;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import sun.misc.Unsafe;

public class MappedFileChannelMetadata
implements Closeable {
    private static final XLogger logger = XLoggerFactory.getXLogger(MappedFileChannelMetadata.class);
    private static final byte[] MAGIC_HEADER = new String("TRBMFCM1").getBytes(StandardCharsets.UTF_8);
    private static final int FILE_SIZE = 256;
    private static Unsafe unsafe;
    private final Lock lock = new ReentrantLock();
    private final FileChannel fileChannel;
    private final ByteBuffer buffer;
    private final PersistenceHandle persistenceHandle;
    private final boolean readShared;
    private int persistenceIndex;

    public MappedFileChannelMetadata(File file) throws IOException {
        this(file, false);
    }

    public MappedFileChannelMetadata(File file, boolean readShared) throws IOException {
        logger.entry(new Object[]{file, readShared});
        this.fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE), new FileAttribute[0]);
        MappedByteBuffer tmpRawBuffer = this.fileChannel.map(ExtendedMapMode.READ_WRITE_SYNC, 0L, 256L);
        this.persistenceHandle = new PersistenceHandle(tmpRawBuffer, 0, 256);
        this.readShared = readShared;
        this.buffer = tmpRawBuffer;
        byte[] header = new byte[MAGIC_HEADER.length];
        this.buffer.get(header);
        if (Arrays.equals(header, MAGIC_HEADER)) {
            this.persistenceIndex = this.buffer.getInt(MAGIC_HEADER.length);
        } else {
            this.clear();
        }
        logger.exit((Object)this);
    }

    @Override
    public void close() throws IOException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        try {
            unsafe.invokeCleaner(this.buffer);
            this.fileChannel.close();
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    public int getPersistenceIndex() throws ClosedChannelException {
        int value;
        logger.entry(new Object[]{this});
        this.lock.lock();
        try {
            this.validateIsOpen();
            this.refreshPersistenceIndex();
            value = this.persistenceIndex;
        }
        finally {
            this.lock.unlock();
        }
        logger.exit((Object)value);
        return value;
    }

    public void persist(int startIndex, int length) throws ClosedChannelException {
        logger.entry(new Object[]{this, startIndex, length});
        this.lock.lock();
        try {
            this.validateIsOpen();
            this.refreshPersistenceIndex();
            this.persistenceIndex = startIndex + length;
            this.buffer.putInt(MAGIC_HEADER.length, this.persistenceIndex);
            this.persistenceHandle.persist(MAGIC_HEADER.length, 4);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    public boolean isReadShared() {
        return this.readShared;
    }

    public void clear() throws ClosedChannelException {
        logger.entry(new Object[]{this});
        this.lock.lock();
        try {
            this.validateIsOpen();
            byte[] zeros = new byte[256];
            this.buffer.position(0);
            this.buffer.put(zeros);
            this.persistenceHandle.persist(0, 256);
            this.buffer.position(0);
            this.buffer.put(MAGIC_HEADER);
            this.persistenceHandle.persist(0, MAGIC_HEADER.length);
            this.buffer.position(0);
            this.persistenceIndex = this.buffer.getInt(MAGIC_HEADER.length);
        }
        finally {
            this.lock.unlock();
        }
        logger.exit();
    }

    private void validateIsOpen() throws ClosedChannelException {
        if (!this.fileChannel.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void refreshPersistenceIndex() {
        if (this.readShared) {
            this.persistenceIndex = this.buffer.getInt(MAGIC_HEADER.length);
        }
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

