/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.ArrayStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class PmemUtil {
    private static final XLogger logger = XLoggerFactory.getXLogger(PmemUtil.class);
    private static final Constructor mappedFileChannelConstructor;
    private static final Constructor mappedFileChannelMetadataConstructor;
    private static final Constructor arrayStoreConstructor;

    public static void main(String[] args) {
        File dir = new File(args[0]);
        System.out.println(dir.getAbsolutePath() + ": pmem is " + PmemUtil.isPmemSupportedFor(dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isPmemSupportedFor(File dir) {
        logger.entry(new Object[]{dir.getAbsolutePath()});
        if (mappedFileChannelConstructor == null) {
            logger.exit((Object)false);
            return false;
        }
        if (!dir.exists()) {
            IllegalArgumentException e = new IllegalArgumentException("The directory " + dir.getAbsolutePath() + " must exist");
            logger.throwing((Throwable)e);
            throw e;
        }
        if (!dir.isDirectory()) {
            IllegalArgumentException e = new IllegalArgumentException(dir.getAbsolutePath() + " must be a directory");
            logger.throwing((Throwable)e);
            throw e;
        }
        File testFile = null;
        try {
            testFile = File.createTempFile("isPmemSupportedFor", "", dir);
            Closeable mappedFileChannelMetadata = (Closeable)mappedFileChannelMetadataConstructor.newInstance(testFile);
            mappedFileChannelMetadata.close();
            logger.exit((Object)true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.trace("mmap failed for path {}", (Object)dir.getAbsolutePath(), (Object)e);
            logger.exit((Object)false);
            boolean bl = false;
            return bl;
        }
        finally {
            if (testFile != null && testFile.exists()) {
                testFile.delete();
            }
        }
    }

    public static FileChannel pmemChannelFor(File file, int length, boolean create, boolean readSharedMetadata) throws FileNotFoundException {
        FileChannel fileChannel;
        block5: {
            logger.entry(new Object[]{file.getAbsolutePath(), create});
            if (!PmemUtil.isPmemSupportedFor(file.getParentFile())) {
                logger.exit(null);
                return null;
            }
            long initialSize = 0L;
            if (!create) {
                if (!file.exists()) {
                    FileNotFoundException e = new FileNotFoundException(file.getAbsolutePath());
                    logger.throwing((Throwable)e);
                    throw e;
                }
                initialSize = file.length();
            }
            fileChannel = null;
            try {
                fileChannel = (FileChannel)mappedFileChannelConstructor.newInstance(file, length, readSharedMetadata);
            }
            catch (Exception e) {
                logger.debug("pmem mapping failed for {}. File may need truncation.", (Object)file.getAbsolutePath(), (Object)e);
                fileChannel = null;
                if (!create) break block5;
                file.delete();
            }
        }
        logger.exit(fileChannel);
        return fileChannel;
    }

    public static FileChannel pmemChannelFor(File file, int length, boolean create) throws FileNotFoundException {
        return PmemUtil.pmemChannelFor(file, length, create, false);
    }

    public static ArrayStore arrayStoreFor(File file, int numberOfSlots, int slotDataCapacity) throws IOException {
        logger.entry(new Object[]{file.getAbsolutePath(), numberOfSlots, slotDataCapacity});
        if (!PmemUtil.isPmemSupportedFor(file.getParentFile())) {
            logger.exit(null);
            return null;
        }
        try {
            ArrayStore arrayStore = (ArrayStore)arrayStoreConstructor.newInstance(file, numberOfSlots, slotDataCapacity);
            logger.exit((Object)arrayStore);
            return arrayStore;
        }
        catch (Exception e) {
            IOException ioException = new IOException("Could not create array store", e);
            logger.throwing((Throwable)ioException);
            throw ioException;
        }
    }

    static {
        Constructor<?> fccTmp = null;
        Constructor<?> fccmdTmp = null;
        Constructor<?> asTmp = null;
        try {
            String specVersion = System.getProperty("java.specification.version");
            if (!specVersion.contains(".") && Integer.parseInt(specVersion) >= 14) {
                fccTmp = Class.forName("io.mashona.logwriting.MappedFileChannel").getDeclaredConstructor(File.class, Integer.TYPE, Boolean.TYPE);
                fccmdTmp = Class.forName("io.mashona.logwriting.MappedFileChannelMetadata").getDeclaredConstructor(File.class);
                asTmp = Class.forName("io.mashona.logwriting.ArrayStoreImpl").getDeclaredConstructor(File.class, Integer.TYPE, Integer.TYPE);
            }
        }
        catch (Exception e) {
            logger.debug("Can't wire constructor functions", (Throwable)e);
        }
        mappedFileChannelConstructor = fccTmp;
        mappedFileChannelMetadataConstructor = fccmdTmp;
        arrayStoreConstructor = asTmp;
    }
}

