/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.ArrayStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import org.jboss.logging.Logger;

public class PmemUtil {
    private static final Logger logger = Logger.getLogger(PmemUtil.class);
    private static final Constructor mappedFileChannelConstructor;
    private static final Constructor mappedFileChannelMetadataConstructor;
    private static final Constructor arrayStoreConstructor;

    public static void main(String[] args) {
        File dir = new File(args[0]);
        System.out.println(dir.getAbsolutePath() + ": pmem is " + PmemUtil.isPmemSupportedFor(dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isPmemSupportedFor(File dir) {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry with dir={0}", (Object)dir.getAbsolutePath());
        }
        if (mappedFileChannelConstructor == null) {
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning false", new Object[0]);
            }
            return false;
        }
        if (!dir.exists()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The directory " + dir.getAbsolutePath() + " must exist");
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException.toString());
            }
            throw illegalArgumentException;
        }
        if (!dir.isDirectory()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(dir.getAbsolutePath() + " must be a directory");
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException.toString());
            }
            throw illegalArgumentException;
        }
        File testFile = null;
        try {
            testFile = File.createTempFile("isPmemSupportedFor", "", dir);
            Closeable mappedFileChannelMetadata = (Closeable)mappedFileChannelMetadataConstructor.newInstance(testFile);
            mappedFileChannelMetadata.close();
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning true", new Object[0]);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debugv((Throwable)e, "mmap failed for path {0}", (Object)dir.getAbsolutePath());
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning false", new Object[0]);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (testFile != null && testFile.exists()) {
                testFile.delete();
            }
        }
    }

    public static FileChannel pmemChannelFor(File file, int length, boolean create, boolean readSharedMetadata) throws FileNotFoundException {
        FileChannel fileChannel;
        block10: {
            if (logger.isTraceEnabled()) {
                logger.tracev("entry with file={0}, length={1}, create={2}, readSharedMetadata={3}", new Object[]{file.getAbsolutePath(), length, create, readSharedMetadata});
            }
            if (!PmemUtil.isPmemSupportedFor(file.getParentFile())) {
                if (logger.isTraceEnabled()) {
                    logger.tracev("exit returning null", new Object[0]);
                }
                return null;
            }
            long initialSize = 0L;
            if (!create) {
                if (!file.exists()) {
                    FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getAbsolutePath());
                    if (logger.isTraceEnabled()) {
                        logger.tracev((Throwable)fileNotFoundException, "throwing {0}", (Object)fileNotFoundException.toString());
                    }
                    throw fileNotFoundException;
                }
                initialSize = file.length();
            }
            fileChannel = null;
            try {
                fileChannel = (FileChannel)mappedFileChannelConstructor.newInstance(file, length, readSharedMetadata);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debugv((Throwable)e, "pmem mapping failed for {0}. File may need truncation.", (Object)file.getAbsolutePath());
                }
                fileChannel = null;
                if (!create) break block10;
                file.delete();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", fileChannel);
        }
        return fileChannel;
    }

    public static FileChannel pmemChannelFor(File file, int length, boolean create) throws FileNotFoundException {
        return PmemUtil.pmemChannelFor(file, length, create, false);
    }

    public static ArrayStore arrayStoreFor(File file, int numberOfSlots, int slotDataCapacity) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry with file={0}, numberOfSlots={1}, slotDataCapacity={2}", (Object)file.getAbsolutePath(), (Object)numberOfSlots, (Object)slotDataCapacity);
        }
        if (!PmemUtil.isPmemSupportedFor(file.getParentFile())) {
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning null", new Object[0]);
            }
            return null;
        }
        try {
            ArrayStore arrayStore = (ArrayStore)arrayStoreConstructor.newInstance(file, numberOfSlots, slotDataCapacity);
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning {0}", (Object)arrayStore);
            }
            return arrayStore;
        }
        catch (Exception e) {
            IOException ioException = new IOException("Could not create array store", e);
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)ioException, "throwing {0}", (Object)ioException.toString());
            }
            throw ioException;
        }
    }

    static {
        Constructor<?> fccTmp = null;
        Constructor<?> fccmdTmp = null;
        Constructor<?> asTmp = null;
        try {
            String specVersion = System.getProperty("java.specification.version");
            if (!specVersion.contains(".") && Integer.parseInt(specVersion) >= 14) {
                fccTmp = Class.forName("io.mashona.logwriting.MappedFileChannel").getDeclaredConstructor(File.class, Integer.TYPE, Boolean.TYPE);
                fccmdTmp = Class.forName("io.mashona.logwriting.MappedFileChannelMetadata").getDeclaredConstructor(File.class);
                asTmp = Class.forName("io.mashona.logwriting.ArrayStoreImpl").getDeclaredConstructor(File.class, Integer.TYPE, Integer.TYPE);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Can't wire constructor functions", (Throwable)e);
        }
        mappedFileChannelConstructor = fccTmp;
        mappedFileChannelMetadataConstructor = fccmdTmp;
        arrayStoreConstructor = asTmp;
    }
}

