/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.PersistenceHandle;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdk.nio.mapmode.ExtendedMapMode;
import org.jboss.logging.Logger;
import sun.misc.Unsafe;

public class MappedFileChannelMetadata
implements Closeable {
    private static final Logger logger = Logger.getLogger(MappedFileChannelMetadata.class);
    private static final byte[] MAGIC_HEADER = new String("TRBMFCM1").getBytes(StandardCharsets.UTF_8);
    private static final int FILE_SIZE = 256;
    private static Unsafe unsafe;
    private final Lock lock = new ReentrantLock();
    private final FileChannel fileChannel;
    private final ByteBuffer buffer;
    private final PersistenceHandle persistenceHandle;
    private final boolean readShared;
    private int persistenceIndex;

    public MappedFileChannelMetadata(File file) throws IOException {
        this(file, false);
    }

    public MappedFileChannelMetadata(File file, boolean readShared) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry with file={0}, readShared={1}", (Object)file, (Object)readShared);
        }
        this.fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE), new FileAttribute[0]);
        MappedByteBuffer tmpRawBuffer = this.fileChannel.map(ExtendedMapMode.READ_WRITE_SYNC, 0L, 256L);
        this.persistenceHandle = new PersistenceHandle(tmpRawBuffer, 0, 256);
        this.readShared = readShared;
        this.buffer = tmpRawBuffer;
        byte[] header = new byte[MAGIC_HEADER.length];
        this.buffer.get(header);
        if (Arrays.equals(header, MAGIC_HEADER)) {
            this.persistenceIndex = this.buffer.getInt(MAGIC_HEADER.length);
        } else {
            this.clear();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit {0}", (Object)this);
        }
    }

    @Override
    public void close() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            unsafe.invokeCleaner(this.buffer);
            this.fileChannel.close();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    public int getPersistenceIndex() throws ClosedChannelException {
        int value;
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            this.validateIsOpen();
            this.refreshPersistenceIndex();
            value = this.persistenceIndex;
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)value);
        }
        return value;
    }

    public void persist(int startIndex, int length) throws ClosedChannelException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with startIndex={1}, length={2}", (Object)this, (Object)startIndex, (Object)length);
        }
        this.lock.lock();
        try {
            this.validateIsOpen();
            this.refreshPersistenceIndex();
            this.persistenceIndex = startIndex + length;
            this.buffer.putInt(MAGIC_HEADER.length, this.persistenceIndex);
            this.persistenceHandle.persist(MAGIC_HEADER.length, 4);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    public boolean isReadShared() {
        return this.readShared;
    }

    public void clear() throws ClosedChannelException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            this.validateIsOpen();
            byte[] zeros = new byte[256];
            this.buffer.position(0);
            this.buffer.put(zeros);
            this.persistenceHandle.persist(0, 256);
            this.buffer.put(0, MAGIC_HEADER);
            this.persistenceHandle.persist(0, MAGIC_HEADER.length);
            this.buffer.position(0);
            this.persistenceIndex = this.buffer.getInt(MAGIC_HEADER.length);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    private void validateIsOpen() throws ClosedChannelException {
        if (!this.fileChannel.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)closedChannelException, "throwing {0}", (Object)closedChannelException.toString());
            }
            throw closedChannelException;
        }
    }

    private void refreshPersistenceIndex() {
        if (this.readShared) {
            this.persistenceIndex = this.buffer.getInt(MAGIC_HEADER.length);
        }
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

