/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.AppendOnlyLogImplConfig;
import io.mashona.logwriting.AppendOnlyLogWithLocation;
import io.mashona.logwriting.PersistenceHandle;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32C;
import org.jboss.logging.Logger;

public class AppendOnlyLogImpl
implements AppendOnlyLogWithLocation {
    private static final Logger logger = Logger.getLogger(AppendOnlyLogImpl.class);
    private static final byte[] MAGIC_HEADER = new String("TRBAOL01").getBytes(StandardCharsets.UTF_8);
    private static final int INT_SIZE = 4;
    private static final int BLOCK_SIZE = 256;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int MAGIC_OFFSET = 0;
    private static final int PADDING_SIZE_OFFSET = 0 + MAGIC_HEADER.length;
    private static final int CHECKPOINT_OFFSET = PADDING_SIZE_OFFSET + 4;
    private static final int LINEAR_ORDERING_OFFSET = CHECKPOINT_OFFSET + 4;
    private static final int FIRST_RECORD_OFFSET;
    private static final int LOG_HEADER_BYTES;
    private static final int ENTRY_HEADER_SIZE = 8;
    private static final int PER_ENTRY_OVERHEAD = 8;
    private final Lock lock = new ReentrantLock();
    private final PersistenceHandle persistenceHandle;
    private final ByteBuffer buffer;
    private int effectivePaddingSize;
    private final int requestedPaddingSize;
    private boolean effectiveLinearOrdering;
    private final boolean requestedLinearOrdering;
    private final boolean alwaysCheckpoint;
    private final boolean authoritativeCheckpointOnReads;
    private int epoch = 0;

    @Deprecated(since="1.1")
    public AppendOnlyLogImpl(MappedByteBuffer byteBuffer, int offset, int length, boolean blockPadding, boolean linearOrdering) {
        this(byteBuffer, offset, length, new AppendOnlyLogImplConfig(blockPadding, linearOrdering, false, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppendOnlyLogImpl(MappedByteBuffer byteBuffer, int offset, int length, AppendOnlyLogImplConfig config) {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry with byteBuffer={0}, offset={1}, length={2}, config={3}", new Object[]{byteBuffer, offset, length, config});
        }
        this.lock.lock();
        try {
            this.requestedPaddingSize = config.isBlockPadding() ? 256 : 4;
            this.requestedLinearOrdering = config.isLinearOrdering();
            this.persistenceHandle = new PersistenceHandle(byteBuffer, offset, length);
            this.alwaysCheckpoint = config.isAlwaysCheckpoint();
            if (this.alwaysCheckpoint) {
                this.effectiveLinearOrdering = this.requestedLinearOrdering;
            }
            this.authoritativeCheckpointOnReads = config.isAuthoritativeCheckpointOnReads();
            MappedByteBuffer tmp = byteBuffer.slice();
            ((ByteBuffer)tmp).position(offset);
            ((ByteBuffer)tmp).limit(length);
            this.buffer = ((ByteBuffer)tmp).slice();
            byte[] header = new byte[MAGIC_HEADER.length];
            this.buffer.get(header);
            if (Arrays.equals(header, MAGIC_HEADER)) {
                this.effectivePaddingSize = this.buffer.getInt(PADDING_SIZE_OFFSET);
                this.effectiveLinearOrdering = this.buffer.getInt(LINEAR_ORDERING_OFFSET) == 1;
                this.recoverRecords();
            } else {
                this.effectivePaddingSize = this.requestedPaddingSize;
                this.effectiveLinearOrdering = this.requestedLinearOrdering;
                this.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit {0}", (Object)this);
        }
    }

    @Override
    public boolean isEffectivelyPadded() {
        return this.effectivePaddingSize == 256;
    }

    @Override
    public boolean isPaddingRequested() {
        return this.requestedPaddingSize == 256;
    }

    @Override
    public boolean isEffectiveLinearOrdering() {
        return this.effectiveLinearOrdering;
    }

    @Override
    public boolean isRequestedLinearOrdering() {
        return this.requestedLinearOrdering;
    }

    @Override
    public boolean isAlwaysCheckpoint() {
        return this.alwaysCheckpoint;
    }

    @Override
    public boolean isAuthoritativeCheckpointOnReads() {
        return this.authoritativeCheckpointOnReads;
    }

    @Override
    public void checkpoint() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            this.buffer.putInt(CHECKPOINT_OFFSET, this.buffer.position());
            this.persistenceHandle.persist(0, LOG_HEADER_BYTES);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    @Override
    public void put(byte[] src) {
        this.put(ByteBuffer.wrap(src));
    }

    @Override
    public int putWithLocation(byte[] src) {
        return this.putWithLocation(ByteBuffer.wrap(src));
    }

    @Override
    public boolean tryPut(byte[] src) {
        return this.tryPut(ByteBuffer.wrap(src));
    }

    @Override
    public int tryPutWithLocation(byte[] src) {
        return this.tryPutWithLocation(ByteBuffer.wrap(src));
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        this.put(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public int putWithLocation(byte[] src, int offset, int length) {
        return this.putWithLocation(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public boolean tryPut(byte[] src, int offset, int length) {
        return this.tryPut(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public int tryPutWithLocation(byte[] src, int offset, int length) {
        return this.tryPutWithLocation(ByteBuffer.wrap(src, offset, length));
    }

    @Override
    public void put(ByteBuffer src) {
        this.putWithLocation(src);
    }

    @Override
    public int putWithLocation(ByteBuffer src) {
        int location;
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with src={1}", (Object)this, (Object)src);
        }
        if ((location = this.tryPutWithLocation(src)) == -1) {
            BufferOverflowException bufferOverflowException = new BufferOverflowException();
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)bufferOverflowException, "throwing {0}", (Object)bufferOverflowException.toString());
            }
            throw bufferOverflowException;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)location);
        }
        return location;
    }

    @Override
    public boolean tryPut(ByteBuffer src) {
        return this.tryPutWithLocation(src) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tryPutWithLocation(ByteBuffer src) {
        int deferredRecordBytesLength;
        int recordBytesFittingInFirstCacheLine;
        ByteBuffer srcSlice;
        int payloadLength;
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with src={1}", (Object)this, (Object)src);
        }
        if ((payloadLength = (srcSlice = src.slice()).remaining()) == 0) {
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning {0}", (Object)-1);
            }
            return -1;
        }
        CRC32C crc32c = new CRC32C();
        crc32c.update(srcSlice);
        int checksum = (int)crc32c.getValue();
        srcSlice.rewind();
        int recordStartPosition = 0;
        int recordLength = 0;
        ByteBuffer payloadBuffer = null;
        ByteBuffer deferredSlice = null;
        this.lock.lock();
        try {
            if (!this.canAcceptInternal(payloadLength)) {
                if (logger.isTraceEnabled()) {
                    logger.tracev("exit returning {0}", (Object)-1);
                }
                int n = -1;
                return n;
            }
            recordStartPosition = this.buffer.position();
            this.buffer.putInt(payloadLength);
            this.buffer.putInt(checksum);
            int payloadStartPosition = this.buffer.position();
            payloadBuffer = this.buffer.slice(this.buffer.position(), payloadLength);
            this.buffer.position(this.buffer.position() + payloadLength);
            this.padRecord();
            recordLength = this.buffer.position() - recordStartPosition;
            int nonPayloadBytesInFirstCacheLine = payloadStartPosition % 64;
            int payloadCapacityInFistCacheLine = nonPayloadBytesInFirstCacheLine == 0 ? 0 : 64 - nonPayloadBytesInFirstCacheLine;
            recordBytesFittingInFirstCacheLine = 8 + payloadCapacityInFistCacheLine;
            deferredRecordBytesLength = recordLength - recordBytesFittingInFirstCacheLine;
            if (!this.effectiveLinearOrdering && payloadCapacityInFistCacheLine != 0 && payloadCapacityInFistCacheLine < payloadLength) {
                ByteBuffer immediateSlice = srcSlice.slice(0, payloadCapacityInFistCacheLine);
                deferredSlice = srcSlice.slice(payloadCapacityInFistCacheLine, payloadLength - payloadCapacityInFistCacheLine);
                payloadBuffer.put(immediateSlice);
                this.persistenceHandle.persist(recordStartPosition, 8 + payloadCapacityInFistCacheLine);
            } else {
                payloadBuffer.put(srcSlice);
                this.persistenceHandle.persist(recordStartPosition, recordLength);
            }
            src.position(src.position() + payloadLength);
            if (this.alwaysCheckpoint) {
                this.checkpoint();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (deferredSlice != null) {
            payloadBuffer.put(deferredSlice);
            this.persistenceHandle.persist(recordStartPosition + recordBytesFittingInFirstCacheLine, deferredRecordBytesLength);
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)recordStartPosition);
        }
        return recordStartPosition;
    }

    @Override
    public void clear() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            this.buffer.clear();
            this.buffer.put(0, MAGIC_HEADER);
            this.buffer.putInt(PADDING_SIZE_OFFSET, this.effectivePaddingSize);
            this.buffer.putInt(LINEAR_ORDERING_OFFSET, this.effectiveLinearOrdering ? 1 : 0);
            this.persistenceHandle.persist(0, LOG_HEADER_BYTES);
            this.buffer.clear();
            byte[] zeros = new byte[0x100000];
            while (this.buffer.remaining() > 0) {
                this.buffer.put(zeros, 0, this.buffer.remaining() > zeros.length ? zeros.length : this.buffer.remaining());
            }
            this.persistenceHandle.persist(0, this.buffer.capacity());
            this.effectivePaddingSize = this.requestedPaddingSize;
            this.effectiveLinearOrdering = this.requestedLinearOrdering;
            this.buffer.clear();
            this.buffer.put(0, MAGIC_HEADER);
            this.buffer.putInt(PADDING_SIZE_OFFSET, this.effectivePaddingSize);
            this.buffer.putInt(LINEAR_ORDERING_OFFSET, this.effectiveLinearOrdering ? 1 : 0);
            this.persistenceHandle.persist(0, LOG_HEADER_BYTES);
            this.buffer.position(FIRST_RECORD_OFFSET);
            ++this.epoch;
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    @Override
    public void reset() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            this.buffer.position(FIRST_RECORD_OFFSET);
            ++this.epoch;
            this.checkpoint();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    @Override
    public int remaining() {
        int result;
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            result = this.buffer.remaining();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    @Override
    public boolean canAccept(int length) {
        boolean result;
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with length={1}", (Object)this, (Object)length);
        }
        this.lock.lock();
        try {
            result = this.canAcceptInternal(length);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    private boolean canAcceptInternal(int length) {
        int recordLength = length + 8;
        int realignment = length % this.effectivePaddingSize;
        if (realignment != 0) {
            recordLength += this.effectivePaddingSize - realignment;
        }
        boolean result = this.buffer.remaining() - recordLength >= 0;
        return result;
    }

    private void padRecord() {
        int x = this.buffer.position() % this.effectivePaddingSize;
        if (x != 0) {
            this.buffer.position(this.buffer.position() + (this.effectivePaddingSize - x));
        }
    }

    private void recoverRecords() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        int checkpoint = this.buffer.getInt(CHECKPOINT_OFFSET);
        if (this.authoritativeCheckpointOnReads) {
            this.buffer.position(checkpoint);
        } else {
            Itr iter = new Itr(checkpoint != 0 ? checkpoint : FIRST_RECORD_OFFSET, false);
            while (iter.hasNext()) {
                iter.next();
            }
            this.buffer.position(iter.iterBuffer.position());
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    @Override
    public ByteBuffer readRecordAt(int location) {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with location={1}", (Object)this, (Object)location);
        }
        if (this.authoritativeCheckpointOnReads && location >= this.buffer.getInt(CHECKPOINT_OFFSET)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("record location " + location + " is beyond checkpoint " + this.buffer.getInt(CHECKPOINT_OFFSET));
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException.toString());
            }
            throw illegalArgumentException;
        }
        CRC32C crc32c = new CRC32C();
        ByteBuffer recordBuffer = this.buffer.duplicate();
        recordBuffer.position(location);
        if (recordBuffer.remaining() < 4) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid record location " + location);
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException.toString());
            }
            throw illegalArgumentException;
        }
        int length = recordBuffer.getInt();
        int expectedChecksum = recordBuffer.getInt();
        ByteBuffer dataBuffer = recordBuffer.slice();
        dataBuffer.limit(length);
        recordBuffer.position(recordBuffer.position() + length);
        crc32c.reset();
        crc32c.update(dataBuffer);
        int actualChecksum = (int)crc32c.getValue();
        dataBuffer.rewind();
        if (actualChecksum != expectedChecksum) {
            IllegalStateException illegalStateException = new IllegalStateException("invalid checksum");
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalStateException, "throwing {0}", (Object)illegalStateException.toString());
            }
            throw illegalStateException;
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)dataBuffer);
        }
        return dataBuffer;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        Itr result = new Itr(FIRST_RECORD_OFFSET, false);
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    @Override
    public Iterator<ByteBuffer> copyingIterator() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        Itr result = new Itr(FIRST_RECORD_OFFSET, true);
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    static {
        LOG_HEADER_BYTES = FIRST_RECORD_OFFSET = LINEAR_ORDERING_OFFSET + 4;
    }

    private class Itr
    implements Iterator<ByteBuffer> {
        private final ByteBuffer iterBuffer;
        private final int expectedEpoch;
        private final CRC32C crc32c = new CRC32C();
        private ByteBuffer lookahead;
        private int lookaheadPos = 0;
        private final boolean returnCopies;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Itr(int offset, boolean returnCopies) {
            if (logger.isTraceEnabled()) {
                logger.tracev("entry with offset={0}, returnCopies={1}", (Object)offset, (Object)returnCopies);
            }
            AppendOnlyLogImpl.this.lock.lock();
            try {
                this.iterBuffer = AppendOnlyLogImpl.this.buffer.duplicate();
                this.iterBuffer.position(offset);
                this.expectedEpoch = AppendOnlyLogImpl.this.epoch;
                this.returnCopies = returnCopies;
            }
            finally {
                AppendOnlyLogImpl.this.lock.unlock();
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("exit {0}", (Object)this);
            }
        }

        @Override
        public boolean hasNext() {
            if (logger.isTraceEnabled()) {
                logger.tracev("entry for {0}", (Object)this);
            }
            boolean result = false;
            AppendOnlyLogImpl.this.lock.lock();
            try {
                this.checkForReset();
                if (this.lookahead == null) {
                    this.lookahead();
                }
                result = this.lookahead != null;
            }
            finally {
                AppendOnlyLogImpl.this.lock.unlock();
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning {0}", (Object)result);
            }
            return result;
        }

        @Override
        public ByteBuffer next() {
            if (logger.isTraceEnabled()) {
                logger.tracev("entry for {0}", (Object)this);
            }
            ByteBuffer result = null;
            AppendOnlyLogImpl.this.lock.lock();
            try {
                this.checkForReset();
                if (!this.hasNext()) {
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    if (logger.isTraceEnabled()) {
                        logger.tracev((Throwable)noSuchElementException, "throwing {0}", (Object)noSuchElementException.toString());
                    }
                    throw noSuchElementException;
                }
                result = this.lookahead;
                this.iterBuffer.position(this.lookaheadPos);
                this.lookahead = null;
                this.lookaheadPos = 0;
                if (this.returnCopies) {
                    ByteBuffer view = result;
                    result = ByteBuffer.allocate(view.remaining());
                    result.put(view);
                    result.rewind();
                }
            }
            finally {
                AppendOnlyLogImpl.this.lock.unlock();
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("exit returning {0}", (Object)result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookahead() {
            if (logger.isTraceEnabled()) {
                logger.tracev("entry for {0}", (Object)this);
            }
            int originalPosition = this.iterBuffer.position();
            ByteBuffer byteBuffer = null;
            if (AppendOnlyLogImpl.this.authoritativeCheckpointOnReads && originalPosition >= AppendOnlyLogImpl.this.buffer.getInt(CHECKPOINT_OFFSET)) {
                return;
            }
            try {
                do {
                    if (this.iterBuffer.remaining() < 4) {
                        if (logger.isTraceEnabled()) {
                            logger.tracev("exit", new Object[0]);
                        }
                        return;
                    }
                    int length = this.iterBuffer.getInt();
                    if (length == 0) {
                        if (logger.isTraceEnabled()) {
                            logger.tracev("exit", new Object[0]);
                        }
                        return;
                    }
                    int expectedChecksum = this.iterBuffer.getInt();
                    byteBuffer = this.iterBuffer.slice();
                    byteBuffer.limit(length);
                    this.iterBuffer.position(this.iterBuffer.position() + length);
                    this.crc32c.reset();
                    this.crc32c.update(byteBuffer);
                    int actualChecksum = (int)this.crc32c.getValue();
                    byteBuffer.rewind();
                    int realignment = this.iterBuffer.position() % AppendOnlyLogImpl.this.effectivePaddingSize;
                    if (realignment != 0) {
                        this.iterBuffer.position(this.iterBuffer.position() + (AppendOnlyLogImpl.this.effectivePaddingSize - realignment));
                    }
                    if (actualChecksum == expectedChecksum) break;
                    if (!AppendOnlyLogImpl.this.isEffectiveLinearOrdering()) continue;
                    if (logger.isTraceEnabled()) {
                        logger.tracev("exit", new Object[0]);
                    }
                    return;
                } while (this.iterBuffer.hasRemaining());
                this.lookahead = byteBuffer.asReadOnlyBuffer();
                this.lookaheadPos = this.iterBuffer.position();
            }
            finally {
                this.iterBuffer.position(originalPosition);
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("exit", new Object[0]);
            }
        }

        private void checkForReset() {
            if (AppendOnlyLogImpl.this.epoch != this.expectedEpoch) {
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException("Log cleared after iterator creation");
                if (logger.isTraceEnabled()) {
                    logger.tracev((Throwable)concurrentModificationException, "throwing {0}", (Object)concurrentModificationException.toString());
                }
                throw concurrentModificationException;
            }
        }
    }
}

