/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

public class AppendOnlyLogImplConfig {
    private final boolean blockPadding;
    private final boolean linearOrdering;
    private final boolean alwaysCheckpoint;
    private final boolean authoritativeCheckpointOnReads;

    public AppendOnlyLogImplConfig(boolean blockPadding, boolean linearOrdering, boolean alwaysCheckpointWrites, boolean authoritativeCheckpointOnReads) {
        if (alwaysCheckpointWrites && !linearOrdering) {
            throw new IllegalArgumentException("linearOrdering must be true when alwaysCheckpoint is enabled");
        }
        this.blockPadding = blockPadding;
        this.linearOrdering = linearOrdering;
        this.alwaysCheckpoint = alwaysCheckpointWrites;
        this.authoritativeCheckpointOnReads = authoritativeCheckpointOnReads;
    }

    public boolean isBlockPadding() {
        return this.blockPadding;
    }

    public boolean isLinearOrdering() {
        return this.linearOrdering;
    }

    public boolean isAlwaysCheckpoint() {
        return this.alwaysCheckpoint;
    }

    public boolean isAuthoritativeCheckpointOnReads() {
        return this.authoritativeCheckpointOnReads;
    }

    public String toString() {
        return "AppendOnlyLogImplConfig{blockPadding=" + this.blockPadding + ", linearOrdering=" + this.linearOrdering + ", alwaysCheckpoint=" + this.alwaysCheckpoint + ", authoritativeCheckpointOnReads=" + this.authoritativeCheckpointOnReads + "}";
    }
}

