/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.MappedFileChannelMetadata;
import io.mashona.logwriting.PersistenceHandle;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdk.nio.mapmode.ExtendedMapMode;
import org.jboss.logging.Logger;
import sun.misc.Unsafe;

public class MappedFileChannel
extends FileChannel {
    private static final Logger logger = Logger.getLogger(MappedFileChannel.class);
    private static Unsafe unsafe;
    private final PersistenceHandle persistenceHandle;
    private final Lock lock = new ReentrantLock();
    private final File file;
    private final FileChannel fileChannel;
    private final ByteBuffer rawBuffer;
    private final ByteBuffer dataBuffer;
    private final MappedFileChannelMetadata metadata;
    private static String NOT_IMPLEMENTED;

    public static File getMetadataFile(File file) throws IOException {
        return new File(file.getCanonicalPath() + ".pmem");
    }

    public MappedFileChannel(File file, int length, boolean readSharedMetadata) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry with file={0}, length={1}, readSharedMetadata={2}", (Object)file, (Object)length, (Object)readSharedMetadata);
        }
        this.file = file;
        if (!file.exists() && MappedFileChannel.getMetadataFile(file).exists()) {
            if (logger.isDebugEnabled()) {
                logger.debugv("deleting orphan metadata for {0}", (Object)file.getAbsolutePath());
            }
            MappedFileChannel.getMetadataFile(file).delete();
        }
        this.fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE), new FileAttribute[0]);
        MappedByteBuffer tmpRawBuffer = this.fileChannel.map(ExtendedMapMode.READ_WRITE_SYNC, 0L, length);
        this.rawBuffer = tmpRawBuffer;
        this.persistenceHandle = new PersistenceHandle(tmpRawBuffer, 0, length);
        MappedByteBuffer tmp = tmpRawBuffer.slice();
        ((ByteBuffer)tmp).position(0);
        ((ByteBuffer)tmp).limit(length);
        this.dataBuffer = ((ByteBuffer)tmp).slice();
        this.metadata = new MappedFileChannelMetadata(MappedFileChannel.getMetadataFile(file), readSharedMetadata);
        this.dataBuffer.position(0);
        if (logger.isTraceEnabled()) {
            logger.tracev("exit {0}", (Object)this);
        }
    }

    public MappedFileChannel(File file, int length) throws IOException {
        this(file, length, false);
    }

    public void deleteMetadata() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        if (this.fileChannel.isOpen()) {
            IOException ioException = new IOException("Unable to delete metadata for an open channel");
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)ioException, "throwing {0}", (Object)ioException.toString());
            }
            throw ioException;
        }
        File metadata = MappedFileChannel.getMetadataFile(this.file);
        if (metadata.exists()) {
            metadata.delete();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with dst={1}", (Object)this, (Object)dst);
        }
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            int position = this.dataBuffer.position();
            int readLength = this.read(dst, position);
            if (readLength > 0) {
                this.dataBuffer.position(position + readLength);
            }
            result = readLength;
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with dst={1} and position={2}", (Object)this, (Object)dst, (Object)position);
        }
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            this.validatePosition(position);
            int length = this.metadata.getPersistenceIndex() - (int)position;
            if (length <= 0) {
                length = -1;
            }
            if ((length = Math.min(length, dst.remaining())) > 0) {
                ByteBuffer srcSlice = this.dataBuffer.slice((int)position, length);
                dst.put(srcSlice);
                result = srcSlice.position();
            } else {
                result = length;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with src={1}", (Object)this, (Object)src);
        }
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            result = this.writeInternal(src, this.dataBuffer.position());
            this.dataBuffer.position(this.dataBuffer.position() + result);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with src={1}, position={2}", (Object)this, (Object)src, (Object)position);
        }
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            this.validatePosition(position);
            result = this.writeInternal(src, (int)position);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    private int writeInternal(ByteBuffer src, int position) throws ClosedChannelException {
        if (this.metadata.isReadShared()) {
            IllegalStateException illegalStateException = new IllegalStateException("ReadShared views can not be used for writes");
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalStateException, "throwing {0}", (Object)illegalStateException.toString());
            }
            throw illegalStateException;
        }
        if (position < this.metadata.getPersistenceIndex()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Write position " + position + " is before tail position " + this.metadata.getPersistenceIndex() + " - can not overwrite existing data");
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException.toString());
            }
            throw illegalArgumentException;
        }
        int length = Math.min(this.dataBuffer.remaining(), src.remaining());
        ByteBuffer srcSlice = src.slice(src.position(), length);
        ByteBuffer dst = this.dataBuffer.slice(position, length);
        dst.put(srcSlice);
        src.position(src.position() + length);
        this.persist(position, length);
        return length;
    }

    private void persist(int startIndex, int length) throws ClosedChannelException {
        this.persistenceHandle.persist(startIndex, length);
        this.metadata.persist(startIndex, length);
    }

    @Override
    public long position() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        int result = 0;
        try {
            this.validateIsOpen();
            result = this.dataBuffer.position();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    @Override
    public FileChannel position(long newPosition) throws ClosedChannelException, IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with newPosition={1}", (Object)this, (Object)newPosition);
        }
        this.lock.lock();
        try {
            this.validateIsOpen();
            this.validatePosition(newPosition);
            this.dataBuffer.position((int)newPosition);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit {0}", (Object)this);
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        long result = 0L;
        try {
            this.validateIsOpen();
            result = this.dataBuffer.limit();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    public long getFileSize() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        long result = this.file.length();
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    public long getPersistedSize() throws ClosedChannelException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        long result = 0L;
        try {
            this.validateIsOpen();
            result = this.metadata.getPersistenceIndex();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)result);
        }
        return result;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    public void clear() throws ClosedChannelException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            this.metadata.clear();
            this.clearDataFromOffset(0);
            this.dataBuffer.position(0);
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    private void clearDataFromOffset(int offset) {
        this.dataBuffer.clear();
        this.dataBuffer.position(offset);
        byte[] zeros = new byte[0x100000];
        while (this.dataBuffer.remaining() > 0) {
            this.dataBuffer.put(zeros, 0, this.dataBuffer.remaining() > zeros.length ? zeros.length : this.dataBuffer.remaining());
        }
        this.persistenceHandle.persist(0, this.dataBuffer.capacity() - offset);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.lock.lock();
        try {
            unsafe.invokeCleaner(this.rawBuffer);
            if (!this.metadata.isReadShared()) {
                int persistenceIndex = this.metadata.getPersistenceIndex();
                if (logger.isDebugEnabled()) {
                    logger.debugv("truncating file={0} to length={1}", (Object)this.file.getAbsolutePath(), (Object)persistenceIndex);
                }
                this.fileChannel.truncate(persistenceIndex);
            }
            this.fileChannel.close();
            this.metadata.close();
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    private void validateIsOpen() throws ClosedChannelException {
        if (!this.fileChannel.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)closedChannelException, "throwing {0}", (Object)closedChannelException.toString());
            }
            throw closedChannelException;
        }
    }

    private void validatePosition(long position) throws IndexOutOfBoundsException {
        if (position > (long)this.dataBuffer.limit()) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("Position " + position + " exceeds limit " + this.dataBuffer.limit());
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)indexOutOfBoundsException, "throwing {0}", (Object)indexOutOfBoundsException.toString());
            }
            throw indexOutOfBoundsException;
        }
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public long write(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long position, long size) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NOT_IMPLEMENTED = "Method not implemented";
    }
}

