/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import java.nio.MappedByteBuffer;
import org.jboss.logging.Logger;

public class PersistenceHandle {
    private static final Logger logger = Logger.getLogger(PersistenceHandle.class);
    private final MappedByteBuffer buffer;
    private final int offset;
    private final int length;

    public PersistenceHandle(MappedByteBuffer buffer, int offset, int length) {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry with buffer={0}, offset={1}, length={2}", (Object)buffer, (Object)offset, (Object)length);
        }
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        if (logger.isTraceEnabled()) {
            logger.tracev("exit {0}", (Object)this);
        }
    }

    PersistenceHandle duplicate(int offset, int length) {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with offset={1}, length={2}", (Object)this, (Object)offset, (Object)length);
        }
        if (length > this.length) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Given length of " + length + " exceeds max of " + this.length);
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException.toString());
            }
            throw illegalArgumentException;
        }
        PersistenceHandle persistenceHandle = new PersistenceHandle(this.buffer, this.offset + offset, length);
        if (logger.isTraceEnabled()) {
            logger.tracev("exit returning {0}", (Object)persistenceHandle);
        }
        return persistenceHandle;
    }

    public void persist(int from, int length) {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0} with from={1}, length={2}", (Object)this, (Object)from, (Object)length);
        }
        if (length > this.length) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Given length of " + length + " exceeds max of " + this.length);
            if (logger.isTraceEnabled()) {
                logger.tracev((Throwable)illegalArgumentException, "throwing {0}", (Object)illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        this.buffer.force(from + this.offset, length);
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }

    public void persist() {
        if (logger.isTraceEnabled()) {
            logger.tracev("entry for {0}", (Object)this);
        }
        this.persist(0, this.length);
        if (logger.isTraceEnabled()) {
            logger.tracev("exit", new Object[0]);
        }
    }
}

