/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen.wsdl2java;

import io.mateo.cxf.codegen.wsdl2java.Wsdl2JavaOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.process.CommandLineArgumentProvider;

@CacheableTask
public abstract class Wsdl2Java
extends JavaExec {
    public Wsdl2Java() {
        this.getArgumentProviders().add(new Wsdl2JavaArgumentProvider());
    }

    @Nested
    public abstract Wsdl2JavaOptions getWsdl2JavaOptions();

    @Internal
    public abstract Property<Boolean> getAddToMainSourceSet();

    public void toolOptions(Action<? super Wsdl2JavaOptions> configurer) {
        configurer.execute((Object)this.getWsdl2JavaOptions());
    }

    private class Wsdl2JavaArgumentProvider
    implements CommandLineArgumentProvider {
        private Wsdl2JavaArgumentProvider() {
        }

        public Iterable<String> asArguments() {
            List mimeMethods;
            List bareMethods;
            boolean first;
            StringBuilder sb;
            List asyncMethods;
            Wsdl2JavaOptions options = Wsdl2Java.this.getWsdl2JavaOptions();
            if (!options.getWsdl().isPresent()) {
                throw new IllegalStateException("Cannot generate arguments for task '" + Wsdl2Java.this.getName() + "' because 'wsdl' has no value.");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            if (options.getEncoding().isPresent()) {
                arguments.add("-encoding");
                arguments.add((String)options.getEncoding().get());
            }
            if (options.getPackageNames().isPresent()) {
                ((List)options.getPackageNames().get()).forEach(value -> {
                    arguments.add("-p");
                    arguments.add((String)value);
                });
            }
            if (options.getNamespaceExcludes().isPresent()) {
                ((List)options.getNamespaceExcludes().get()).forEach(value -> {
                    arguments.add("-nexclude");
                    arguments.add((String)value);
                });
            }
            arguments.add("-d");
            String outputDir = ((File)options.getOutputDir().getAsFile().get()).getAbsolutePath();
            arguments.add(outputDir);
            if (options.getBindingFiles().isPresent()) {
                ((Set)options.getBindingFiles().get()).forEach(binding -> {
                    RegularFile bindingFile = Wsdl2Java.this.getProject().getLayout().getProjectDirectory().file(binding);
                    arguments.add("-b");
                    arguments.add(bindingFile.getAsFile().toPath().toAbsolutePath().toString());
                });
            }
            if (options.getFrontend().isPresent()) {
                arguments.add("-fe");
                arguments.add((String)options.getFrontend().get());
            }
            if (options.getDatabinding().isPresent()) {
                arguments.add("-db");
                arguments.add((String)options.getDatabinding().get());
            }
            if (options.getWsdlVersion().isPresent()) {
                arguments.add("-wv");
                arguments.add((String)options.getWsdlVersion().get());
            }
            if (options.getCatalog().isPresent()) {
                arguments.add("-catalog");
                arguments.add((String)options.getCatalog().get());
            }
            if (options.getExtendedSoapHeaders().isPresent() && Boolean.TRUE.equals(options.getExtendedSoapHeaders().get())) {
                arguments.add("-exsh");
                arguments.add("true");
            }
            if (options.getNoTypes().isPresent() && Boolean.TRUE.equals(options.getNoTypes().get())) {
                arguments.add("-noTypes");
            }
            if (options.getAllowElementRefs().isPresent() && Boolean.TRUE.equals(options.getAllowElementRefs().get())) {
                arguments.add("-allowElementReferences");
            }
            if (options.getValidateWsdl().isPresent()) {
                arguments.add("-validate=" + (String)options.getValidateWsdl().get());
            }
            if (options.getMarkGenerated().isPresent() && Boolean.TRUE.equals(options.getMarkGenerated().get())) {
                arguments.add("-mark-generated");
            }
            if (options.getSuppressGeneratedDate().isPresent() && Boolean.TRUE.equals(options.getSuppressGeneratedDate().get())) {
                arguments.add("-suppress-generated-date");
            }
            if (options.getDefaultExcludesNamespace().isPresent()) {
                arguments.add("-dex");
                arguments.add(((Boolean)options.getDefaultExcludesNamespace().get()).toString());
            }
            if (options.getDefaultNamespacePackageMapping().isPresent()) {
                arguments.add("-dns");
                arguments.add(((Boolean)options.getDefaultNamespacePackageMapping().get()).toString());
            }
            if (options.getServiceName().isPresent()) {
                arguments.add("-sn");
                arguments.add((String)options.getServiceName().get());
            }
            if (options.getFaultSerialVersionUid().isPresent()) {
                arguments.add("-faultSerialVersionUID");
                arguments.add((String)options.getFaultSerialVersionUid().get());
            }
            if (options.getExceptionSuper().isPresent()) {
                arguments.add("-exceptionSuper");
                arguments.add((String)options.getExceptionSuper().get());
            }
            if (options.getSeiSuper().isPresent()) {
                ((List)options.getSeiSuper().get()).forEach(value -> {
                    arguments.add("-seiSuper");
                    arguments.add((String)value);
                });
            }
            if (options.getAutoNameResolution().isPresent() && Boolean.TRUE.equals(options.getAutoNameResolution().get())) {
                arguments.add("-autoNameResolution");
            }
            if (options.getNoAddressBinding().isPresent() && Boolean.TRUE.equals(options.getNoAddressBinding().get())) {
                arguments.add("-noAddressBinding");
            }
            if (options.getXjcArgs().isPresent()) {
                ((List)options.getXjcArgs().get()).forEach(value -> arguments.add("-xjc" + value));
            }
            if (options.getExtraArgs().isPresent()) {
                arguments.addAll((Collection)options.getExtraArgs().get());
            }
            if (options.getWsdlLocation().isPresent()) {
                arguments.add("-wsdlLocation");
                arguments.add((String)options.getWsdlLocation().get());
            }
            if (options.getWsdlList().isPresent() && Boolean.TRUE.equals(options.getWsdlList().get())) {
                arguments.add("-wsdlList");
            }
            if (options.getVerbose().isPresent() && Boolean.TRUE.equals(options.getVerbose().get())) {
                arguments.add("-verbose");
            }
            if (options.getAsyncMethods().isPresent() && !(asyncMethods = (List)options.getAsyncMethods().get()).isEmpty()) {
                sb = new StringBuilder("-asyncMethods");
                sb.append("=");
                first = true;
                for (String value2 : asyncMethods) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(value2);
                    first = false;
                }
                arguments.add(sb.toString());
            }
            if (options.getBareMethods().isPresent() && !(bareMethods = (List)options.getBareMethods().get()).isEmpty()) {
                sb = new StringBuilder("-bareMethods");
                sb.append("=");
                first = true;
                for (String value2 : bareMethods) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(value2);
                    first = false;
                }
                arguments.add(sb.toString());
            }
            if (options.getMimeMethods().isPresent() && !(mimeMethods = (List)options.getMimeMethods().get()).isEmpty()) {
                sb = new StringBuilder("-mimeMethods");
                sb.append("=");
                first = true;
                for (String value2 : mimeMethods) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(value2);
                    first = false;
                }
                arguments.add(sb.toString());
            }
            arguments.add((String)options.getWsdl().get());
            return Collections.unmodifiableList(arguments);
        }
    }
}

