/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen.wsdl2js;

import java.util.Objects;
import java.util.StringJoiner;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class Wsdl2JsOptions {
    @Input
    public abstract Property<String> getWsdl();

    @Input
    @Optional
    public abstract Property<String> getWsdlVersion();

    @Input
    @Optional
    public abstract ListProperty<UriPrefixPair> getPackagePrefixes();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract RegularFileProperty getCatalog();

    @Input
    @Optional
    public abstract Property<String> getValidate();

    @Input
    @Optional
    public abstract Property<Boolean> getVerbose();

    @Input
    @Optional
    public abstract Property<Boolean> getQuiet();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getOutputDir();

    public static class UriPrefixPair {
        private String uri;
        private String prefix;

        public UriPrefixPair() {
        }

        public UriPrefixPair(String uri, String prefix) {
            this.uri = Objects.requireNonNull(uri, "'uri' must not be null for UriPrefixPair");
            this.prefix = Objects.requireNonNull(prefix, "'prefix' must not be null for UriPrefixPair");
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = Objects.requireNonNull(uri, "'uri' must not be null for UriPrefixPair");
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "'prefix' must not be null for UriPrefixPair");
        }

        public String toString() {
            return new StringJoiner(", ", UriPrefixPair.class.getSimpleName() + "[", "]").add("uri='" + this.uri + "'").add("prefix='" + this.prefix + "'").toString();
        }
    }
}

