/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application;

import com.opencsv.CSVWriter;
import io.mateu.core.application.usecases.CreateJourneyUseCase;
import io.mateu.core.application.usecases.FetchItemsUseCase;
import io.mateu.core.application.usecases.GetFileUrlUseCase;
import io.mateu.core.application.usecases.GetUiUseCase;
import io.mateu.core.application.usecases.HandleFileUploadUseCase;
import io.mateu.core.application.usecases.RunStepUseCase;
import io.mateu.core.application.usecases.ServeFileUseCase;
import io.mateu.core.application.usecases.fetchlist.FetchListUseCase;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.infra.csv.ByteArrayInOutStream;
import io.mateu.dtos.Items;
import io.mateu.dtos.JourneyCreationRq;
import io.mateu.dtos.Page;
import io.mateu.dtos.RunActionRq;
import io.mateu.dtos.StepWrapper;
import io.mateu.dtos.UI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class MateuService {
    private static final Logger log = LoggerFactory.getLogger(MateuService.class);
    private final GetUiUseCase getUiUseCase;
    private final CreateJourneyUseCase createJourneyUseCase;
    private final RunStepUseCase runStepUseCase;
    private final FetchListUseCase fetchListUseCase;
    private final FetchItemsUseCase fetchItemsUseCase;
    private final GetFileUrlUseCase getFileUrlUseCase;
    private final HandleFileUploadUseCase handleFileUploadUseCase;
    private final ServeFileUseCase serveFileUseCase;
    @Autowired
    Serializer serializer;

    public MateuService(GetUiUseCase getUiUseCase, CreateJourneyUseCase createJourneyUseCase, RunStepUseCase runStepUseCase, FetchListUseCase fetchListUseCase, FetchItemsUseCase fetchItemsUseCase, GetFileUrlUseCase getFileUrlUseCase, HandleFileUploadUseCase handleFileUploadUseCase, ServeFileUseCase serveFileUseCase) {
        this.getUiUseCase = getUiUseCase;
        this.createJourneyUseCase = createJourneyUseCase;
        this.runStepUseCase = runStepUseCase;
        this.fetchListUseCase = fetchListUseCase;
        this.fetchItemsUseCase = fetchItemsUseCase;
        this.getFileUrlUseCase = getFileUrlUseCase;
        this.handleFileUploadUseCase = handleFileUploadUseCase;
        this.serveFileUseCase = serveFileUseCase;
    }

    public Mono<UI> getUI(String uiId, ServerHttpRequest serverHttpRequest) throws Exception {
        return this.getUiUseCase.getUI(uiId, serverHttpRequest);
    }

    public Mono<StepWrapper> createJourney(String uiId, String journeyTypeId, String journeyId, JourneyCreationRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.createJourneyUseCase.createJourney(uiId, journeyTypeId, journeyId, rq, serverHttpRequest);
    }

    public Mono<StepWrapper> runStepAndReturn(String uiId, String journeyTypeId, String journeyId, String stepId, String actionId, RunActionRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.runStepUseCase.runStep(journeyTypeId, journeyId, stepId, actionId, rq, serverHttpRequest);
    }

    public Mono<Page> getListRows(String uiId, String journeyTypeId, String journeyId, String stepId, String listId, int page, int page_size, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.fetchListUseCase.fetchPage(uiId, journeyTypeId, journeyId, stepId, listId, page, page_size, filters, ordering, journey, serverHttpRequest).subscribeOn(Schedulers.boundedElastic());
    }

    public Mono<Items> getItems(String itemProviderId, int page, int page_size, String search_text) throws Throwable {
        return this.fetchItemsUseCase.getItems(itemProviderId, page, page_size, search_text);
    }

    public Mono<ResponseEntity<Resource>> serveFile(String fileId, String filename) throws AuthenticationException {
        return Mono.fromCallable(() -> this.serveFileUseCase.serveFile(fileId, filename)).subscribeOn(Schedulers.boundedElastic());
    }

    public Mono<String> getFileUrl(String fileId, String fileName) throws AuthenticationException {
        return Mono.fromCallable(() -> this.getFileUrlUseCase.getFileUrl(fileId, fileName)).subscribeOn(Schedulers.boundedElastic());
    }

    public Mono<Void> handleFileUpload(String fileId, Mono<FilePart> file) throws AuthenticationException, ExecutionException, InterruptedException, TimeoutException {
        return this.handleFileUploadUseCase.handleFileUpload(fileId, file).subscribeOn(Schedulers.boundedElastic());
    }

    public Mono<ByteArrayInputStream> generateCsv(String uiId, String journeyTypeId, String journeyId, String stepId, String listId, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.getListRows(uiId, journeyTypeId, journeyId, stepId, listId, 0, 500, filters, ordering, journey, serverHttpRequest).map(Page::content).map(list -> {
            try {
                ByteArrayInOutStream stream = new ByteArrayInOutStream();
                OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
                CSVWriter writer = new CSVWriter((Writer)streamWriter);
                writer.writeAll(list.stream().map(this::toMap).map(Map::values).map(a -> a.stream().map(o -> "" + o).collect(Collectors.toList())).map(l -> l.toArray(new String[0])).toList());
                streamWriter.flush();
                return stream.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private Map<String, Object> toMap(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        try {
            return this.serializer.toMap(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Map.of();
        }
    }

    public Mono<ByteArrayInputStream> generateExcel(String uiId, String journeyTypeId, String journeyId, String stepId, String listId, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.getListRows(uiId, journeyTypeId, journeyId, stepId, listId, 0, 500, filters, ordering, journey, serverHttpRequest).map(Page::content).map(list -> list.stream().map(this::toMap).map(Map::values).map(a -> a.stream().map(o -> "" + o).collect(Collectors.toList())).map(l -> l.toArray(new String[0])).toList()).map(list -> {
            try {
                XSSFWorkbook workbook = new XSSFWorkbook();
                Sheet sheet = workbook.createSheet("All");
                ByteArrayInOutStream stream = new ByteArrayInOutStream();
                OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
                CellStyle style = workbook.createCellStyle();
                style.setWrapText(true);
                for (int i = 0; i < list.size(); ++i) {
                    Row row = sheet.createRow(i + 1);
                    String[] data = (String[])list.get(i);
                    if (data == null) continue;
                    for (int col = 0; col < data.length; ++col) {
                        Cell cell = row.createCell(col);
                        cell.setCellValue((String)(data[col] != null ? data[col] : ""));
                        cell.setCellStyle(style);
                    }
                }
                workbook.write((OutputStream)stream);
                workbook.close();
                streamWriter.flush();
                return stream.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

