/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases;

import io.mateu.core.domain.commands.startJourney.StartJourneyCommand;
import io.mateu.core.domain.commands.startJourney.StartJourneyCommandHandler;
import io.mateu.dtos.JourneyCreationRq;
import io.mateu.dtos.StepWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CreateJourneyUseCase {
    private static final Logger log = LoggerFactory.getLogger(CreateJourneyUseCase.class);
    private final StartJourneyCommandHandler startJourneyCommandHandler;

    public CreateJourneyUseCase(StartJourneyCommandHandler startJourneyCommandHandler) {
        this.startJourneyCommandHandler = startJourneyCommandHandler;
    }

    public Mono<StepWrapper> createJourney(String uiId, String journeyTypeId, String journeyId, JourneyCreationRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.startJourneyCommandHandler.handle(StartJourneyCommand.builder().uiId(uiId).journeyId(journeyId).journeyTypeId(journeyTypeId).journeyCreationRq(rq).serverHttpRequest(serverHttpRequest).build());
    }
}

