/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases;

import io.mateu.core.domain.queries.getItemsCount.GetItemsCountQuery;
import io.mateu.core.domain.queries.getItemsCount.GetItemsCountQueryHandler;
import io.mateu.core.domain.queries.getItemsRows.GetItemsRowsQuery;
import io.mateu.core.domain.queries.getItemsRows.GetItemsRowsQueryHandler;
import io.mateu.dtos.Items;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class FetchItemsUseCase {
    private static final Logger log = LoggerFactory.getLogger(FetchItemsUseCase.class);
    private final GetItemsCountQueryHandler getItemsCountQueryHandler;
    private final GetItemsRowsQueryHandler getItemsRowsQueryHandler;

    public FetchItemsUseCase(GetItemsCountQueryHandler getItemsCountQueryHandler, GetItemsRowsQueryHandler getItemsRowsQueryHandler) {
        this.getItemsCountQueryHandler = getItemsCountQueryHandler;
        this.getItemsRowsQueryHandler = getItemsRowsQueryHandler;
    }

    public Mono<Items> getItems(String itemProviderId, int page, int page_size, String search_text) throws Throwable {
        return Mono.just((Object)new Items(this.getItemsRowsQueryHandler.run(GetItemsRowsQuery.builder().itemsProviderId(itemProviderId).page(page).pageSize(page_size).searchText(search_text).build()), (long)this.getItemsCountQueryHandler.run(GetItemsCountQuery.builder().itemsProviderId(itemProviderId).searchText(search_text).build()))).subscribeOn(Schedulers.boundedElastic());
    }
}

