/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases;

import io.mateu.core.domain.queries.getUI.GetUIQuery;
import io.mateu.core.domain.queries.getUI.GetUIQueryHandler;
import io.mateu.dtos.UI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class GetUiUseCase {
    private static final Logger log = LoggerFactory.getLogger(GetUiUseCase.class);
    private final GetUIQueryHandler getUIQueryHandler;

    public GetUiUseCase(GetUIQueryHandler getUIQueryHandler) {
        this.getUIQueryHandler = getUIQueryHandler;
    }

    public Mono<UI> getUI(String uiId, ServerHttpRequest serverHttpRequest) throws Exception {
        log.info("Get UI with id {}", (Object)uiId);
        return Mono.just((Object)this.getUIQueryHandler.run(GetUIQuery.builder().uiId(uiId).build(), serverHttpRequest));
    }
}

