/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases;

import io.mateu.core.domain.model.files.StorageService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.naming.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class HandleFileUploadUseCase {
    private static final Logger log = LoggerFactory.getLogger(HandleFileUploadUseCase.class);
    private final StorageService storageService;

    public HandleFileUploadUseCase(StorageService storageService) {
        this.storageService = storageService;
    }

    public Mono<Void> handleFileUpload(String fileId, Mono<FilePart> file) throws AuthenticationException, ExecutionException, InterruptedException, TimeoutException {
        return this.storageService.store(fileId, file);
    }
}

