/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases;

import io.mateu.core.domain.commands.runStepAction.RunStepActionCommand;
import io.mateu.core.domain.commands.runStepAction.RunStepActionCommandHandler;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.RunActionRq;
import io.mateu.dtos.Step;
import io.mateu.dtos.StepWrapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class RunStepUseCase {
    private static final Logger log = LoggerFactory.getLogger(RunStepUseCase.class);
    private final RunStepActionCommandHandler runStepActionCommandHandler;
    private final Serializer serializer;

    public RunStepUseCase(RunStepActionCommandHandler runStepActionCommandHandler, Serializer serializer) {
        this.runStepActionCommandHandler = runStepActionCommandHandler;
        this.serializer = serializer;
    }

    public Mono<StepWrapper> runStep(String journeyTypeId, String journeyId, String stepId, String actionId, RunActionRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        log.info("running action " + journeyTypeId + "/" + journeyId + "/" + stepId + "/" + actionId);
        JourneyContainer journeyContainer = this.serializer.fromJson(this.serializer.toJson(rq.getJourney()), JourneyContainer.class);
        return this.runStepActionCommandHandler.handle(RunStepActionCommand.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).stepId(stepId).actionId(actionId).data(rq.getData()).journeyContainer(journeyContainer).serverHttpRequest(serverHttpRequest).build()).thenReturn((Object)StepWrapper.builder().journey(journeyContainer.getJourney()).store(this.toMap(journeyContainer)).step((Step)journeyContainer.getSteps().get(journeyContainer.getJourney().getCurrentStepId())).build()).subscribeOn(Schedulers.boundedElastic());
    }

    private Map<String, Object> toMap(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        try {
            return this.serializer.toMap(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Map.of();
        }
    }
}

