/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases;

import io.mateu.core.domain.model.files.StorageService;
import javax.naming.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ServeFileUseCase {
    private static final Logger log = LoggerFactory.getLogger(ServeFileUseCase.class);
    private final StorageService storageService;

    public ServeFileUseCase(StorageService storageService) {
        this.storageService = storageService;
    }

    public ResponseEntity<Resource> serveFile(String fileId, String filename) throws AuthenticationException {
        Resource file = this.storageService.loadAsResource(fileId, filename);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }
}

