/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases.fetchlist;

import io.mateu.core.application.usecases.fetchlist.OrderingDeserializer;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.queries.getListCount.GetListCountQuery;
import io.mateu.core.domain.queries.getListCount.GetListCountQueryHandler;
import io.mateu.core.domain.queries.getListRows.GetListRowsQuery;
import io.mateu.core.domain.queries.getListRows.GetListRowsQueryHandler;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Page;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FetchListUseCase {
    private static final Logger log = LoggerFactory.getLogger(FetchListUseCase.class);
    private final Serializer serializer;
    private final GetListRowsQueryHandler getListRowsQueryHandler;
    private final GetListCountQueryHandler getListCountQueryHandler;

    public FetchListUseCase(Serializer serializer, GetListRowsQueryHandler getListRowsQueryHandler, GetListCountQueryHandler getListCountQueryHandler) {
        this.serializer = serializer;
        this.getListRowsQueryHandler = getListRowsQueryHandler;
        this.getListCountQueryHandler = getListCountQueryHandler;
    }

    public Mono<Page> fetchPage(String uiId, String journeyTypeId, String journeyId, String stepId, String listId, int page, int page_size, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        JourneyContainer journeyContainer = this.serializer.fromJson(this.serializer.toJson(journey), JourneyContainer.class);
        return this.getListRowsQueryHandler.run(GetListRowsQuery.builder().journeyContainer(journeyContainer).stepId(stepId).listId(listId).page(page).pageSize(page_size).filters(filters).ordering(new OrderingDeserializer(ordering).deserialize(this.serializer)).serverHttpRequest(serverHttpRequest).build()).collectList().zipWith((Mono)(page > 0 ? Mono.just((Object)-1L) : this.getListCountQueryHandler.run(GetListCountQuery.builder().journeyContainer(journeyContainer).stepId(stepId).listId(listId).filters(filters).serverHttpRequest(serverHttpRequest).build()))).map(tuple -> new Page((List)tuple.getT1(), ((Long)tuple.getT2()).longValue()));
    }
}

