/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.application.usecases.fetchlist;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.dtos.SortCriteria;
import io.mateu.dtos.SortType;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class OrderingDeserializer {
    private final String raw;

    public OrderingDeserializer(String raw) {
        this.raw = raw;
    }

    public List<SortCriteria> deserialize(Serializer serializer) {
        if (Strings.isNullOrEmpty((String)this.raw)) {
            return List.of();
        }
        try {
            List data = serializer.fromJson(new String(Base64.getDecoder().decode(this.raw)), ArrayList.class);
            return data.stream().map(m -> new SortCriteria((String)m.get("column"), SortType.valueOf((String)((String)m.get("order"))))).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return List.of();
        }
    }
}

