/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction;

import io.mateu.core.domain.model.files.FileChecker;
import io.mateu.core.domain.model.files.StorageService;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.uidefinition.shared.data.ExternalReference;
import jakarta.persistence.Entity;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActualValueExtractor {
    private static final Logger log = LoggerFactory.getLogger(ActualValueExtractor.class);
    final FileChecker fileChecker;
    final StorageService storageService;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;

    public Object getActualValue(Class targetType, Object value) throws Exception {
        Class<?> targetValue = value;
        if (value == null) {
            if (Integer.TYPE.equals(targetType)) {
                return 0;
            }
            if (Long.TYPE.equals(targetType)) {
                return 0L;
            }
            if (Float.TYPE.equals(targetType)) {
                return Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(targetType)) {
                return 0.0;
            }
            if (Boolean.TYPE.equals(targetType)) {
                return false;
            }
            return null;
        }
        if (!targetType.equals(value.getClass())) {
            if (Integer.TYPE.equals(targetType)) {
                targetValue = Integer.parseInt("" + value);
            } else if (Long.TYPE.equals(targetType)) {
                targetValue = Long.parseLong("" + value);
            } else if (Double.TYPE.equals(targetType)) {
                targetValue = Double.parseDouble("" + value);
            } else if (Float.TYPE.equals(targetType)) {
                targetValue = Float.valueOf(Float.parseFloat("" + value));
            } else if (Boolean.TYPE.equals(targetType)) {
                targetValue = Boolean.parseBoolean("" + value);
            } else if (Integer.class.equals((Object)targetType)) {
                targetValue = Integer.parseInt("" + value);
            } else if (Long.class.equals((Object)targetType)) {
                targetValue = Long.parseLong("" + value);
            } else if (Double.class.equals((Object)targetType)) {
                targetValue = Double.parseDouble("" + value);
            } else if (Float.class.equals((Object)targetType)) {
                targetValue = Float.valueOf(Float.parseFloat("" + value));
            } else if (Boolean.class.equals((Object)targetType)) {
                targetValue = Boolean.parseBoolean("" + value);
            } else if (LocalDate.class.equals((Object)targetType)) {
                targetValue = LocalDate.parse("" + value);
            } else if (LocalDateTime.class.equals((Object)targetType)) {
                targetValue = LocalDateTime.parse("" + value);
            } else if (LocalTime.class.equals((Object)targetType)) {
                targetValue = LocalTime.parse("" + value);
            } else if (targetType.isEnum()) {
                targetValue = Enum.valueOf(targetType, "" + value);
            } else if (Class.class.equals((Object)targetType)) {
                targetValue = Class.forName("" + value);
            }
        }
        return targetValue;
    }

    private boolean checkInjected(Object viewInstance, String fieldName) {
        Field field = this.reflectionHelper.getFieldByName(viewInstance.getClass(), fieldName);
        return field != null && (field.isAnnotationPresent(Autowired.class) || Modifier.isFinal(field.getModifiers()));
    }

    public Object getActualValue(Map.Entry<String, Object> entry, Object viewInstance) throws Exception {
        Object targetValue = entry.getValue();
        Field f = this.reflectionHelper.getFieldByName(viewInstance.getClass(), entry.getKey());
        if (f == null) {
            return targetValue;
        }
        if (this.checkInjected(viewInstance, f.getId())) {
            Object injectedValue = this.reflectionHelper.getValue(f, viewInstance);
            if (injectedValue != null && entry.getValue() != null && entry.getValue() instanceof Map) {
                Map incomingValues = (Map)entry.getValue();
                for (Field crudField : this.reflectionHelper.getAllEditableFields(injectedValue.getClass())) {
                    this.reflectionHelper.setValue(crudField, injectedValue, incomingValues.get(crudField.getId()));
                }
            }
            return injectedValue;
        }
        if (targetValue == null) {
            return targetValue;
        }
        if (entry.getValue() != null) {
            if (List.class.isAssignableFrom(f.getType())) {
                if (this.fileChecker.isFile(f)) {
                    ArrayList<Object> t = new ArrayList<Object>();
                    List files = (List)entry.getValue();
                    for (Map o : files) {
                        t.add(this.toFile(f, this.reflectionHelper.getGenericClass(f.getGenericType()), o));
                    }
                    return t;
                }
                if (ExternalReference.class.equals(this.reflectionHelper.getGenericClass(f.getGenericType()))) {
                    ArrayList<ExternalReference> t = new ArrayList<ExternalReference>();
                    List l = (List)entry.getValue();
                    for (Object o : l) {
                        if (o instanceof String) {
                            t.add(new ExternalReference(o, ""));
                            continue;
                        }
                        Map m2 = (Map)o;
                        t.add(new ExternalReference(m2.get("value"), (String)m2.get("key")));
                    }
                    return t;
                }
                if (Integer.class.equals(this.reflectionHelper.getGenericClass(f.getGenericType()))) {
                    ArrayList t = new ArrayList();
                    List l = (List)entry.getValue();
                    for (Object v2 : l) {
                        if (v2 instanceof String) {
                            v2 = Integer.parseInt((String)v2);
                        }
                        t.add(v2);
                    }
                    return t;
                }
                if (Double.class.equals(this.reflectionHelper.getGenericClass(f.getGenericType()))) {
                    ArrayList t = new ArrayList();
                    List l = (List)entry.getValue();
                    for (Object v3 : l) {
                        if (v3 instanceof String) {
                            v3 = Double.parseDouble((String)v3);
                        }
                        if (v3 instanceof Integer) {
                            v3 = ((Integer)v3).doubleValue();
                        }
                        t.add(v3);
                    }
                    return t;
                }
                if (f.getGenericClass().isEnum()) {
                    ArrayList value = new ArrayList();
                    List in = (List)entry.getValue();
                    in.stream().map(m -> {
                        try {
                            return Enum.valueOf(f.getGenericClass(), m);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }).filter(v -> v != null).forEach(v -> value.add(v));
                    return value;
                }
                if (URL.class.equals(f.getGenericClass())) {
                    ArrayList value = new ArrayList();
                    List in = (List)entry.getValue();
                    in.stream().map(m -> {
                        try {
                            return new URL((String)m);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }).filter(v -> v != null).forEach(v -> value.add(v));
                    return value;
                }
                if (!this.reflectionHelper.isBasic(f.getGenericClass())) {
                    ArrayList value = new ArrayList();
                    List in = (List)entry.getValue();
                    in.stream().map(m -> {
                        try {
                            return this.serializer.fromJson(this.serializer.toJson(m), f.getGenericClass());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }).filter(v -> v != null).forEach(v -> value.add(v));
                    return value;
                }
                return entry.getValue();
            }
            if (f.getType().isArray() && List.class.isAssignableFrom(entry.getValue().getClass())) {
                List l = (List)entry.getValue();
                if (boolean[].class.equals(f.getType())) {
                    boolean[] t = new boolean[l.size()];
                    for (int i = 0; i < l.size(); ++i) {
                        Object v4 = l.get(i);
                        boolean tv = false;
                        if (v4 instanceof Boolean) {
                            tv = (Boolean)v4;
                        }
                        t[i] = tv;
                    }
                    return t;
                }
                if (int[].class.equals(f.getType())) {
                    int[] t = new int[l.size()];
                    for (int i = 0; i < l.size(); ++i) {
                        Object v5 = l.get(i);
                        int tv = 0;
                        if (v5 instanceof Integer) {
                            tv = (Integer)v5;
                        } else if (v5 instanceof String) {
                            tv = Integer.parseInt((String)v5);
                        }
                        t[i] = tv;
                    }
                    return t;
                }
                if (double[].class.equals(f.getType())) {
                    double[] t = new double[l.size()];
                    for (int i = 0; i < l.size(); ++i) {
                        Object v6 = l.get(i);
                        double tv = 0.0;
                        if (v6 instanceof Double) {
                            tv = (Double)v6;
                        }
                        if (v6 instanceof Integer) {
                            tv = ((Integer)v6).doubleValue();
                        }
                        t[i] = tv;
                    }
                    return t;
                }
                if (String[].class.equals(f.getType())) {
                    return l.toArray(new String[0]);
                }
                if (ExternalReference[].class.equals(f.getType())) {
                    ArrayList<ExternalReference> t = new ArrayList<ExternalReference>();
                    for (int i = 0; i < l.size(); ++i) {
                        Map v7 = (Map)l.get(i);
                        t.add(new ExternalReference(v7.get("value"), (String)v7.get("key")));
                    }
                    return t.toArray(new ExternalReference[0]);
                }
                if (f.getType().getComponentType().isEnum()) {
                    ArrayList t = new ArrayList();
                    for (int i = 0; i < l.size(); ++i) {
                        Object v8 = l.get(i);
                        t.add(Enum.valueOf(f.getType().getComponentType(), (String)v8));
                    }
                    return t.toArray((Object[])Array.newInstance(f.getType().getComponentType(), 0));
                }
            }
            if (!f.getType().isAssignableFrom(entry.getValue().getClass())) {
                if (this.fileChecker.isFile(f)) {
                    value = this.extractFirstMap(entry.getValue());
                    if (value == null) {
                        targetValue = null;
                    } else {
                        Class<?> genericType = f.getType();
                        targetValue = this.toFile(f, genericType, value);
                    }
                } else if (ExternalReference.class.isAssignableFrom(f.getType())) {
                    value = (Map)entry.getValue();
                    targetValue = new ExternalReference(value.get("value"), (String)value.get("key"));
                } else if (entry.getValue() instanceof String) {
                    targetValue = this.getActualValue(f.getType(), entry.getValue());
                } else if (entry.getValue() instanceof Map) {
                    if (f.getType().isAnnotationPresent(Entity.class)) {
                        targetValue = this.reflectionHelper.newInstance(f.getType());
                        Object id = ((Map)entry.getValue()).get("value");
                        this.reflectionHelper.setValue(this.reflectionHelper.getIdField(f.getType()), targetValue, id);
                    } else {
                        targetValue = this.serializer.fromMap((Map)entry.getValue(), f.getType());
                    }
                }
            }
        }
        return targetValue;
    }

    private Map<String, Object> extractFirstMap(Object value) {
        if (Map.class.isAssignableFrom(value.getClass())) {
            return (Map)value;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List list = (List)value;
            return list.size() > 0 ? (Map)list.get(0) : null;
        }
        return null;
    }

    private Object toFile(Field f, Class<?> genericType, Map<String, Object> value) {
        Object targetValue = null;
        if (String.class.equals(genericType)) {
            try {
                targetValue = this.storageService.getUrl((String)value.get("id"), (String)value.get("name"));
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
        } else if (File.class.equals(genericType)) {
            try {
                targetValue = this.storageService.loadAsResource((String)value.get("id"), (String)value.get("name")).getFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
        } else {
            log.warn("field " + f.getName() + " from " + f.getDeclaringClass().getName() + " is not valid for a file type");
        }
        return targetValue;
    }

    public ActualValueExtractor(FileChecker fileChecker, StorageService storageService, ReflectionHelper reflectionHelper, Serializer serializer) {
        this.fileChecker = fileChecker;
        this.storageService = storageService;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
    }
}

