/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction;

import com.google.common.base.Strings;
import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.commands.runStepAction.RunStepActionCommand;
import io.mateu.core.domain.model.inbound.editors.EntityEditor;
import io.mateu.core.domain.model.inbound.editors.FieldEditor;
import io.mateu.core.domain.model.inbound.editors.ObjectEditor;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.ViewMapper;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.dtos.Form;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Step;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class RunStepActionCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(RunStepActionCommandHandler.class);
    final List<ActionRunner> actionRunners;
    final ActualValueExtractor actualValueExtractor;
    final ReflectionHelper reflectionHelper;
    final ViewMapper viewMapper;

    @Transactional
    public Mono<Void> handle(RunStepActionCommand command) throws Throwable {
        String journeyId = command.getJourneyId();
        String stepId = command.getStepId();
        String actionId = command.getActionId();
        Map<String, Object> data = command.getData();
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        JourneyContainer journeyContainer = command.getJourneyContainer();
        ServerHttpRequest serverHttpRequest = command.getServerHttpRequest();
        data = this.nestPartialFormData(data);
        if ("xxxbacktostep".equals(actionId)) {
            journeyContainer.getJourney().setCurrentStepId(stepId);
            journeyContainer.getJourney().setCurrentStepDefinitionId("xxx");
            this.resetMessages(journeyContainer);
            return Mono.empty().then();
        }
        Object viewInstance = this.getViewInstance(journeyId, stepId, journeyContainer, serverHttpRequest);
        if (!(viewInstance instanceof FieldEditor || viewInstance instanceof ObjectEditor || viewInstance instanceof EntityEditor)) {
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, viewInstance);
                    this.reflectionHelper.setValue((String)entry.getKey(), viewInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
        }
        Step step = (Step)journeyContainer.getSteps().get(stepId);
        step.mergeData(data);
        this.viewMapper.unnestPartialFormData(step.getData(), viewInstance);
        String componentId = "component-0";
        if (actionId.contains("___")) {
            componentId = actionId.substring(0, actionId.indexOf("___"));
            actionId = actionId.substring(actionId.indexOf("___") + "___".length());
        }
        if (!"component-0".equals(componentId)) {
            // empty if block
        }
        for (ActionRunner actionRunner : this.actionRunners) {
            if (!actionRunner.applies(journeyContainer, viewInstance, actionId)) continue;
            return actionRunner.run(journeyContainer, viewInstance, stepId, actionId, data, serverHttpRequest).then(Mono.deferContextual(contextView -> {
                String activeTabId = (String)command.getData().get("__activeTabId");
                try {
                    Step stepAfterRun = (Step)journeyContainer.getSteps().get(stepId);
                    stepAfterRun.getView().getMain().getComponents().stream().map(c -> c.getMetadata()).filter(m -> m instanceof Form).map(m -> (Form)m).flatMap(f -> f.getTabs().stream()).forEach(t -> t.setActive(!Strings.isNullOrEmpty((String)activeTabId) && activeTabId.equals(t.getId())));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return Mono.empty();
            }));
        }
        throw new Exception("Unknown action " + actionId);
    }

    private void resetMessages(JourneyContainer journeyContainer) {
        String currentStepId = journeyContainer.getJourney().getCurrentStepId();
        Step step = (Step)journeyContainer.getSteps().get(currentStepId);
        step.getView().setMessages(List.of());
    }

    private Map<String, Object> nestPartialFormData(Map<String, Object> data) {
        HashMap<String, Object> nestedData = new HashMap<String, Object>();
        data.keySet().stream().filter(k -> !k.startsWith("__nestedData__")).forEach(k -> nestedData.put((String)k, data.get(k)));
        data.keySet().stream().filter(k -> k.startsWith("__nestedData__")).forEach(k -> {
            String[] tokens = k.split("__");
            if (tokens.length >= 4) {
                String sectionId = tokens[2];
                String fieldId = tokens[3];
                if (!Strings.isNullOrEmpty((String)sectionId) && !Strings.isNullOrEmpty((String)fieldId)) {
                    HashMap nestedMap = (HashMap)nestedData.get(sectionId);
                    if (nestedMap == null) {
                        nestedMap = new HashMap();
                        nestedData.put(sectionId, nestedMap);
                    }
                    nestedMap.put(fieldId, data.get(k));
                }
            }
        });
        return nestedData;
    }

    public Object getViewInstance(String journeyId, String stepId, JourneyContainer journeyContainer, ServerHttpRequest serverHttpRequest) throws Exception {
        Step step = (Step)journeyContainer.getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " for journey with id " + journeyId + " found");
        }
        Object viewInstance = this.reflectionHelper.newInstance(Class.forName(step.getType()));
        Map data = step.getData();
        if (viewInstance instanceof EntityEditor) {
            ((EntityEditor)viewInstance).setEntityClass(Class.forName((String)data.get("__entityClassName__")));
            ((EntityEditor)viewInstance).setData(data);
        } else if (viewInstance instanceof ObjectEditor) {
            ((ObjectEditor)viewInstance).setType(Class.forName((String)data.get("__entityClassName__")));
            ((ObjectEditor)viewInstance).setData(data);
        } else if (viewInstance instanceof FieldEditor) {
            ((FieldEditor)viewInstance).setType(Class.forName((String)data.get("__type__")));
            ((FieldEditor)viewInstance).setFieldId((String)data.get("__fieldId__"));
            ((FieldEditor)viewInstance).setInitialStep((String)data.get("__initialStep__"));
            ((FieldEditor)viewInstance).setData(data);
        } else {
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, viewInstance);
                    this.reflectionHelper.setValue((String)entry.getKey(), viewInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
        }
        return viewInstance;
    }

    public RunStepActionCommandHandler(List<ActionRunner> actionRunners, ActualValueExtractor actualValueExtractor, ReflectionHelper reflectionHelper, ViewMapper viewMapper) {
        this.actionRunners = actionRunners;
        this.actualValueExtractor = actualValueExtractor;
        this.reflectionHelper = reflectionHelper;
        this.viewMapper = viewMapper;
    }
}

