/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.dtos.Action;
import io.mateu.dtos.ActionType;
import io.mateu.dtos.Component;
import io.mateu.dtos.Form;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Section;
import io.mateu.dtos.Step;
import io.mateu.dtos.ViewMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CancelPartialFormActionRunner
implements ActionRunner {
    public static final String CANCEL_PARTIAL_FORM_IDENTIFIER = "cancelPartialForm__";
    public static final String EDIT_PARTIAL_FORM_IDENTIFIER = "editPartialForm__";
    final JourneyContainerService store;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return actionId.startsWith(CANCEL_PARTIAL_FORM_IDENTIFIER);
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        String sectionId = this.getSectionIdFromActionId(actionId);
        Step step = this.store.getStep(journeyContainer, stepId);
        ViewMetadata metadata = ((Component)step.getView().getMain().getComponents().get(0)).getMetadata();
        List sections = ((Form)metadata).getSections();
        ArrayList<Object> actions = new ArrayList<Object>();
        this.updatedSectionToReadOnly(sectionId, sections, actions);
        this.restoreOldData(step, sectionId);
        this.store.updateStep(journeyContainer, stepId, step);
        return Mono.empty();
    }

    private void updatedSectionToReadOnly(String sectionId, List<Section> sections, ArrayList<Object> actions) {
        Action actionEdit = Action.builder().id(EDIT_PARTIAL_FORM_IDENTIFIER + sectionId).caption("Edit").type(ActionType.Secondary).validationRequired(false).visible(true).build();
        actions.add(actionEdit);
        for (Section section : sections) {
            if (!section.getId().equals(sectionId) || section.isReadOnly()) continue;
            section.setReadOnly(true);
            section.setActions(List.of(actionEdit));
        }
    }

    private void restoreOldData(Step step, String sectionId) {
        Map data = step.getData();
        Map oldData = (Map)data.get("__partialFormDataReminder__" + sectionId);
        data.putAll(oldData);
    }

    private String getSectionIdFromActionId(String actionId) {
        return actionId.replace(CANCEL_PARTIAL_FORM_IDENTIFIER, "");
    }

    public CancelPartialFormActionRunner(JourneyContainerService store) {
        this.store = store;
    }
}

