/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import com.google.common.base.Strings;
import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.interfaces.PartialForm;
import io.mateu.dtos.Action;
import io.mateu.dtos.ActionType;
import io.mateu.dtos.Component;
import io.mateu.dtos.ConfirmationTexts;
import io.mateu.dtos.Form;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Section;
import io.mateu.dtos.Step;
import io.mateu.dtos.ViewMetadata;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class EditPartialFormActionRunner
implements ActionRunner {
    public static final String EDIT_PARTIAL_FORM_IDENTIFIER = "editPartialForm__";
    public static final String CANCEL_PARTIAL_FORM_IDENTIFIER = "cancelPartialForm__";
    public static final String SAVE_PARTIAL_FORM_IDENTIFIER = "savePartialForm__";
    final JourneyContainerService store;
    final ReflectionHelper reflectionHelper;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return actionId.startsWith(EDIT_PARTIAL_FORM_IDENTIFIER);
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        String sectionId = this.getSectionIdFromActionId(actionId);
        Step step = this.store.getStep(journeyContainer, stepId);
        ViewMetadata metadata = ((Component)step.getView().getMain().getComponents().get(0)).getMetadata();
        List sections = ((Form)metadata).getSections();
        ArrayList<Object> actions = new ArrayList<Object>();
        Action actionCancel = Action.builder().id(CANCEL_PARTIAL_FORM_IDENTIFIER + sectionId).caption("Discard").type(ActionType.Secondary).validationRequired(false).visible(true).build();
        actions.add(actionCancel);
        PartialForm partialForm = this.getOrInitializeIfNotPresent(viewInstance, sectionId);
        this.updatedSectionToReadOnlyFalse(sectionId, sections, actions, actionCancel, partialForm);
        this.storeDataReminder(step, sectionId);
        this.store.updateStep(journeyContainer, stepId, step);
        return Mono.empty();
    }

    private PartialForm getOrInitializeIfNotPresent(Object viewInstance, String sectionId) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Field partialFormField = this.reflectionHelper.getFieldByName(viewInstance.getClass(), sectionId);
        PartialForm partialForm = (PartialForm)this.reflectionHelper.getValue(partialFormField, viewInstance);
        if (partialForm == null) {
            partialForm = (PartialForm)this.reflectionHelper.newInstance(partialFormField.getType());
            this.reflectionHelper.setValue(partialFormField, viewInstance, (Object)partialForm);
        }
        return partialForm;
    }

    private void updatedSectionToReadOnlyFalse(String sectionId, List<Section> sections, ArrayList<Object> actions, Action actionCancel, PartialForm partialForm) {
        Action actionSave = Action.builder().id(SAVE_PARTIAL_FORM_IDENTIFIER + sectionId).caption("Save").type(ActionType.Primary).confirmationRequired(!Strings.isNullOrEmpty((String)partialForm.confirmationMessage())).confirmationTexts(ConfirmationTexts.builder().title(partialForm.confirmationTitle()).message(partialForm.confirmationMessage()).action("Save").build()).validationRequired(true).visible(true).build();
        actions.add(actionSave);
        for (Section section : sections) {
            if (!section.getId().equals(sectionId)) continue;
            section.setReadOnly(false);
            section.setActions(List.of(actionCancel, actionSave));
        }
    }

    private void storeDataReminder(Step step, String sectionId) {
        Map data = step.getData();
        HashMap currentData = new HashMap();
        data.keySet().stream().filter(k -> k.startsWith("__nestedData__" + sectionId + "__")).forEach(k -> currentData.put(k, data.get(k)));
        data.put("__partialFormDataReminder__" + sectionId, currentData);
    }

    private String getSectionIdFromActionId(String actionId) {
        return actionId.replace(EDIT_PARTIAL_FORM_IDENTIFIER, "");
    }

    public EditPartialFormActionRunner(JourneyContainerService store, ReflectionHelper reflectionHelper) {
        this.store = store;
        this.reflectionHelper = reflectionHelper;
    }
}

