/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.inbound.editors.FieldEditor;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.dtos.JourneyContainer;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FieldEditorActionRunner
implements ActionRunner {
    final JourneyContainerService store;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return actionId.startsWith("__editfield__");
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        if (viewInstance instanceof FieldEditor) {
            this.store.setStep(journeyContainer, actionId, viewInstance, serverHttpRequest);
            return Mono.empty();
        }
        String fieldId = actionId.substring("__editfield__".length());
        Field field = this.reflectionHelper.getFieldByName(viewInstance.getClass(), fieldId);
        Object targetValue = this.reflectionHelper.getValue(field, viewInstance);
        if (targetValue == null) {
            targetValue = this.reflectionHelper.newInstance(field.getType());
        }
        this.store.setStep(journeyContainer, actionId, new FieldEditor(targetValue, fieldId, this.store.getCurrentStep(journeyContainer).getId(), this.serializer), serverHttpRequest);
        return Mono.empty();
    }

    public FieldEditorActionRunner(JourneyContainerService store, ReflectionHelper reflectionHelper, Serializer serializer) {
        this.store = store;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
    }
}

