/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.ValidationService;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.inbound.editors.FieldEditor;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Step;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FieldEditorSaveActionRunner
implements ActionRunner {
    final JourneyContainerService store;
    final Serializer serializer;
    final ValidationService validationService;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return viewInstance instanceof FieldEditor && "save".equals(actionId);
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        FieldEditor fieldEditor = (FieldEditor)viewInstance;
        Step initialStep = this.store.readStep(journeyContainer, fieldEditor.getInitialStep());
        Object object = this.serializer.fromJson(this.serializer.toJson(data), fieldEditor.getType());
        this.validationService.validate(object);
        data = this.serializer.toMap(object);
        data.put("__toString", "" + object);
        initialStep.getData().put(fieldEditor.getFieldId(), data);
        this.store.backToStep(journeyContainer, initialStep.getId());
        return Mono.empty();
    }

    public FieldEditorSaveActionRunner(JourneyContainerService store, Serializer serializer, ValidationService validationService) {
        this.store = store;
        this.serializer = serializer;
        this.validationService = validationService;
    }
}

