/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.AbstractActionRunner;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.inbound.editors.MethodParametersEditor;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.uidefinition.shared.data.Result;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Step;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MethodParametersEditorRunActionRunner
extends AbstractActionRunner
implements ActionRunner {
    final JourneyContainerService store;
    private final ActualValueExtractor actualValueExtractor;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return viewInstance instanceof MethodParametersEditor && "run".equals(actionId);
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        MethodParametersEditor methodParametersEditor = (MethodParametersEditor)viewInstance;
        Step initialStep = this.store.readStep(journeyContainer, methodParametersEditor.getInitialStep());
        Method m = this.reflectionHelper.getMethod(methodParametersEditor.getType(), methodParametersEditor.getMethodId());
        Object object = Modifier.isStatic(m.getModifiers()) ? null : this.serializer.fromMap(methodParametersEditor.getData(), methodParametersEditor.getType());
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < m.getParameterCount(); ++i) {
            if (ServerHttpRequest.class.equals(m.getParameterTypes()[i])) {
                values.add(serverHttpRequest);
                continue;
            }
            values.add(this.actualValueExtractor.getActualValue(m.getParameterTypes()[i], data.get("param_" + i)));
        }
        Object result = m.invoke(object, values.toArray());
        if (object != null) {
            this.store.updateStep(journeyContainer, initialStep.getId(), object, serverHttpRequest);
        }
        Object whatToShow = result;
        if (!Void.TYPE.equals(m.getReturnType())) {
            if (whatToShow instanceof Result) {
                this.addBackDestination((Result)whatToShow, this.store.getInitialStep(journeyContainer));
            }
            String newStepId = "result_" + UUID.randomUUID().toString();
            this.store.setStep(journeyContainer, newStepId, whatToShow, serverHttpRequest);
        } else {
            this.store.backToStep(journeyContainer, initialStep.getId());
        }
        return Mono.empty();
    }

    public MethodParametersEditorRunActionRunner(JourneyContainerService store, ActualValueExtractor actualValueExtractor, ReflectionHelper reflectionHelper, Serializer serializer) {
        this.store = store;
        this.actualValueExtractor = actualValueExtractor;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
    }
}

