/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.ValidationService;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.inbound.editors.ObjectEditor;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.uidefinition.core.interfaces.PersistentPojo;
import io.mateu.core.domain.uidefinition.shared.data.Destination;
import io.mateu.core.domain.uidefinition.shared.data.DestinationType;
import io.mateu.core.domain.uidefinition.shared.data.Result;
import io.mateu.core.domain.uidefinition.shared.data.ResultType;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Step;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ObjectEditorSaveActionRunner
implements ActionRunner {
    final JourneyContainerService store;
    final ActualValueExtractor actualValueExtractor;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;
    final ValidationService validationService;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return viewInstance instanceof ObjectEditor && "save".equals(actionId);
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        ObjectEditor objectEditor = (ObjectEditor)viewInstance;
        Object pojo = this.getActualInstance(objectEditor, data);
        this.validationService.validate(pojo);
        if (pojo instanceof PersistentPojo) {
            ((PersistentPojo)pojo).save();
        }
        data.remove("__entityClassName__");
        objectEditor.setData(data);
        this.store.setStep(journeyContainer, stepId, objectEditor, serverHttpRequest);
        Step initialStep = this.store.getInitialStep(journeyContainer);
        Result whatToShow = new Result(ResultType.Success, viewInstance.toString() + " has been saved", List.of(), new Destination(DestinationType.ActionId, "Back to " + initialStep.getName(), initialStep.getId()), null);
        String newStepId = "result_" + UUID.randomUUID().toString();
        this.store.setStep(journeyContainer, newStepId, whatToShow, serverHttpRequest);
        return Mono.empty();
    }

    private Object getActualInstance(ObjectEditor objectEditor, Map<String, Object> data) {
        try {
            Object object = this.reflectionHelper.newInstance(objectEditor.getType());
            Object filled = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
            this.reflectionHelper.copy(filled, object);
            Object actualInstance = object;
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, actualInstance);
                    this.reflectionHelper.setValue((String)entry.getKey(), actualInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
            return actualInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ObjectEditorSaveActionRunner(JourneyContainerService store, ActualValueExtractor actualValueExtractor, ReflectionHelper reflectionHelper, Serializer serializer, ValidationService validationService) {
        this.store = store;
        this.actualValueExtractor = actualValueExtractor;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
        this.validationService = validationService;
    }
}

