/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.ValidationService;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.uidefinition.core.interfaces.PersistentPojo;
import io.mateu.core.domain.uidefinition.core.interfaces.ReadOnlyPojo;
import io.mateu.core.domain.uidefinition.shared.data.Destination;
import io.mateu.core.domain.uidefinition.shared.data.DestinationType;
import io.mateu.core.domain.uidefinition.shared.data.Result;
import io.mateu.core.domain.uidefinition.shared.data.ResultType;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Step;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class PersistentPojoSaveActionRunner
implements ActionRunner {
    final JourneyContainerService store;
    final ValidationService validationService;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        return viewInstance instanceof PersistentPojo && "save".equals(actionId);
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        this.validationService.validate(viewInstance);
        ((PersistentPojo)viewInstance).save();
        this.refreshDetailView(journeyContainer, stepId, serverHttpRequest);
        Step initialStep = this.store.getInitialStep(journeyContainer);
        Step currentStep = this.store.readStep(journeyContainer, stepId);
        ArrayList<Destination> youMayBeInterestedIn = new ArrayList<Destination>();
        Step detail = this.store.readStep(journeyContainer, currentStep.getPreviousStepId());
        if (detail != null) {
            youMayBeInterestedIn.add(new Destination(DestinationType.ActionId, "Return to " + detail.getName() + " detail", detail.getId()));
        }
        Result whatToShow = new Result(ResultType.Success, viewInstance.toString() + " has been saved", youMayBeInterestedIn, new Destination(DestinationType.ActionId, "Return to " + initialStep.getName(), initialStep.getId()), null);
        String newStepId = "result_" + UUID.randomUUID().toString();
        this.store.setStep(journeyContainer, newStepId, whatToShow, serverHttpRequest);
        return Mono.empty();
    }

    private void refreshDetailView(JourneyContainer journeyContainer, String stepId, ServerHttpRequest serverHttpRequest) throws Throwable {
        Object detailView;
        if ("list_view_edit".equals(stepId) && (detailView = this.store.getViewInstance(journeyContainer, "list_view", serverHttpRequest)) instanceof ReadOnlyPojo) {
            ((ReadOnlyPojo)detailView).load(((ReadOnlyPojo)detailView).retrieveId());
            this.store.updateStep(journeyContainer, "list_view", detailView, serverHttpRequest);
        }
    }

    public PersistentPojoSaveActionRunner(JourneyContainerService store, ValidationService validationService) {
        this.store = store;
        this.validationService = validationService;
    }
}

