/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.AbstractActionRunner;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.ValidationService;
import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.inbound.editors.EntityEditor;
import io.mateu.core.domain.model.inbound.editors.MethodParametersEditor;
import io.mateu.core.domain.model.inbound.editors.ObjectEditor;
import io.mateu.core.domain.model.inbound.persistence.Merger;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.uidefinition.core.interfaces.ResponseWrapper;
import io.mateu.core.domain.uidefinition.shared.annotations.Action;
import io.mateu.core.domain.uidefinition.shared.annotations.ActionTarget;
import io.mateu.core.domain.uidefinition.shared.annotations.MainAction;
import io.mateu.core.domain.uidefinition.shared.data.GoBack;
import io.mateu.core.domain.uidefinition.shared.data.Result;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Message;
import io.mateu.dtos.ResultType;
import io.mateu.dtos.Step;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RunMethodActionRunner
extends AbstractActionRunner
implements ActionRunner {
    final JourneyContainerService store;
    final Merger merger;
    final ActualValueExtractor actualValueExtractor;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;
    final ValidationService validationService;

    @Override
    public boolean applies(JourneyContainer journeyContainer, Object viewInstance, String actionId) {
        if ("xxxbacktostep".equals(actionId)) {
            return true;
        }
        return this.getActions(journeyContainer, this.getActualInstance(journeyContainer, viewInstance, Map.of())).containsKey(actionId);
    }

    private Object getActualInstance(JourneyContainer journeyContainer, Object viewInstance, Map<String, Object> data) {
        if (viewInstance instanceof EntityEditor) {
            try {
                EntityEditor entityEditor = (EntityEditor)viewInstance;
                Object actualInstance = this.merger.loadEntity(entityEditor.getData(), entityEditor.getEntityClass());
                data.entrySet().forEach(entry -> {
                    try {
                        Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, actualInstance);
                        this.reflectionHelper.setValue((String)entry.getKey(), actualInstance, actualValue);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    }
                });
                return actualInstance;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (viewInstance instanceof ObjectEditor) {
            try {
                ObjectEditor objectEditor = (ObjectEditor)viewInstance;
                Object object = this.reflectionHelper.newInstance(objectEditor.getType());
                Object filled = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
                this.reflectionHelper.copy(filled, object);
                Object actualInstance = object;
                data.entrySet().forEach(entry -> {
                    try {
                        Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, actualInstance);
                        this.reflectionHelper.setValue((String)entry.getKey(), actualInstance, actualValue);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    }
                });
                return actualInstance;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return viewInstance;
    }

    private Map<Object, Method> getActions(JourneyContainer journeyContainer, Object viewInstance) {
        return this.reflectionHelper.getAllMethods(this.getActualInstance(journeyContainer, viewInstance, Map.of()).getClass()).stream().filter(m -> m.isAnnotationPresent(Action.class) || m.isAnnotationPresent(MainAction.class)).collect(Collectors.toMap(m -> m.getName(), m -> m));
    }

    @Override
    public Mono<Void> run(JourneyContainer journeyContainer, Object viewInstance, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        if ("xxxbacktostep".equals(actionId)) {
            this.store.backToStep(journeyContainer, stepId);
            return Mono.empty().then();
        }
        Object actualViewInstance = this.getActualInstance(journeyContainer, viewInstance, data);
        Method m = this.getActions(journeyContainer, actualViewInstance).get(actionId);
        return this.runMethod(journeyContainer, actualViewInstance, m, stepId, actionId, data, serverHttpRequest);
    }

    public Mono<Void> runMethod(JourneyContainer journeyContainer, Object actualViewInstance, Method m, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        this.resetMessages(journeyContainer);
        if (this.needsParameters(m)) {
            if (Modifier.isStatic(m.getModifiers())) {
                this.store.setStep(journeyContainer, actionId, new MethodParametersEditor(m.getDeclaringClass(), m.getName(), this.store.getCurrentStep(journeyContainer).getId(), data), serverHttpRequest);
            } else {
                this.store.setStep(journeyContainer, actionId, new MethodParametersEditor(actualViewInstance, m.getName(), this.store.getCurrentStep(journeyContainer).getId(), this.serializer), serverHttpRequest);
            }
        } else {
            if (this.needsValidation(m)) {
                this.validationService.validate(actualViewInstance);
            }
            try {
                Object result = m.invoke(actualViewInstance, this.injectParameters(m, serverHttpRequest));
                ArrayList messages = new ArrayList();
                if (result != null && Mono.class.isAssignableFrom(result.getClass())) {
                    Mono mono = (Mono)result;
                    return mono.map(r -> {
                        try {
                            this.updateStep(journeyContainer, actualViewInstance, serverHttpRequest, r);
                            this.processResponse(journeyContainer, m, r, serverHttpRequest);
                            this.addMessages(journeyContainer, r, m);
                        }
                        catch (Throwable e) {
                            return Mono.error((Throwable)new RuntimeException(e));
                        }
                        return r;
                    });
                }
                this.updateStep(journeyContainer, actualViewInstance, serverHttpRequest, result);
                this.processResponse(journeyContainer, m, result, serverHttpRequest);
                this.addMessages(journeyContainer, result, m);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                System.out.println(targetException.getClass().getSimpleName() + ": " + targetException.getMessage());
                throw targetException;
            }
        }
        return Mono.empty();
    }

    private void resetMessages(JourneyContainer journeyContainer) {
        String currentStepId = journeyContainer.getJourney().getCurrentStepId();
        Step step = (Step)journeyContainer.getSteps().get(currentStepId);
        step.getView().setMessages(List.of());
    }

    private void addMessages(JourneyContainer journeyContainer, Object response, Method method) {
        List<io.mateu.core.domain.uidefinition.core.interfaces.Message> messages = this.extractMessages(response, method);
        try {
            String currentStepId = journeyContainer.getJourney().getCurrentStepId();
            Step step = (Step)journeyContainer.getSteps().get(currentStepId);
            step.getView().setMessages(this.mapMessages(messages));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private List<Message> mapMessages(List<io.mateu.core.domain.uidefinition.core.interfaces.Message> messages) {
        if (messages != null) {
            return messages.stream().map(m -> new Message(m.getId(), m.getType(), m.getTitle(), m.getText())).collect(Collectors.toList());
        }
        return List.of();
    }

    private List<io.mateu.core.domain.uidefinition.core.interfaces.Message> extractMessages(Object response, Method method) {
        if (response instanceof io.mateu.core.domain.uidefinition.core.interfaces.Message) {
            return List.of((io.mateu.core.domain.uidefinition.core.interfaces.Message)response);
        }
        if (response instanceof List && io.mateu.core.domain.uidefinition.core.interfaces.Message.class.equals(this.reflectionHelper.getGenericClass(response.getClass()))) {
            return (List)response;
        }
        if (response instanceof ResponseWrapper) {
            return ((ResponseWrapper)response).getMessages();
        }
        if (method.isAnnotationPresent(Action.class) && ActionTarget.Message.equals((Object)method.getAnnotation(Action.class).target())) {
            return List.of(new io.mateu.core.domain.uidefinition.core.interfaces.Message(UUID.randomUUID().toString(), ResultType.Success, "", "" + response));
        }
        if (method.isAnnotationPresent(MainAction.class) && ActionTarget.Message.equals((Object)method.getAnnotation(MainAction.class).target())) {
            return List.of(new io.mateu.core.domain.uidefinition.core.interfaces.Message(UUID.randomUUID().toString(), ResultType.Success, "", "" + response));
        }
        if (response instanceof GoBack) {
            GoBack goBack = (GoBack)response;
            return List.of(new io.mateu.core.domain.uidefinition.core.interfaces.Message(UUID.randomUUID().toString(), goBack.getResultType(), "", goBack.getMessage()));
        }
        return List.of();
    }

    private void updateStep(JourneyContainer journeyContainer, Object actualViewInstance, ServerHttpRequest serverHttpRequest, Object r) {
        if (actualViewInstance != null && !(actualViewInstance instanceof Listing)) {
            try {
                this.store.updateStep(journeyContainer, actualViewInstance, serverHttpRequest);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processResponse(JourneyContainer journeyContainer, Method m, Object r, ServerHttpRequest serverHttpRequest) throws Throwable {
        Object whatToShow = this.getActualResponse(r, m);
        if (whatToShow instanceof GoBack) {
            this.store.back(journeyContainer);
        } else if (this.needsToBeShown(m, r)) {
            if (whatToShow instanceof Result) {
                this.addBackDestination((Result)whatToShow, this.store.getInitialStep(journeyContainer));
            }
            String newStepId = "result_" + UUID.randomUUID().toString();
            this.store.setStep(journeyContainer, newStepId, whatToShow, serverHttpRequest);
        }
    }

    private boolean needsToBeShown(Method m, Object r) {
        return !(Void.TYPE.equals(m.getReturnType()) || io.mateu.core.domain.uidefinition.core.interfaces.Message.class.equals(m.getReturnType()) || m.isAnnotationPresent(Action.class) && ActionTarget.Message.equals((Object)m.getAnnotation(Action.class).target()) || m.isAnnotationPresent(MainAction.class) && ActionTarget.Message.equals((Object)m.getAnnotation(MainAction.class).target()) || List.class.isAssignableFrom(m.getReturnType()) && io.mateu.core.domain.uidefinition.core.interfaces.Message.class.equals(this.reflectionHelper.getGenericClass(m.getGenericReturnType())));
    }

    private Object getActualResponse(Object r, Method m) {
        if (r == null) {
            return r;
        }
        if (r instanceof ResponseWrapper) {
            return ((ResponseWrapper)r).getResponse();
        }
        if (r instanceof io.mateu.core.domain.uidefinition.core.interfaces.Message) {
            return null;
        }
        if (r instanceof List && io.mateu.core.domain.uidefinition.core.interfaces.Message.class.equals(this.reflectionHelper.getGenericClass(r.getClass()))) {
            return null;
        }
        if (m.isAnnotationPresent(Action.class) && ActionTarget.Message.equals((Object)m.getAnnotation(Action.class).target()) || m.isAnnotationPresent(MainAction.class) && ActionTarget.Message.equals((Object)m.getAnnotation(MainAction.class).target())) {
            return null;
        }
        return r;
    }

    private boolean needsValidation(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            return m.getAnnotation(Action.class).validateBefore();
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            return m.getAnnotation(MainAction.class).validateBefore();
        }
        return false;
    }

    private Object[] injectParameters(Method m, ServerHttpRequest serverHttpRequest) {
        Object[] values = new Object[m.getParameterCount()];
        for (int i = 0; i < m.getParameters().length; ++i) {
            Parameter parameter = m.getParameters()[i];
            ServerHttpRequest value = null;
            if (ServerHttpRequest.class.equals(parameter.getType())) {
                value = serverHttpRequest;
            }
            values[i] = value;
        }
        return values;
    }

    private boolean needsParameters(Method m) {
        if (m.getParameterCount() == 0) {
            return false;
        }
        boolean anyNotInjected = false;
        for (Parameter parameter : m.getParameters()) {
            if (parameter.getType().equals(ServerHttpRequest.class)) continue;
            anyNotInjected = true;
        }
        return anyNotInjected;
    }

    public RunMethodActionRunner(JourneyContainerService store, Merger merger, ActualValueExtractor actualValueExtractor, ReflectionHelper reflectionHelper, Serializer serializer, ValidationService validationService) {
        this.store = store;
        this.merger = merger;
        this.actualValueExtractor = actualValueExtractor;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
        this.validationService = validationService;
    }
}

