/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.startJourney;

import io.mateu.core.domain.commands.startJourney.StartJourneyCommand;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.JourneyMapper;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.MenuResolver;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.StepMapper;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.UIMapper;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.UiInstantiator;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.model.util.exceptions.NotFoundException;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenCRUDAction;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenCRUDActionViewBuilder;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenEditorAction;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenListViewAction;
import io.mateu.core.domain.uidefinition.core.interfaces.HasInitMethod;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import io.mateu.core.domain.uidefinition.shared.interfaces.MenuEntry;
import io.mateu.dtos.Journey;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.JourneyCreationRq;
import io.mateu.dtos.Step;
import io.mateu.dtos.StepWrapper;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StartJourneyCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(StartJourneyCommandHandler.class);
    private final ReflectionHelper reflectionHelper;
    private final UIMapper uiMapper;
    private final MDDOpenCRUDActionViewBuilder mddOpenCRUDActionViewBuilder;
    private final StepMapper stepMapper;
    private final Serializer serializer;
    private final MenuResolver menuResolver;
    private final UiInstantiator uiInstantiator;

    public StartJourneyCommandHandler(ReflectionHelper reflectionHelper, UIMapper uiMapper, MDDOpenCRUDActionViewBuilder mddOpenCRUDActionViewBuilder, StepMapper stepMapper, Serializer serializer, MenuResolver menuResolver, UiInstantiator uiInstantiator) {
        this.reflectionHelper = reflectionHelper;
        this.uiMapper = uiMapper;
        this.mddOpenCRUDActionViewBuilder = mddOpenCRUDActionViewBuilder;
        this.stepMapper = stepMapper;
        this.serializer = serializer;
        this.menuResolver = menuResolver;
        this.uiInstantiator = uiInstantiator;
    }

    public Mono<StepWrapper> handle(StartJourneyCommand command) throws Throwable {
        String uiId = command.getUiId();
        String journeyId = command.getJourneyId();
        String journeyTypeId = command.getJourneyTypeId();
        JourneyCreationRq journeyCreationRq = command.getJourneyCreationRq();
        ServerHttpRequest serverHttpRequest = command.getServerHttpRequest();
        Journey journey = null;
        Object formInstance = null;
        try {
            formInstance = this.resolveJourneyTypeId(uiId, journeyTypeId, serverHttpRequest);
            if (formInstance == null) {
                throw new Exception();
            }
            if (formInstance instanceof HasInitMethod) {
                ((HasInitMethod)formInstance).init(serverHttpRequest);
            }
            journey = new JourneyMapper().map(formInstance);
        }
        catch (Exception e) {
            log.error("error on getUi", (Throwable)e);
            throw new NotFoundException("No class with name " + journeyTypeId + " found");
        }
        JourneyContainer journeyContainer = JourneyContainer.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).journeyClass(formInstance.getClass()).journeyData(journeyCreationRq.getContextData()).steps(Map.of()).journey(journey).lastUsedSorting(Map.of()).lastUsedFilters(Map.of()).build();
        Step step = this.stepMapper.map(journeyContainer, this.getStepId(formInstance), null, formInstance, serverHttpRequest);
        journey.setCurrentStepId(step.getId());
        journey.setCurrentStepDefinitionId(step.getType());
        journeyContainer.setInitialStep(step);
        journeyContainer.setSteps(Map.of(step.getId(), step));
        return Mono.just((Object)StepWrapper.builder().journey(journey).step(step).store(this.toMap(journeyContainer)).build());
    }

    private String getStepId(Object formInstance) {
        if (formInstance instanceof Listing) {
            return "list";
        }
        return "form";
    }

    public Object resolveJourneyTypeId(String uiId, String journeyTypeId, ServerHttpRequest serverHttpRequest) {
        Object ui = this.uiInstantiator.instantiateUi(uiId, serverHttpRequest);
        Optional<MenuEntry> menuEntry = this.menuResolver.resolve(ui, journeyTypeId, serverHttpRequest);
        return menuEntry.map(entry -> this.createInstanceFromMenuMapping(entry)).orElse(null);
    }

    private Object createInstanceFromMenuMapping(Object menuEntry) {
        if (menuEntry instanceof MDDOpenEditorAction) {
            MDDOpenEditorAction action = (MDDOpenEditorAction)menuEntry;
            if (action.getSupplier() != null) {
                return action.getSupplier().get();
            }
            return this.reflectionHelper.newInstance(action.getViewClass());
        }
        if (menuEntry instanceof MDDOpenCRUDAction) {
            MDDOpenCRUDAction action = (MDDOpenCRUDAction)menuEntry;
            return this.mddOpenCRUDActionViewBuilder.buildView(action);
        }
        if (menuEntry instanceof MDDOpenListViewAction) {
            MDDOpenListViewAction action = (MDDOpenListViewAction)menuEntry;
            if (action.getSupplier() != null) {
                return action.getSupplier().get();
            }
            return this.reflectionHelper.newInstance(action.getListViewClass());
        }
        return null;
    }

    private Map<String, Object> toMap(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        try {
            return this.serializer.toMap(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Map.of();
        }
    }
}

