/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.inbound;

import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.model.inbound.editors.EntityEditor;
import io.mateu.core.domain.model.inbound.editors.FieldEditor;
import io.mateu.core.domain.model.inbound.editors.ObjectEditor;
import io.mateu.core.domain.model.inbound.persistence.Merger;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.StepMapper;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.uidefinition.core.interfaces.JpaRpcCrudFactory;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.SortCriteria;
import io.mateu.dtos.Step;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JourneyContainerService {
    private static final Logger log = LoggerFactory.getLogger(JourneyContainerService.class);
    private final StepMapper stepMapper;
    private final ActualValueExtractor actualValueExtractor;
    private final ApplicationContext applicationContext;
    private final Merger merger;
    private final JpaRpcCrudFactory jpaRpcCrudFactory;
    private final ReflectionHelper reflectionHelper;
    private final Serializer serializer;

    public Object getViewInstance(JourneyContainer journeyContainer, String stepId, ServerHttpRequest serverHttpRequest) throws Exception {
        Step step = (Step)journeyContainer.getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " for journey with id " + journeyContainer.getJourneyId() + " found");
        }
        Object viewInstance = this.reflectionHelper.newInstance(Class.forName(step.getType()));
        Map data = step.getData();
        if (viewInstance instanceof EntityEditor) {
            ((EntityEditor)viewInstance).setEntityClass(Class.forName((String)data.get("__entityClassName__")));
            ((EntityEditor)viewInstance).setData(data);
        } else if (viewInstance instanceof ObjectEditor) {
            ((ObjectEditor)viewInstance).setType(Class.forName((String)data.get("__entityClassName__")));
            ((ObjectEditor)viewInstance).setData(data);
        } else if (viewInstance instanceof FieldEditor) {
            ((FieldEditor)viewInstance).setType(Class.forName((String)data.get("__type__")));
            ((FieldEditor)viewInstance).setFieldId((String)data.get("__fieldId__"));
            ((FieldEditor)viewInstance).setInitialStep((String)data.get("__initialStep__"));
            ((FieldEditor)viewInstance).setData(data);
        } else {
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, viewInstance);
                    this.reflectionHelper.setValue((String)entry.getKey(), viewInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
        }
        return viewInstance;
    }

    @Transactional
    public Listing getRpcViewInstance(JourneyContainer journeyContainer, String stepId, String listId, ServerHttpRequest serverHttpRequest) throws Exception {
        try {
            Field listField;
            Object viewInstance = this.getViewInstance(journeyContainer, stepId, serverHttpRequest);
            if (viewInstance instanceof Listing) {
                return (Listing)viewInstance;
            }
            Object actualInstance = viewInstance;
            Listing rpcView = null;
            if (actualInstance instanceof EntityEditor) {
                EntityEditor entityEditor = (EntityEditor)actualInstance;
                Field listField2 = this.reflectionHelper.getFieldByName((actualInstance = this.merger.loadEntity(entityEditor.getData(), entityEditor.getEntityClass())).getClass(), listId);
                if (listField2 != null) {
                    return this.jpaRpcCrudFactory.create(actualInstance, listField2);
                }
            } else if (actualInstance instanceof ObjectEditor) {
                ObjectEditor objectEditor = (ObjectEditor)actualInstance;
                Object instanceFromSpringContext = this.reflectionHelper.newInstance(objectEditor.getType());
                Object instanceWithDeserializedValues = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
                this.reflectionHelper.copy(instanceWithDeserializedValues, instanceFromSpringContext);
                Field listField3 = this.reflectionHelper.getFieldByName(instanceFromSpringContext.getClass(), listId);
                if (listField3 != null) {
                    return (Listing)this.reflectionHelper.getValue(listField3, instanceFromSpringContext);
                }
            } else {
                return (Listing)this.reflectionHelper.getValue(listId, actualInstance);
            }
            if ((listField = this.reflectionHelper.getFieldByName(actualInstance.getClass(), listId)) != null) {
                rpcView = (Listing)this.reflectionHelper.newInstance(listField.getType());
                this.reflectionHelper.setValue(listId, actualInstance, (Object)rpcView);
            }
            return rpcView;
        }
        catch (Exception e) {
            log.warn("on getRpcViewInstance for " + journeyContainer.getJourneyId() + " " + stepId + " " + listId, (Throwable)e);
            return null;
        }
    }

    public void updateStep(JourneyContainer journeyContainer, String stepId, Object editor, ServerHttpRequest serverHttpRequest) throws Throwable {
        Step oldStep = (Step)journeyContainer.getSteps().get(stepId);
        Step step = this.stepMapper.map(journeyContainer, stepId, oldStep.getPreviousStepId(), editor, serverHttpRequest);
        if (oldStep != null) {
            Map data = oldStep.getData();
            data.putAll(step.getData());
            step.setData(data);
        }
        if (!journeyContainer.getSteps().containsKey(stepId)) {
            journeyContainer.setSteps(this.extendMap(journeyContainer.getSteps(), stepId, step));
        } else {
            HashMap<String, Step> modifiableMap = new HashMap<String, Step>(journeyContainer.getSteps());
            modifiableMap.put(stepId, step);
            journeyContainer.setSteps(modifiableMap);
        }
    }

    public void updateStep(JourneyContainer journeyContainer, Object editor, ServerHttpRequest serverHttpRequest) throws Throwable {
        String stepId = journeyContainer.getJourney().getCurrentStepId();
        this.updateStep(journeyContainer, stepId, editor, serverHttpRequest);
    }

    public void updateStep(JourneyContainer journeyContainer, String stepId, Step step) throws Throwable {
        if (!journeyContainer.getSteps().containsKey(stepId)) {
            journeyContainer.setSteps(this.extendMap(journeyContainer.getSteps(), stepId, step));
        } else {
            HashMap<String, Step> modifiableMap = new HashMap<String, Step>(journeyContainer.getSteps());
            modifiableMap.put(stepId, step);
            journeyContainer.setSteps(modifiableMap);
        }
    }

    public void setStep(JourneyContainer journeyContainer, String stepId, Object editor, ServerHttpRequest serverHttpRequest) throws Throwable {
        Object stepIdPrefix = journeyContainer.getJourney().getCurrentStepId();
        stepIdPrefix = stepIdPrefix == null ? "" : (String)stepIdPrefix + "_";
        if (((String)stepIdPrefix).endsWith("view_")) {
            stepIdPrefix = ((String)stepIdPrefix).substring(0, "view_".length());
        }
        if (((String)stepIdPrefix).endsWith("edit_")) {
            stepIdPrefix = ((String)stepIdPrefix).substring(0, "edit_".length());
        }
        String newStepId = (String)stepIdPrefix + stepId;
        Step step = this.stepMapper.map(journeyContainer, newStepId, this.getPreviousStepId(newStepId, journeyContainer), editor, serverHttpRequest);
        if (!journeyContainer.getSteps().containsKey(newStepId)) {
            journeyContainer.setSteps(this.extendMap(journeyContainer.getSteps(), newStepId, step));
        } else {
            HashMap<CallSite, Step> modifiableMap = new HashMap<CallSite, Step>(journeyContainer.getSteps());
            modifiableMap.put((CallSite)((Object)newStepId), step);
            journeyContainer.setSteps(modifiableMap);
        }
        journeyContainer.getJourney().setCurrentStepId(newStepId);
        journeyContainer.getJourney().setCurrentStepDefinitionId(editor.getClass().getName());
    }

    private String getPreviousStepId(String targetStepId, JourneyContainer journeyContainer) {
        String currentStepId = journeyContainer.getJourney().getCurrentStepId();
        if (targetStepId.equals(currentStepId)) {
            return ((Step)journeyContainer.getSteps().get(currentStepId)).getPreviousStepId();
        }
        return currentStepId;
    }

    private String getCurrentStepId(JourneyContainer journeyContainer) {
        return journeyContainer.getJourney().getCurrentStepId();
    }

    private Map<String, Step> extendMap(Map<String, Step> steps, String stepId, Step step) {
        HashMap<String, Step> extended = new HashMap<String, Step>();
        extended.putAll(steps);
        extended.put(stepId, step);
        return extended;
    }

    public void backToStep(JourneyContainer journeyContainer, String stepId) throws Exception {
        Step step = (Step)journeyContainer.getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " for journey with id " + journeyContainer.getJourneyId() + " found");
        }
        journeyContainer.getJourney().setCurrentStepId(stepId);
        journeyContainer.getJourney().setCurrentStepDefinitionId(step.getType());
    }

    public void back(JourneyContainer journeyContainer) throws Exception {
        String previousStepId = this.getPreviousStepId(this.getCurrentStepId(journeyContainer), journeyContainer);
        this.backToStep(journeyContainer, previousStepId);
    }

    public Step getStep(JourneyContainer journeyContainer, String stepId) throws Exception {
        Step step = (Step)journeyContainer.getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " found for journey " + journeyContainer.getJourneyId());
        }
        journeyContainer.getJourney().setCurrentStepDefinitionId(step.getType());
        journeyContainer.getJourney().setCurrentStepId(stepId);
        return step;
    }

    public Step readStep(JourneyContainer journeyContainer, String stepId) throws Exception {
        Step step = (Step)journeyContainer.getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " found for journey " + journeyContainer.getJourneyId());
        }
        return step;
    }

    public Step getInitialStep(JourneyContainer journeyContainer) throws Exception {
        return journeyContainer.getInitialStep();
    }

    public Step getCurrentStep(JourneyContainer journeyContainer) throws Exception {
        String currentStepId = journeyContainer.getJourney().getCurrentStepId();
        return (Step)journeyContainer.getSteps().get(currentStepId);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object getLastUsedFilters(JourneyContainer journeyContainer, String stepId, String listId) {
        return journeyContainer.getLastUsedFilters().get(stepId + "#" + listId);
    }

    public List<SortCriteria> getLastUsedOrders(JourneyContainer journeyContainer, String stepId, String listId) {
        return (List)journeyContainer.getLastUsedSorting().get(stepId + "#" + listId);
    }

    public void saveFilters(JourneyContainer journeyContainer, String stepId, String listId, Object filters) {
        journeyContainer.getLastUsedFilters().put(stepId + "#" + listId, filters);
    }

    public void saveOrders(JourneyContainer journeyContainer, String stepId, String listId, List<SortCriteria> sorting) {
        journeyContainer.getLastUsedSorting().put(stepId + "#" + listId, sorting);
    }

    public JourneyContainerService(StepMapper stepMapper, ActualValueExtractor actualValueExtractor, ApplicationContext applicationContext, Merger merger, JpaRpcCrudFactory jpaRpcCrudFactory, ReflectionHelper reflectionHelper, Serializer serializer) {
        this.stepMapper = stepMapper;
        this.actualValueExtractor = actualValueExtractor;
        this.applicationContext = applicationContext;
        this.merger = merger;
        this.jpaRpcCrudFactory = jpaRpcCrudFactory;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
    }
}

