/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.inbound.menuResolvers;

import io.mateu.core.domain.model.inbound.menuResolvers.MenuEntryFactory;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.uidefinition.core.app.AbstractMenu;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenEditorAction;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenHtmlAction;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenListViewAction;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenUrlAction;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenUserJourneyAction;
import io.mateu.core.domain.uidefinition.shared.annotations.Home;
import io.mateu.core.domain.uidefinition.shared.annotations.PrivateHome;
import io.mateu.core.domain.uidefinition.shared.annotations.PublicHome;
import io.mateu.core.domain.uidefinition.shared.interfaces.JourneyRunner;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import io.mateu.core.domain.uidefinition.shared.interfaces.MenuEntry;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DefaultMenuEntryFactory
implements MenuEntryFactory {
    public final ReflectionHelper reflectionHelper;

    public ReflectionHelper getReflectionHelper() {
        return this.reflectionHelper;
    }

    @Override
    public MenuEntry buildMenuEntry(final Object app, final AnnotatedElement f, String caption) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (JourneyRunner.class.isAssignableFrom(app.getClass())) {
            return new MDDOpenUserJourneyAction(caption, (JourneyRunner)app);
        }
        if (List.class.isAssignableFrom(app.getClass()) && MenuEntry.class.equals(this.reflectionHelper.getGenericClass(this.reflectionHelper.getType(f)))) {
            return new AbstractMenu(caption){

                @Override
                public List<MenuEntry> buildEntries() {
                    List<MenuEntry> l = new ArrayList<MenuEntry>();
                    try {
                        l = (List)DefaultMenuEntryFactory.this.reflectionHelper.getValue(f, app);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return l;
                }
            };
        }
        if (URL.class.equals(app.getClass())) {
            return new MDDOpenUrlAction(caption, (URL)app);
        }
        if (this.reflectionHelper.isBasic(app.getClass()) || String.class.equals(app.getClass())) {
            if (f.isAnnotationPresent(Home.class) || f.isAnnotationPresent(PublicHome.class) || f.isAnnotationPresent(PrivateHome.class)) {
                return new MDDOpenHtmlAction(caption, "" + app);
            }
        } else {
            if (Listing.class.isAssignableFrom(app.getClass())) {
                Object finalUiInstance = app;
                return new MDDOpenListViewAction(caption, () -> (Listing)finalUiInstance);
            }
            Object finalUiInstance1 = app;
            return new MDDOpenEditorAction(caption, () -> finalUiInstance1);
        }
        return null;
    }

    public DefaultMenuEntryFactory(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

