/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.inbound.persistence;

import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.model.util.persistence.EntityDeserializer;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
public class Merger {
    @PersistenceContext
    EntityManager em;
    @Autowired
    Serializer serializer;
    @Autowired
    EntityDeserializer entityDeserializer;

    @Transactional
    public void merge(Object entity) {
        this.em.merge(entity);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void mergeAndCommit(Object entity) {
        this.em.merge(entity);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void mergeAndCommit(Map<String, Object> data, Class entityClass) throws Exception {
        this.em.merge(this.getEntity(data, entityClass));
    }

    public Object getEntity(Map<String, Object> data, Class entityClass) throws Exception {
        return this.entityDeserializer.fromJson(this.em, this.serializer.toJson(data), entityClass);
    }

    public Object loadEntity(Map<String, Object> data, Class entityClass) throws Exception {
        return this.em.find(entityClass, data.get("__id"));
    }
}

