/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.metadataBuilders;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.outbound.Humanizer;
import io.mateu.core.domain.model.outbound.i18n.Translator;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.fieldabstraction.FieldForCheckboxColumn;
import io.mateu.core.domain.uidefinition.core.interfaces.HasTitle;
import io.mateu.core.domain.uidefinition.core.interfaces.PersistentPojo;
import io.mateu.core.domain.uidefinition.shared.annotations.Action;
import io.mateu.core.domain.uidefinition.shared.annotations.Caption;
import io.mateu.core.domain.uidefinition.shared.annotations.Submenu;
import java.lang.reflect.Method;
import org.springframework.stereotype.Service;

@Service
public class CaptionProvider {
    private final Humanizer humanizer;
    private final Translator translator;

    public CaptionProvider(Humanizer humanizer, Translator translator) {
        this.humanizer = humanizer;
        this.translator = translator;
    }

    public String getCaption(Object object) {
        PersistentPojo persistentPojo;
        Object caption = this.guessCaption(object);
        if (object instanceof PersistentPojo && (persistentPojo = (PersistentPojo)object).isNewRecord()) {
            caption = "New " + (String)caption;
        }
        return this.translator.translate((String)caption);
    }

    private String guessCaption(Object object) {
        if (object instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)object;
            return hasTitle.getTitle();
        }
        if (object.getClass().isAnnotationPresent(Caption.class)) {
            return object.getClass().getAnnotation(Caption.class).value();
        }
        try {
            if (!object.getClass().getMethod("toString", new Class[0]).getDeclaringClass().equals(Object.class)) {
                return object.toString();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.humanizer.capitalize(object.getClass().getSimpleName());
    }

    public String getCaption(Field f) {
        if (f.isAnnotationPresent(Caption.class)) {
            return this.translator.translate(f.getAnnotation(Caption.class).value());
        }
        String caption = "";
        if (f.isAnnotationPresent(Submenu.class)) {
            caption = f.getAnnotation(Submenu.class).value();
        }
        if (f.isAnnotationPresent(Action.class)) {
            caption = f.getAnnotation(Action.class).value();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = this.humanizer.capitalize(f.getName());
        }
        if (f instanceof FieldForCheckboxColumn) {
            FieldForCheckboxColumn fieldInterfacedForCheckboxColumn = (FieldForCheckboxColumn)f;
            caption = fieldInterfacedForCheckboxColumn.getValueForColumn();
        }
        return this.translator.translate(caption);
    }

    public String getCaption(Method f) {
        if (f.isAnnotationPresent(Caption.class)) {
            return this.translator.translate(f.getAnnotation(Caption.class).value());
        }
        String caption = "";
        if (f.isAnnotationPresent(Submenu.class)) {
            caption = f.getAnnotation(Submenu.class).value();
        }
        if (f.isAnnotationPresent(Action.class)) {
            caption = f.getAnnotation(Action.class).value();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = this.humanizer.capitalize(f.getName());
        }
        return this.translator.translate(caption);
    }
}

