/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.metadataBuilders;

import io.mateu.core.domain.model.outbound.metadataBuilders.CaptionProvider;
import io.mateu.core.domain.model.outbound.metadataBuilders.FieldMetadataBuilder;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.core.interfaces.HasIcon;
import io.mateu.core.domain.uidefinition.core.interfaces.HasInfo;
import io.mateu.core.domain.uidefinition.core.interfaces.HasSubtitle;
import io.mateu.core.domain.uidefinition.core.interfaces.HasTotal;
import io.mateu.core.domain.uidefinition.shared.annotations.SameLine;
import io.mateu.core.domain.uidefinition.shared.annotations.UseCrud;
import io.mateu.core.domain.uidefinition.shared.data.StatusType;
import io.mateu.core.domain.uidefinition.shared.interfaces.HasStatus;
import io.mateu.dtos.Card;
import io.mateu.dtos.FieldGroup;
import io.mateu.dtos.FieldGroupLine;
import io.mateu.dtos.Status;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CardMetadataBuilder {
    final FieldMetadataBuilder fieldMetadataBuilder;
    final ReflectionHelper reflectionHelper;
    final CaptionProvider captionProvider;

    public Card build(String stepId, Object uiInstance, List<Field> slotFields) {
        Card card = Card.builder().title(this.captionProvider.getCaption(uiInstance)).subtitle(this.getSubtitle(uiInstance)).fieldGroups(this.getFieldGroups(stepId, uiInstance, slotFields)).icon(this.getIcon(uiInstance)).info(this.getInfo(uiInstance)).total(this.getTotal(uiInstance)).build();
        return card;
    }

    private String getIcon(Object uiInstance) {
        if (uiInstance instanceof HasIcon) {
            return ((HasIcon)uiInstance).getIcon();
        }
        return null;
    }

    private String getInfo(Object uiInstance) {
        if (uiInstance instanceof HasInfo) {
            return ((HasInfo)uiInstance).getInfo();
        }
        return null;
    }

    private String getTotal(Object uiInstance) {
        if (uiInstance instanceof HasTotal) {
            return ((HasTotal)uiInstance).getTotal();
        }
        return null;
    }

    private String getSubtitle(Object uiInstance) {
        if (uiInstance instanceof HasSubtitle) {
            return ((HasSubtitle)uiInstance).getSubtitle();
        }
        return null;
    }

    private Status getStatus(Object uiInstance) {
        if (!(uiInstance instanceof HasStatus)) {
            return null;
        }
        HasStatus hasStatus = (HasStatus)uiInstance;
        if (hasStatus.getStatus() == null) {
            return null;
        }
        return new Status(this.mapStatusType(hasStatus.getStatus().getType()), hasStatus.getStatus().getMessage());
    }

    private io.mateu.dtos.StatusType mapStatusType(StatusType type) {
        return io.mateu.dtos.StatusType.valueOf((String)type.toString());
    }

    private List<FieldGroup> getFieldGroups(String stepId, Object uiInstance, List<Field> slotFields) {
        ArrayList<FieldGroup> fieldGroups = new ArrayList<FieldGroup>();
        FieldGroup fieldGroup = null;
        FieldGroupLine fieldGroupLine = null;
        List allEditableFields = this.reflectionHelper.getAllEditableFields(uiInstance.getClass()).stream().filter(f -> !f.isAnnotationPresent(OneToMany.class) && !f.isAnnotationPresent(ManyToMany.class) || !f.isAnnotationPresent(UseCrud.class)).filter(f -> slotFields.contains(f)).filter(f -> !(uiInstance instanceof HasTotal) || !f.getName().equals("total")).collect(Collectors.toList());
        for (Field field : allEditableFields) {
            if (fieldGroup == null || field.isAnnotationPresent(io.mateu.core.domain.uidefinition.shared.annotations.FieldGroup.class)) {
                String caption = "";
                if (field.isAnnotationPresent(io.mateu.core.domain.uidefinition.shared.annotations.FieldGroup.class)) {
                    caption = field.getAnnotation(io.mateu.core.domain.uidefinition.shared.annotations.FieldGroup.class).value();
                }
                fieldGroup = FieldGroup.builder().caption(caption).lines(new ArrayList()).build();
                fieldGroups.add(fieldGroup);
            }
            if (fieldGroupLine == null || !field.isAnnotationPresent(SameLine.class)) {
                fieldGroupLine = FieldGroupLine.builder().fields(new ArrayList()).build();
                fieldGroup.getLines().add(fieldGroupLine);
            }
            fieldGroupLine.getFields().add(this.fieldMetadataBuilder.getField(uiInstance, field));
        }
        this.fillGroupIds(fieldGroups);
        return fieldGroups;
    }

    private void fillGroupIds(List<FieldGroup> fieldGroups) {
        int j = 0;
        for (FieldGroup g : fieldGroups) {
            g.setId("fieldgroup_" + j++);
        }
    }

    public CardMetadataBuilder(FieldMetadataBuilder fieldMetadataBuilder, ReflectionHelper reflectionHelper, CaptionProvider captionProvider) {
        this.fieldMetadataBuilder = fieldMetadataBuilder;
        this.reflectionHelper = reflectionHelper;
        this.captionProvider = captionProvider;
    }
}

