/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.metadataBuilders;

import io.mateu.core.domain.model.outbound.metadataBuilders.ActionMetadataBuilder;
import io.mateu.core.domain.model.outbound.metadataBuilders.CaptionProvider;
import io.mateu.core.domain.model.outbound.metadataBuilders.FieldMetadataBuilder;
import io.mateu.core.domain.model.outbound.metadataBuilders.fields.FieldTypeMapper;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.uidefinition.core.interfaces.DynamicCrud;
import io.mateu.core.domain.uidefinition.core.interfaces.HasSubtitle;
import io.mateu.core.domain.uidefinition.core.interfaces.RpcCrudViewExtended;
import io.mateu.core.domain.uidefinition.shared.annotations.Ignored;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import io.mateu.dtos.Column;
import io.mateu.dtos.Crud;
import io.mateu.dtos.Field;
import io.mateu.dtos.SearchForm;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CrudMetadataBuilder {
    final ActionMetadataBuilder actionMetadataBuilder;
    final FieldMetadataBuilder fieldMetadataBuilder;
    final FieldTypeMapper fieldTypeMapper;
    final ReflectionHelper reflectionHelper;
    final CaptionProvider captionProvider;

    public Crud build(String stepId, String listId, Object crudInstance) {
        if (crudInstance instanceof DynamicCrud) {
            return (Crud)((DynamicCrud)crudInstance).build().toFuture().get();
        }
        Listing rpcView = (Listing)crudInstance;
        return Crud.builder().title(this.captionProvider.getCaption(rpcView)).subtitle(this.getSubtitle(rpcView)).canEdit(this.reflectionHelper.isOverridden(rpcView, "getDetail")).searchForm(this.buildSearchForm(rpcView, listId)).columns(this.buildColumns(rpcView)).actions(this.actionMetadataBuilder.getActions(stepId, listId, rpcView)).listId(listId).build();
    }

    private String getSubtitle(Listing rpcView) {
        if (rpcView instanceof HasSubtitle) {
            return ((HasSubtitle)((Object)rpcView)).getSubtitle();
        }
        return null;
    }

    private List<Column> buildColumns(Listing rpcView) {
        Class rowClass = rpcView.getRowClass();
        HashMap<io.mateu.core.domain.model.reflection.fieldabstraction.Field, String> columnIdsPerField = new HashMap<io.mateu.core.domain.model.reflection.fieldabstraction.Field, String>();
        HashMap<io.mateu.core.domain.model.reflection.fieldabstraction.Field, String> columnCaptionsPerField = new HashMap<io.mateu.core.domain.model.reflection.fieldabstraction.Field, String>();
        List<io.mateu.core.domain.model.reflection.fieldabstraction.Field> allRowFields = null;
        if (rpcView instanceof RpcCrudViewExtended) {
            allRowFields = ((RpcCrudViewExtended)((Object)rpcView)).getColumnFieldNames();
            columnIdsPerField.putAll(((RpcCrudViewExtended)((Object)rpcView)).getColumnIdsPerField());
            columnCaptionsPerField.putAll(((RpcCrudViewExtended)((Object)rpcView)).getColumnCaptionsPerField());
        } else {
            allRowFields = this.reflectionHelper.getAllFields(rowClass);
        }
        return allRowFields.stream().filter(f -> f != null).filter(fieldInterfaced -> !fieldInterfaced.isAnnotationPresent(Ignored.class)).map(fieldInterfaced -> this.getColumn(columnIdsPerField.getOrDefault(fieldInterfaced, fieldInterfaced.getId()), columnCaptionsPerField.getOrDefault(fieldInterfaced, this.captionProvider.getCaption((io.mateu.core.domain.model.reflection.fieldabstraction.Field)fieldInterfaced)), (io.mateu.core.domain.model.reflection.fieldabstraction.Field)fieldInterfaced)).collect(Collectors.toList());
    }

    private Column getColumn(String columnId, String columnCaption, io.mateu.core.domain.model.reflection.fieldabstraction.Field field) {
        return Column.builder().id(columnId).caption(columnCaption).type(this.fieldTypeMapper.mapColumnType(field)).stereotype("column").attributes(List.of()).width(this.fieldTypeMapper.getWidth(field)).build();
    }

    private SearchForm buildSearchForm(Listing rpcView, String listId) {
        return SearchForm.builder().fields(this.buildSearchFields(rpcView, listId)).build();
    }

    private List<Field> buildSearchFields(Listing rpcView, String listId) {
        List validFieldIds;
        Class searchFormClass = rpcView.getSearchFormClass();
        List<io.mateu.core.domain.model.reflection.fieldabstraction.Field> allEditableFields = this.reflectionHelper.getAllEditableFields(searchFormClass);
        if (rpcView instanceof RpcCrudViewExtended && (validFieldIds = ((RpcCrudViewExtended)((Object)rpcView)).getFilterFields().stream().map(f -> f.getId()).collect(Collectors.toList())).size() > 0) {
            List<io.mateu.core.domain.model.reflection.fieldabstraction.Field> finalAllEditableFields = allEditableFields;
            allEditableFields = validFieldIds.stream().map(id -> finalAllEditableFields.stream().filter(f -> id.equals(f.getId())).findFirst()).filter(f -> f.isPresent()).map(f -> (io.mateu.core.domain.model.reflection.fieldabstraction.Field)f.get()).collect(Collectors.toList());
        }
        List<Field> filterFields = allEditableFields.stream().map(fieldInterfaced -> this.fieldMetadataBuilder.getField(rpcView, (io.mateu.core.domain.model.reflection.fieldabstraction.Field)fieldInterfaced)).map(f -> {
            f.setId(listId + "-" + f.getId());
            return f;
        }).collect(Collectors.toList());
        if ("JpaRpcCrudView".equals(rpcView.getClass().getSimpleName())) {
            filterFields.add(0, Field.builder().id(listId + "-_search-text").placeholder("Search").caption("Search").type("string").stereotype("input").build());
        }
        return filterFields;
    }

    public CrudMetadataBuilder(ActionMetadataBuilder actionMetadataBuilder, FieldMetadataBuilder fieldMetadataBuilder, FieldTypeMapper fieldTypeMapper, ReflectionHelper reflectionHelper, CaptionProvider captionProvider) {
        this.actionMetadataBuilder = actionMetadataBuilder;
        this.fieldMetadataBuilder = fieldMetadataBuilder;
        this.fieldTypeMapper = fieldTypeMapper;
        this.reflectionHelper = reflectionHelper;
        this.captionProvider = captionProvider;
    }
}

