/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.metadataBuilders;

import io.mateu.core.domain.model.outbound.metadataBuilders.CaptionProvider;
import io.mateu.core.domain.model.outbound.metadataBuilders.fields.FieldAttributeBuilder;
import io.mateu.core.domain.model.outbound.metadataBuilders.fields.FieldStereotypeMapper;
import io.mateu.core.domain.model.outbound.metadataBuilders.fields.FieldTypeMapper;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.uidefinition.shared.annotations.CallActionOnChange;
import io.mateu.core.domain.uidefinition.shared.annotations.Help;
import io.mateu.core.domain.uidefinition.shared.annotations.Placeholder;
import io.mateu.core.domain.uidefinition.shared.annotations.StyleClassNames;
import io.mateu.core.domain.uidefinition.shared.interfaces.HasBadgesOnFields;
import io.mateu.dtos.Badge;
import io.mateu.dtos.BadgeIconPosition;
import io.mateu.dtos.BadgeStyle;
import io.mateu.dtos.BadgeTheme;
import io.mateu.dtos.Field;
import io.mateu.dtos.Validation;
import io.mateu.dtos.ValidationType;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class FieldMetadataBuilder {
    final FieldAttributeBuilder fieldAttributeBuilder;
    final FieldTypeMapper fieldTypeMapper;
    final FieldStereotypeMapper fieldStereotypeMapper;
    final ReflectionHelper reflectionHelper;
    final CaptionProvider captionProvider;

    protected Field getField(Object view, io.mateu.core.domain.model.reflection.fieldabstraction.Field fieldInterfaced) {
        Field field = Field.builder().id(fieldInterfaced.getId()).caption(this.captionProvider.getCaption(fieldInterfaced)).placeholder(this.getPlaceholder(fieldInterfaced)).description(this.getDescription(fieldInterfaced)).cssClasses(this.getCssClassNames(fieldInterfaced)).type(this.fieldTypeMapper.mapFieldType(fieldInterfaced)).stereotype(this.fieldStereotypeMapper.mapStereotype(view, fieldInterfaced)).observed(this.isObserved(fieldInterfaced)).attributes(this.fieldAttributeBuilder.buildAttributes(view, fieldInterfaced)).badges(this.getBadges(view, fieldInterfaced)).build();
        this.addValidations(field, fieldInterfaced);
        return field;
    }

    private List<Badge> getBadges(Object view, io.mateu.core.domain.model.reflection.fieldabstraction.Field field) {
        if (!(view instanceof HasBadgesOnFields)) {
            return List.of();
        }
        return ((HasBadgesOnFields)view).getBadgesOnField(field.getId()).stream().map(b -> new Badge(this.mapBadgeTheme(b.getTheme()), b.getLabel(), b.getIcon(), this.mapBadgeStyle(b.getBadgeStyle()), this.mapBadgePosition(b.getIconPosition()))).collect(Collectors.toList());
    }

    private BadgeTheme mapBadgeTheme(io.mateu.core.domain.uidefinition.shared.data.BadgeTheme theme) {
        return BadgeTheme.valueOf((String)theme.toString());
    }

    private BadgeStyle mapBadgeStyle(io.mateu.core.domain.uidefinition.shared.data.BadgeStyle badgeStyle) {
        return BadgeStyle.valueOf((String)badgeStyle.toString());
    }

    private BadgeIconPosition mapBadgePosition(io.mateu.core.domain.uidefinition.shared.data.BadgeIconPosition iconPosition) {
        return BadgeIconPosition.valueOf((String)iconPosition.toString());
    }

    private boolean isObserved(io.mateu.core.domain.model.reflection.fieldabstraction.Field field) {
        return field.isAnnotationPresent(CallActionOnChange.class);
    }

    private String getCssClassNames(io.mateu.core.domain.model.reflection.fieldabstraction.Field field) {
        if (field.isAnnotationPresent(StyleClassNames.class)) {
            return String.join((CharSequence)" ", field.getAnnotation(StyleClassNames.class).value());
        }
        return null;
    }

    private String getPlaceholder(io.mateu.core.domain.model.reflection.fieldabstraction.Field field) {
        if (field.isAnnotationPresent(Placeholder.class)) {
            return field.getAnnotation(Placeholder.class).value();
        }
        return null;
    }

    private void addValidations(Field field, io.mateu.core.domain.model.reflection.fieldabstraction.Field fieldInterfaced) {
        ArrayList<Validation> validations = new ArrayList<Validation>();
        this.addRequiredValidation(fieldInterfaced, validations);
        this.addPatternValidation(fieldInterfaced, validations);
        this.addMinValidation(fieldInterfaced, validations);
        this.addMaxValidation(fieldInterfaced, validations);
        field.setValidations(validations);
    }

    private void addMinValidation(io.mateu.core.domain.model.reflection.fieldabstraction.Field field, List<Validation> validations) {
        if (field.isAnnotationPresent(Min.class)) {
            validations.add(Validation.builder().type(ValidationType.Min).data((Object)field.getAnnotation(Min.class).value()).message(field.getAnnotation(Min.class).message()).build());
        }
    }

    private void addMaxValidation(io.mateu.core.domain.model.reflection.fieldabstraction.Field field, List<Validation> validations) {
        if (field.isAnnotationPresent(Max.class)) {
            validations.add(Validation.builder().type(ValidationType.Max).data((Object)field.getAnnotation(Max.class).value()).message(field.getAnnotation(Max.class).message()).build());
        }
    }

    private void addRequiredValidation(io.mateu.core.domain.model.reflection.fieldabstraction.Field field, List<Validation> validations) {
        if (field.isAnnotationPresent(NotEmpty.class) || field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotBlank.class)) {
            validations.add(Validation.builder().type(ValidationType.NotEmpty).data(null).message("Required field").build());
        }
    }

    private void addPatternValidation(io.mateu.core.domain.model.reflection.fieldabstraction.Field field, List<Validation> validations) {
        if (field.isAnnotationPresent(Pattern.class)) {
            validations.add(Validation.builder().type(ValidationType.Pattern).data((Object)field.getAnnotation(Pattern.class).regexp()).message(field.getAnnotation(Pattern.class).message()).build());
        }
    }

    private String getDescription(io.mateu.core.domain.model.reflection.fieldabstraction.Field field) {
        String description = null;
        if (field.isAnnotationPresent(Help.class)) {
            description = field.getAnnotation(Help.class).value();
        }
        return description;
    }

    public FieldMetadataBuilder(FieldAttributeBuilder fieldAttributeBuilder, FieldTypeMapper fieldTypeMapper, FieldStereotypeMapper fieldStereotypeMapper, ReflectionHelper reflectionHelper, CaptionProvider captionProvider) {
        this.fieldAttributeBuilder = fieldAttributeBuilder;
        this.fieldTypeMapper = fieldTypeMapper;
        this.fieldStereotypeMapper = fieldStereotypeMapper;
        this.reflectionHelper = reflectionHelper;
        this.captionProvider = captionProvider;
    }
}

